/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client;

import java.util.HashSet;
import java.util.Set;

public class StringTemplateBuilder {
    protected String keyPrefix;
    protected String keySufix;
    protected Set<String> keySet = new HashSet<String>();
    protected String sourceCode;

    public StringTemplateBuilder() {
        this("${", "}");
    }

    public StringTemplateBuilder(String keyPrefix, String keySufix) {
        this.keyPrefix = keyPrefix;
        this.keySufix = keySufix;
    }

    public void setTemplate(String template) {
        this.sourceCode = template;
        this.extractKeys();
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public String getKeySufix() {
        return this.keySufix;
    }

    public void setKeySufix(String keySufix) {
        this.keySufix = keySufix;
    }

    public String build() {
        return this.sourceCode;
    }

    public Set<String> keys() {
        return this.keySet;
    }

    public String asVar(String key) {
        return this.getKeyPrefix() + key + this.getKeySufix();
    }

    public StringTemplateBuilder replace(String key, String value) {
        this.sourceCode = this.sourceCode.replace(this.keyPrefix + key + this.keySufix, value);
        return this;
    }

    protected void extractKeys() {
        this.keySet.clear();
        if (this.sourceCode != null) {
            int idx = 0;
            int end = 0;
            while (idx != -1 && end != -1) {
                idx = this.sourceCode.indexOf(this.keyPrefix, end);
                end = this.sourceCode.indexOf(this.keySufix, idx + this.keyPrefix.length());
                if (idx == -1 || end == -1) continue;
                String key = this.sourceCode.substring(idx + 2, end);
                this.keySet.add(key);
            }
        }
    }
}

