/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.file;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.editor.LeafAttributeEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.common.client.resources.i18n.DashbuilderCommonConstants;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.client.mvp.UberView;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class FileUploadEditor
implements IsWidget,
LeafAttributeEditor<String> {
    Event<NotificationEvent> workbenchNotification;
    Event<ValueChangeEvent<String>> valueChangeEvent;
    public View view;
    String value;
    FileUploadEditorCallback callback;

    @Inject
    public FileUploadEditor(Event<ValueChangeEvent<String>> valueChangeEvent, Event<NotificationEvent> workbenchNotification, View view) {
        this.valueChangeEvent = valueChangeEvent;
        this.workbenchNotification = workbenchNotification;
        this.view = view;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setLoadingImageVisible(false);
        this.view.setFileUploadName("fileUpload");
    }

    public void configure(String fileUploadName, FileUploadEditorCallback callback) {
        this.view.setFileUploadName(fileUploadName);
        this.callback = callback;
    }

    public void addHelpContent(String title, String content, Placement placement) {
        this.view.addHelpContent(title, content, placement);
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors;
        StringBuilder sb = new StringBuilder();
        for (EditorError error : errors) {
            if (error.getEditor() != this) continue;
            sb.append("\n").append(error.getMessage());
        }
        boolean bl = hasErrors = sb.length() > 0;
        if (!hasErrors) {
            this.view.clearError();
            return;
        }
        this.view.showError(new SafeHtmlBuilder().appendEscaped(sb.substring(1)).toSafeHtml());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setValue(String value) {
        this.value = value;
        if (!this.isNullOrEmpty(this.view.getFileName())) {
            this.view.setFileLabelVisible(false);
        } else if (!this.isNullOrEmpty(value)) {
            int slash;
            int n = slash = value.lastIndexOf("/") != -1 ? value.lastIndexOf("/") : value.lastIndexOf("\\");
            if (slash == -1) {
                this.view.setFileLabelText(value);
            } else {
                this.view.setFileLabelText(value.substring(slash + 1));
            }
            this.view.setFileLabelVisible(true);
        }
    }

    public String getValue() {
        return this.value;
    }

    String getUploadFileName() {
        assert (this.callback != null);
        return this.callback.getUploadFileName();
    }

    String getUploadFileUrl() {
        assert (this.callback != null);
        return this.callback.getUploadFileUrl();
    }

    boolean onSubmit() {
        String fileName = this.view.getFileName();
        if (this.isNullOrEmpty(fileName)) {
            return false;
        }
        this.view.setFileUploadVisible(false);
        this.view.setLoadingImageVisible(true);
        return true;
    }

    void onSubmitComplete(String results) {
        this.view.clearError();
        this.view.setFileUploadVisible(true);
        this.view.setLoadingImageVisible(false);
        this.onValueChanged(this.view.getFileName());
        if ("OK".equalsIgnoreCase(results)) {
            this.workbenchNotification.fire((Object)new NotificationEvent(DashbuilderCommonConstants.INSTANCE.uploadSuccessful(), NotificationEvent.NotificationType.SUCCESS));
        } else if ("FAIL".equalsIgnoreCase(results)) {
            this.workbenchNotification.fire((Object)new NotificationEvent(DashbuilderCommonConstants.INSTANCE.uploadFailed(), NotificationEvent.NotificationType.ERROR));
        } else if ("FAIL - ALREADY EXISTS".equalsIgnoreCase(results)) {
            this.workbenchNotification.fire((Object)new NotificationEvent(DashbuilderCommonConstants.INSTANCE.uploadFailedAlreadyExists(), NotificationEvent.NotificationType.ERROR));
        }
    }

    void fileUploadHandler() {
        String _f = this.getUploadFileName();
        String _a = this.getUploadFileUrl();
        this.view.setFormAction(_a);
        this.setValue(_f);
        this.view.setFileLabelVisible(false);
        this.view.submit();
    }

    private boolean isNullOrEmpty(String fileName) {
        return fileName == null || "".equals(fileName);
    }

    void onValueChanged(String value) {
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        this.view.clearError();
        String before = this.value;
        this.value = value;
        this.valueChangeEvent.fire(new ValueChangeEvent<String>(this, before, this.value));
    }

    public void setAccept(String type) {
        this.view.setAccept(type);
    }

    public static interface FileUploadEditorCallback {
        public String getUploadFileName();

        public String getUploadFileUrl();
    }

    public static interface View
    extends UberView<FileUploadEditor> {
        public View addHelpContent(String var1, String var2, Placement var3);

        public View setFileUploadName(String var1);

        public View setFileUploadVisible(boolean var1);

        public View setFileLabelText(String var1);

        public View setFileLabelVisible(boolean var1);

        public View setLoadingImageVisible(boolean var1);

        public String getFileName();

        public View setFormAction(String var1);

        public View submit();

        public View showError(SafeHtml var1);

        public View clearError();

        public View setAccept(String var1);

        public View clear();
    }
}

