/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.file;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import junit.framework.Assert;
import org.dashbuilder.common.client.editor.AbstractEditorTest;
import org.dashbuilder.common.client.editor.file.FileUploadEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class FileUploadEditorTest
extends AbstractEditorTest {
    @Mock
    FileUploadEditor.View view;
    @Mock
    EventSourceMock<ValueChangeEvent<String>> valueChangeEvent;
    @Mock
    EventSourceMock<NotificationEvent> workbenchNotificationEvent;
    private FileUploadEditor presenter;

    @Override
    @Before
    public void setup() {
        this.presenter = new FileUploadEditor(this.valueChangeEvent, this.workbenchNotificationEvent, this.view);
        Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setLoadingImageVisible(false);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testConfigure() throws Exception {
        FileUploadEditor.FileUploadEditorCallback callback = (FileUploadEditor.FileUploadEditorCallback)Mockito.mock(FileUploadEditor.FileUploadEditorCallback.class);
        this.presenter.configure("f1", callback);
        Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
        Assert.assertEquals((Object)callback, (Object)this.presenter.callback);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFileUploadName("f1");
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setLoadingImageVisible(false);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testClearErrors() throws Exception {
        ArrayList errors = new ArrayList();
        this.presenter.showErrors(errors);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setLoadingImageVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
    }

    @Test
    public void testShowErrors() throws Exception {
        EditorError e1 = this.mockEditorError((Editor<?>)this.presenter, "m1");
        EditorError e2 = this.mockEditorError((Editor<?>)this.presenter, "m2");
        ArrayList<EditorError> errors = new ArrayList<EditorError>(2);
        errors.add(e1);
        errors.add(e2);
        this.presenter.showErrors(errors);
        ArgumentCaptor errorSafeHtmlCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showError((SafeHtml)errorSafeHtmlCaptor.capture());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setLoadingImageVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testAddHelpContent() throws Exception {
        String title = "title";
        String content = "content";
        Placement p = Placement.BOTTOM;
        this.presenter.addHelpContent("title", "content", p);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addHelpContent("title", "content", p);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setLoadingImageVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testValueSet() throws Exception {
        String newValue = "newValue";
        Mockito.when((Object)this.view.getFileName()).thenReturn((Object)"fff");
        this.presenter.setValue("newValue");
        Assert.assertEquals((String)"newValue", (String)this.presenter.getValue());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFileLabelVisible(false);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setLoadingImageVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testValueUnset() throws Exception {
        String newValue = "newValue";
        Mockito.when((Object)this.view.getFileName()).thenReturn(null);
        this.presenter.setValue("newValue");
        Assert.assertEquals((String)"newValue", (String)this.presenter.getValue());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFileLabelText("newValue");
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFileLabelVisible(true);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setLoadingImageVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testGetUploadFileName() throws Exception {
        FileUploadEditor.FileUploadEditorCallback callback;
        this.presenter.callback = callback = (FileUploadEditor.FileUploadEditorCallback)Mockito.mock(FileUploadEditor.FileUploadEditorCallback.class);
        this.presenter.getUploadFileName();
        ((FileUploadEditor.FileUploadEditorCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).getUploadFileName();
        ((FileUploadEditor.FileUploadEditorCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).getUploadFileUrl();
    }

    @Test
    public void testGetUploadFileUrl() throws Exception {
        FileUploadEditor.FileUploadEditorCallback callback;
        this.presenter.callback = callback = (FileUploadEditor.FileUploadEditorCallback)Mockito.mock(FileUploadEditor.FileUploadEditorCallback.class);
        this.presenter.getUploadFileUrl();
        ((FileUploadEditor.FileUploadEditorCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)1))).getUploadFileUrl();
        ((FileUploadEditor.FileUploadEditorCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.times((int)0))).getUploadFileName();
    }

    @Test
    public void testOnSubmitNull() throws Exception {
        Mockito.when((Object)this.view.getFileName()).thenReturn(null);
        boolean result = this.presenter.onSubmit();
        Assert.assertEquals((boolean)false, (boolean)result);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setLoadingImageVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testOnSubmit() throws Exception {
        Mockito.when((Object)this.view.getFileName()).thenReturn((Object)"ff");
        boolean result = this.presenter.onSubmit();
        Assert.assertEquals((boolean)true, (boolean)result);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFileUploadVisible(false);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setLoadingImageVisible(true);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
    }

    @Test
    public void testOnSubmitComplete() throws Exception {
        Mockito.when((Object)this.view.getFileName()).thenReturn((Object)"ff");
        this.presenter.onSubmitComplete("OK");
        Assert.assertEquals((String)"ff", (String)this.presenter.value);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addHelpContent(Matchers.anyString(), Matchers.anyString(), (Placement)Matchers.any(Placement.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileUploadName(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setFileUploadVisible(true);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelText(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFileLabelVisible(Matchers.anyBoolean());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setLoadingImageVisible(false);
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setFormAction(Matchers.anyString());
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).submit();
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((FileUploadEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clearError();
        ((EventSourceMock)Mockito.verify(this.workbenchNotificationEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ValueChangeEvent.class));
    }
}

