/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import java.util.ArrayList;
import org.dashbuilder.common.client.editor.AbstractEditorTest;
import org.dashbuilder.common.client.editor.ToggleSwitchEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ToggleSwitchEditorTest
extends AbstractEditorTest {
    @Mock
    ToggleSwitchEditor.View view;
    @Mock
    EventSourceMock<ValueChangeEvent<Boolean>> valueChangeEvent;
    private ToggleSwitchEditor presenter;

    @Override
    @Before
    public void setup() {
        this.presenter = new ToggleSwitchEditor(this.view, this.valueChangeEvent);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Boolean.valueOf(Matchers.anyBoolean()));
    }

    @Test
    public void testClearErrors() throws Exception {
        ArrayList errors = new ArrayList();
        this.presenter.showErrors(errors);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Boolean.valueOf(Matchers.anyBoolean()));
    }

    @Test
    public void testShowErrors() throws Exception {
        EditorError e1 = this.mockEditorError((Editor<?>)this.presenter, "m1");
        EditorError e2 = this.mockEditorError((Editor<?>)this.presenter, "m2");
        ArrayList<EditorError> errors = new ArrayList<EditorError>(2);
        errors.add(e1);
        errors.add(e2);
        this.presenter.showErrors(errors);
        ArgumentCaptor errorSafeHtmlCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showError((SafeHtml)errorSafeHtmlCaptor.capture());
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Boolean.valueOf(Matchers.anyBoolean()));
        SafeHtml value = (SafeHtml)errorSafeHtmlCaptor.getValue();
        Assert.assertEquals((Object)"m1\nm2", (Object)value.asString());
    }

    @Test
    public void testEnabled() throws Exception {
        this.presenter.setEnabled(true);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEnabled(Boolean.valueOf(true));
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(Boolean.valueOf(Matchers.anyBoolean()));
    }

    @Test
    public void testValue() throws Exception {
        Boolean newValue = true;
        this.presenter.setValue(newValue);
        junit.framework.Assert.assertEquals((Object)newValue, (Object)this.presenter.getValue());
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setValue(newValue);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
    }

    @Test
    public void testOnValueChanged() throws Exception {
        Boolean newValue = true;
        this.presenter.onValueChanged(newValue);
        junit.framework.Assert.assertEquals((Object)newValue, (Object)this.presenter.getValue());
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setValue(newValue);
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ToggleSwitchEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ValueChangeEvent.class));
    }
}

