/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import java.util.ArrayList;
import org.dashbuilder.common.client.editor.AbstractEditorTest;
import org.dashbuilder.common.client.editor.ValueBoxEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ValueBoxEditorTest
extends AbstractEditorTest {
    @Mock
    ValueBoxEditor.View<String> view;
    @Mock
    EventSourceMock<ValueChangeEvent<String>> valueChangeEvent;
    private ValueBoxEditor<String> presenter;

    @Override
    @Before
    public void setup() {
        this.presenter = new ValueBoxEditor(this.view, this.valueChangeEvent);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).init(this.presenter);
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).setValue((Object)Matchers.anyString());
    }

    @Test
    public void testClearErrors() throws Exception {
        ArrayList errors = new ArrayList();
        this.presenter.showErrors(errors);
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(this.presenter);
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).setValue((Object)Matchers.anyString());
    }

    @Test
    public void testShowErrors() throws Exception {
        EditorError e1 = this.mockEditorError((Editor<?>)this.presenter, "m1");
        EditorError e2 = this.mockEditorError((Editor<?>)this.presenter, "m2");
        ArrayList<EditorError> errors = new ArrayList<EditorError>(2);
        errors.add(e1);
        errors.add(e2);
        this.presenter.showErrors(errors);
        ArgumentCaptor errorSafeHtmlCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).showError((SafeHtml)errorSafeHtmlCaptor.capture());
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(this.presenter);
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).setValue((Object)Matchers.anyString());
        SafeHtml value = (SafeHtml)errorSafeHtmlCaptor.getValue();
        Assert.assertEquals((Object)"m1\nm2", (Object)value.asString());
    }

    @Test
    public void testAddHelpContent() throws Exception {
        String title = "title";
        String content = "content";
        Placement p = Placement.BOTTOM;
        this.presenter.addHelpContent("title", "content", p);
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).addHelpContent("title", "content", p);
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).setValue((Object)Matchers.anyString());
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(this.presenter);
    }

    @Test
    public void testValue() throws Exception {
        String newValue = "newValue";
        this.presenter.setValue((Object)"newValue");
        junit.framework.Assert.assertEquals((String)"newValue", (String)((String)this.presenter.getValue()));
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).setValue((Object)"newValue");
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(this.presenter);
    }

    @Test
    public void testOnValueChanged() throws Exception {
        String newValue = "newValue";
        this.presenter.onValueChanged((Object)"newValue");
        junit.framework.Assert.assertEquals((String)"newValue", (String)((String)this.presenter.getValue()));
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).setValue((Object)"newValue");
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)Matchers.any(SafeHtml.class));
        ((ValueBoxEditor.View)Mockito.verify(this.view, (VerificationMode)Mockito.times((int)0))).init(this.presenter);
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(Matchers.any(ValueChangeEvent.class));
    }
}

