/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import javax.inject.Inject;
import org.dashbuilder.common.client.widgets.AlertBox;
import org.jboss.errai.common.client.dom.Button;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Templated
public class AlertBoxView
implements AlertBox.View,
IsElement {
    @Inject
    @DataField
    Div alertDiv;
    @Inject
    @DataField
    Button closeButton;
    @Inject
    @DataField
    Span alertIcon;
    @Inject
    @DataField
    Span alertMessage;
    AlertBox presenter;
    private static final String[] ALERT_CLASS = new String[]{"alert-danger", "alert-warning", "alert-success", "alert-info"};
    private static final String[] ALERT_ICON = new String[]{"pficon-error-circle-o", "pficon-warning-triangle-o", "pficon-ok", "pficon-info"};

    public void init(AlertBox presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setMessage(String text) {
        this.alertMessage.setTextContent(text);
    }

    @Override
    public void setLevel(AlertBox.Level level) {
        String _alertClass = ALERT_CLASS[level.ordinal()];
        String _alertIcon = ALERT_ICON[level.ordinal()];
        this.alertDiv.setClassName("alert " + _alertClass);
        this.alertIcon.setClassName("pficon " + _alertIcon);
    }

    @Override
    public void setCloseEnabled(boolean enabled) {
        this.closeButton.setHidden(!enabled);
    }

    @EventHandler(value={"closeButton"})
    private void onClose(ClickEvent event) {
        this.presenter.close();
    }
}

