/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.list;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.editor.LeafAttributeEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchCallback;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchDropDown;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchResults;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchService;
import org.uberfire.ext.widgets.common.client.dropdown.SingleLiveSearchSelectionHandler;

@Dependent
public class DropDownEditor
implements IsWidget,
LeafAttributeEditor<String> {
    public View view;
    LiveSearchDropDown<String> dropDown;
    LiveSearchService<String> searchService = new LiveSearchService<String>(){

        public void search(String pattern, int maxResults, LiveSearchCallback<String> callback) {
            DropDownEditor.this.getDropDownEntries(pattern, maxResults, callback);
        }

        public void searchEntry(String key, LiveSearchCallback<String> callback) {
        }
    };
    SingleLiveSearchSelectionHandler<String> selectionHandler = new SingleLiveSearchSelectionHandler();
    Event<ValueChangeEvent<String>> valueChangeEvent;
    Collection<Entry> entries = new ArrayList<Entry>();
    String selectorHint;
    String value;

    @Inject
    public DropDownEditor(View view, LiveSearchDropDown dropDown, Event<ValueChangeEvent<String>> valueChangeEvent) {
        this.view = view;
        this.dropDown = dropDown;
        this.valueChangeEvent = valueChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setDropDown(this.dropDown);
        this.dropDown.setClearSelectionEnabled(false);
        this.dropDown.setSearchEnabled(false);
        this.dropDown.init(this.searchService, this.selectionHandler);
        this.dropDown.setOnChange(this::onEntrySelected);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void getDropDownEntries(String pattern, int maxResults, LiveSearchCallback<String> callback) {
        LiveSearchResults results = new LiveSearchResults();
        this.entries.stream().filter(e -> e.getHint().contains(pattern)).forEach(e -> results.add(e.getValue(), e.getHint()));
        callback.afterSearch(results);
    }

    public void getExactEntry(String key, LiveSearchCallback<String> callback) {
        LiveSearchResults results = new LiveSearchResults(1);
        this.entries.stream().filter(e -> e.getValue().equals(key)).findAny().ifPresent(e -> results.add(e.getValue(), e.getHint()));
        callback.afterSearch(results);
    }

    public void onEntrySelected() {
        String oldValue = this.value;
        this.value = this.getSelectedValue();
        this.valueChangeEvent.fire(new ValueChangeEvent<String>(this, oldValue, this.value));
    }

    public String getSelectedValue() {
        String hint = this.selectionHandler.getSelectedValue();
        Entry entry = this.getEntryByHint(hint);
        return entry.getValue();
    }

    private Entry getEntryByHint(String hint) {
        for (Entry entry : this.entries) {
            if (!entry.getHint().equals(hint)) continue;
            return entry;
        }
        return null;
    }

    private Entry getEntryByValue(String value) {
        for (Entry entry : this.entries) {
            if (!entry.getValue().equals(value)) continue;
            return entry;
        }
        return null;
    }

    public void setSelectHint(String hint) {
        this.selectorHint = hint;
        this.dropDown.setSelectorHint(hint);
    }

    public Entry newEntry(String value, String hint) {
        return new Entry(value, hint);
    }

    public void setEntries(Collection<Entry> entries) {
        this.entries.clear();
        if (entries != null) {
            for (Entry entry : entries) {
                this.entries.add(entry);
                if (!entry.getValue().equals(this.value)) continue;
                this.dropDown.setSelectedItem((Object)entry.getValue());
            }
        }
    }

    public void addHelpContent(String title, String content, Placement placement) {
        this.view.addHelpContent(title, content, placement);
    }

    public void clear() {
        this.entries.clear();
        this.value = null;
        this.dropDown.clear();
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors;
        StringBuilder sb = new StringBuilder();
        for (EditorError error : errors) {
            if (!error.getEditor().equals(this)) continue;
            sb.append("\n").append(error.getMessage());
        }
        boolean bl = hasErrors = sb.length() > 0;
        if (!hasErrors) {
            this.view.clearError();
            return;
        }
        this.view.showError(new SafeHtmlBuilder().appendEscaped(sb.substring(1)).toSafeHtml());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        Entry entry = this.getEntryByValue(value);
        if (entry != null) {
            this.dropDown.setSelectedItem((Object)value);
        } else {
            this.dropDown.setSelectedItem((Object)this.selectorHint);
        }
    }

    public class Entry {
        private String value;
        private String hint;

        public Entry(String value, String hint) {
            this.value = value;
            this.hint = hint;
        }

        public String getValue() {
            return this.value;
        }

        public String getHint() {
            return this.hint;
        }
    }

    public static interface View
    extends UberView<DropDownEditor> {
        public View addHelpContent(String var1, String var2, Placement var3);

        public View setDropDown(LiveSearchDropDown var1);

        public View showError(SafeHtml var1);

        public View clearError();
    }
}

