/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.map;

import com.google.gwt.editor.client.Editor;
import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.common.client.editor.AbstractEditorTest;
import org.dashbuilder.common.client.editor.map.MapEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class MapEditorTest
extends AbstractEditorTest {
    @Mock
    MapEditor.View view;
    @Mock
    EventSourceMock<ValueChangeEvent<Map<String, String>>> valueChangeEvent;
    private MapEditor presenter;

    @Override
    @Before
    public void setup() {
        this.presenter = new MapEditor(this.view, this.valueChangeEvent);
        junit.framework.Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.asWidget());
    }

    @Test
    public void testInit() throws Exception {
        this.presenter.init();
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).init((Object)this.presenter);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setAddText(ArgumentMatchers.anyString());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEmptyText(ArgumentMatchers.anyString());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addButtonColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addTextColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setData(ArgumentMatchers.anyList());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRowCount(ArgumentMatchers.anyInt());
    }

    @Test
    public void testClearErrors() throws Exception {
        ArrayList errors = new ArrayList();
        this.presenter.showErrors(errors);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddText(ArgumentMatchers.anyString());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEmptyText(ArgumentMatchers.anyString());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButtonColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addTextColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setData(ArgumentMatchers.anyList());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRowCount(ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(ArgumentMatchers.anyInt());
    }

    @Test
    public void testShowErrors() throws Exception {
        EditorError e1 = this.mockEditorError((Editor<?>)this.presenter, "m1");
        EditorError e2 = this.mockEditorError((Editor<?>)this.presenter, "m2");
        ArrayList<EditorError> errors = new ArrayList<EditorError>(2);
        errors.add(e1);
        errors.add(e2);
        this.presenter.showErrors(errors);
        ArgumentCaptor errorSafeHtmlCaptor = ArgumentCaptor.forClass(SafeHtml.class);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).showError((SafeHtml)errorSafeHtmlCaptor.capture());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).clearError();
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddText(ArgumentMatchers.anyString());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setEmptyText(ArgumentMatchers.anyString());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addButtonColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).addTextColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setData(ArgumentMatchers.anyList());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setRowCount(ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).removeColumn(ArgumentMatchers.anyInt());
        SafeHtml value = (SafeHtml)errorSafeHtmlCaptor.getValue();
        Assert.assertEquals((Object)"m1\nm2", (Object)value.asString());
    }

    @Test
    public void testValue() throws Exception {
        HashMap<String, String> value = new HashMap<String, String>(1);
        value.put("key1", "value1");
        this.presenter.setValue(value);
        junit.framework.Assert.assertEquals(value, (Object)this.presenter.getValue());
        this.assertSetViewValue(1);
    }

    @Test
    public void testUpdateKey() throws Exception {
        HashMap<String, String> value = new HashMap<String, String>(1);
        value.put("key1", "value1");
        this.presenter.value = value;
        Map.Entry entry = (Map.Entry)Mockito.mock(Map.Entry.class);
        Mockito.when(entry.getKey()).thenReturn((Object)"key1");
        this.presenter.update(0, 0, entry, "key2");
        junit.framework.Assert.assertEquals((int)1, (int)this.presenter.getValue().size());
        junit.framework.Assert.assertEquals((String)"value1", (String)((String)this.presenter.getValue().get("key2")));
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(ValueChangeEvent.class));
        this.assertSetViewValue(1);
    }

    @Test
    public void testUpdateValue() throws Exception {
        HashMap<String, String> value = new HashMap<String, String>(1);
        value.put("key1", "value1");
        this.presenter.value = value;
        Map.Entry entry = (Map.Entry)Mockito.mock(Map.Entry.class);
        Mockito.when(entry.getKey()).thenReturn((Object)"key1");
        Mockito.when(entry.getValue()).thenReturn((Object)"value1");
        this.presenter.update(1, 0, entry, "value2");
        junit.framework.Assert.assertEquals((int)1, (int)this.presenter.getValue().size());
        junit.framework.Assert.assertEquals((String)"value2", (String)((String)this.presenter.getValue().get("key1")));
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(ValueChangeEvent.class));
        this.assertSetViewValue(1);
    }

    @Test
    public void testRemoveEntry() throws Exception {
        HashMap<String, String> value = new HashMap<String, String>(1);
        value.put("key1", "value1");
        this.presenter.value = value;
        Map.Entry entry = (Map.Entry)Mockito.mock(Map.Entry.class);
        Mockito.when(entry.getKey()).thenReturn((Object)"key1");
        this.presenter.update(2, 0, entry, null);
        junit.framework.Assert.assertEquals((int)0, (int)this.presenter.getValue().size());
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(ValueChangeEvent.class));
        this.assertSetViewValue(0);
    }

    @Test
    public void testAddEntry() throws Exception {
        this.presenter.addEntry();
        junit.framework.Assert.assertEquals((int)1, (int)this.presenter.getValue().size());
        ((EventSourceMock)Mockito.verify(this.valueChangeEvent, (VerificationMode)Mockito.times((int)1))).fire(ArgumentMatchers.any(ValueChangeEvent.class));
        this.assertSetViewValue(1);
    }

    protected void assertSetViewValue(int size) {
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)3))).removeColumn(0);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).clearError();
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).addButtonColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).addTextColumn(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setEmptyText(ArgumentMatchers.anyString());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setRowCount(size);
        ArgumentCaptor dataCaptor = ArgumentCaptor.forClass(List.class);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setData((List)dataCaptor.capture());
        List dataValue = (List)dataCaptor.getValue();
        junit.framework.Assert.assertNotNull((Object)dataValue);
        junit.framework.Assert.assertEquals((int)size, (int)dataValue.size());
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).init((Object)this.presenter);
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).showError((SafeHtml)ArgumentMatchers.any(SafeHtml.class));
        ((MapEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setAddText(ArgumentMatchers.anyString());
    }
}

