/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiChild;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.editor.LeafAttributeEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ValueBoxEditor<T>
implements IsWidget,
LeafAttributeEditor<T> {
    Event<ValueChangeEvent<T>> valueChangeEvent;
    public View<T> view;
    T value;

    @Inject
    public ValueBoxEditor(View<T> view, Event<ValueChangeEvent<T>> valueChangeEvent) {
        this.view = view;
        this.valueChangeEvent = valueChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public void addHelpContent(String title, String content, Placement placement) {
        this.view.addHelpContent(title, content, placement);
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors;
        StringBuilder sb = new StringBuilder();
        for (EditorError error : errors) {
            if (error.getEditor() != this) continue;
            sb.append("\n").append(error.getMessage());
        }
        boolean bl = hasErrors = sb.length() > 0;
        if (!hasErrors) {
            this.view.clearError();
            return;
        }
        this.view.showError(new SafeHtmlBuilder().appendEscaped(sb.substring(1)).toSafeHtml());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setValue(T value) {
        this.value = value;
        this.view.setValue(value);
    }

    public T getValue() {
        return this.value;
    }

    void onValueChanged(T value) {
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        this.view.clearError();
        T before = this.value;
        this.value = value;
        this.valueChangeEvent.fire(new ValueChangeEvent<T>(this, before, this.value));
    }

    public static interface View<T>
    extends UberView<ValueBoxEditor<T>> {
        @UiChild(limit=1, tagname="valuebox")
        public void setValueBox(ValueBoxBase<T> var1);

        public View<T> addHelpContent(String var1, String var2, Placement var3);

        public View<T> setValue(T var1);

        public View<T> showError(SafeHtml var1);

        public View<T> clearError();
    }
}

