/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.editor.client.Editor;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.dashbuilder.common.client.editor.list.ImageListEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditorView;
import org.gwtbootstrap3.client.ui.Image;
import org.gwtbootstrap3.client.ui.Tooltip;
import org.gwtbootstrap3.client.ui.constants.Placement;
import org.uberfire.mvp.Command;

@Dependent
public class HorizImageListEditorView<T>
extends Composite
implements ImageListEditorView<T> {
    @UiField
    HorizImageListEditorViewStyle style;
    @UiField
    @Editor.Ignore
    HTMLPanel errorPanel;
    @UiField
    @Editor.Ignore
    FlowPanel helpPanel;
    @UiField
    @Editor.Ignore
    HorizontalPanel mainPanel;
    @UiField
    @Editor.Ignore
    Tooltip errorTooltip;
    ImageListEditor<T> presenter;

    public void init(ImageListEditor<T> presenter) {
        this.presenter = presenter;
    }

    @UiConstructor
    public HorizImageListEditorView() {
        this.initWidget((Widget)Binder.BINDER.createAndBindUi(this));
    }

    @Override
    public ImageListEditorView<T> add(SafeUri uri, String width, String height, SafeHtml heading, SafeHtml text, boolean selected, Command clickCommand) {
        VerticalPanel panel = new VerticalPanel();
        panel.setVerticalAlignment(HasAlignment.ALIGN_MIDDLE);
        panel.setHeight("100%");
        Image image = new Image(uri);
        image.setWidth(width);
        image.setHeight(height);
        image.addStyleName(this.style.image());
        double alpha = selected ? 1.0 : 0.2;
        image.getElement().setAttribute("style", "filter: alpha(opacity=5);opacity: " + alpha);
        Tooltip tooltip = new Tooltip();
        tooltip.setTitle(text.asString());
        tooltip.setWidget((Widget)image);
        tooltip.setContainer("body");
        tooltip.setPlacement(Placement.BOTTOM);
        tooltip.setIsAnimated(false);
        tooltip.setShowDelayMs(100);
        HTML label = new HTML(heading.asString());
        HorizontalPanel labelPanel = new HorizontalPanel();
        labelPanel.setWidth("100%");
        labelPanel.setHorizontalAlignment(HasAlignment.ALIGN_CENTER);
        labelPanel.add((Widget)label);
        panel.add((IsWidget)tooltip);
        panel.add((Widget)labelPanel);
        this.mainPanel.add((Widget)panel);
        image.addClickHandler(e -> {
            tooltip.hide();
            tooltip.destroy();
            clickCommand.execute();
        });
        return this;
    }

    @Override
    public ImageListEditorView<T> setHelpContent(String title, String content, Placement placement) {
        Tooltip tooltip = new Tooltip((Widget)this.mainPanel);
        tooltip.setContainer("body");
        tooltip.setShowDelayMs(1000);
        tooltip.setPlacement(placement);
        tooltip.setTitle(content);
        this.helpPanel.add((IsWidget)tooltip);
        return this;
    }

    @Override
    public ImageListEditorView<T> showError(SafeHtml message) {
        this.errorTooltip.setTitle(message.asString());
        this.errorPanel.removeStyleName(this.style.errorPanel());
        this.errorPanel.addStyleName(this.style.errorPanelWithError());
        return null;
    }

    @Override
    public ImageListEditorView<T> clearError() {
        this.errorTooltip.setTitle("");
        this.errorPanel.removeStyleName(this.style.errorPanelWithError());
        this.errorPanel.addStyleName(this.style.errorPanel());
        return this;
    }

    @Override
    public ImageListEditorView<T> clear() {
        this.clearError();
        this.mainPanel.clear();
        return this;
    }

    static interface HorizImageListEditorViewStyle
    extends CssResource {
        public String errorPanel();

        public String errorPanelWithError();

        public String image();
    }

    static interface Binder
    extends UiBinder<Widget, HorizImageListEditorView> {
        public static final Binder BINDER = (Binder)GWT.create(Binder.class);
    }
}

