/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.list;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeUri;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import org.dashbuilder.common.client.editor.LeafAttributeEditor;
import org.dashbuilder.common.client.editor.list.ImageListEditorView;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.gwtbootstrap3.client.ui.constants.Placement;

public abstract class ImageListEditor<T>
implements IsWidget,
LeafAttributeEditor<T> {
    private static final String IMAGE_SIZE = "160px";
    Event<ValueChangeEvent<T>> valueChangeEvent;
    public ImageListEditorView<T> view;
    final List<Entry> entries = new ArrayList<Entry>();
    String imageWidth = "160px";
    String imageHeight = "160px";
    T value;

    public ImageListEditor(ImageListEditorView<T> view, Event<ValueChangeEvent<T>> valueChangeEvent) {
        this.view = view;
        this.valueChangeEvent = valueChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public Entry newEntry(T value, SafeUri uri, SafeHtml heading, SafeHtml text) {
        return new Entry(value, uri, heading, text);
    }

    public void setEntries(Collection<Entry> entries) {
        this.entries.clear();
        if (entries != null) {
            this.entries.addAll(entries);
        }
        this.showElements();
    }

    public void setImageSize(String w, String h) {
        this.imageWidth = w;
        this.imageHeight = h;
    }

    public void setHelpContent(String title, String content, Placement placement) {
        this.view.setHelpContent(title, content, placement);
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors;
        StringBuilder sb = new StringBuilder();
        for (EditorError error : errors) {
            if (!error.getEditor().equals(this)) continue;
            sb.append("\n").append(error.getMessage());
        }
        boolean bl = hasErrors = sb.length() > 0;
        if (!hasErrors) {
            this.view.clearError();
            return;
        }
        this.view.showError(new SafeHtmlBuilder().appendEscaped(sb.substring(1)).toSafeHtml());
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.setValue(value, false);
    }

    public void setValue(T value, boolean fireEvents) {
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        T before = this.value;
        this.value = value;
        this.showElements();
        if (fireEvents) {
            this.valueChangeEvent.fire(new ValueChangeEvent<T>(this, before, this.value));
        }
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void clear() {
        this.entries.clear();
        this.imageWidth = IMAGE_SIZE;
        this.imageHeight = IMAGE_SIZE;
        this.value = null;
        this.view.clear();
    }

    protected void showElements() {
        this.view.clear();
        for (Entry entry : this.entries) {
            boolean selected = this.value == null || entry.getValue().equals(this.value);
            this.view.add(entry.getUri(), this.imageWidth, this.imageHeight, entry.getHeading(), entry.getText(), selected, () -> this.setValue(entry.getValue(), true));
        }
    }

    public class Entry {
        private T value;
        private SafeUri uri;
        private SafeHtml heading;
        private SafeHtml text;

        private Entry(T value, SafeUri uri, SafeHtml heading, SafeHtml text) {
            this.value = value;
            this.uri = uri;
            this.heading = heading;
            this.text = text;
        }

        public T getValue() {
            return this.value;
        }

        public SafeUri getUri() {
            return this.uri;
        }

        public SafeHtml getHeading() {
            return this.heading;
        }

        public SafeHtml getText() {
            return this.text;
        }
    }
}

