/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.common.client.editor.map;

import com.google.gwt.editor.client.EditorError;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.editor.LeafAttributeEditor;
import org.dashbuilder.common.client.event.ValueChangeEvent;
import org.dashbuilder.common.client.resources.i18n.DashbuilderCommonConstants;
import org.uberfire.client.mvp.UberView;

@Dependent
public class MapEditor
implements IsWidget,
LeafAttributeEditor<Map<String, String>> {
    Event<ValueChangeEvent<Map<String, String>>> valueChangeEvent;
    public View view;
    Map<String, String> value;

    @Inject
    public MapEditor(View view, Event<ValueChangeEvent<Map<String, String>>> valueChangeEvent) {
        this.view = view;
        this.valueChangeEvent = valueChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.setAddText(DashbuilderCommonConstants.INSTANCE.add());
        this.initDataGrid();
    }

    public void showErrors(List<EditorError> errors) {
        boolean hasErrors;
        StringBuilder sb = new StringBuilder();
        for (EditorError error : errors) {
            if (error.getEditor() != this) continue;
            sb.append("\n").append(error.getMessage());
        }
        boolean bl = hasErrors = sb.length() > 0;
        if (!hasErrors) {
            this.view.clearError();
            return;
        }
        this.view.showError(new SafeHtmlBuilder().appendEscaped(sb.substring(1)).toSafeHtml());
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void setValue(Map<String, String> value) {
        this.setValue(value, false);
    }

    public Map<String, String> getValue() {
        return this.value;
    }

    void addEntry() {
        this.onAddEntry();
    }

    String getValue(int columnIndex, Map.Entry<String, String> object) {
        if (columnIndex == 0) {
            return object.getKey();
        }
        if (columnIndex == 1) {
            return object.getValue();
        }
        return null;
    }

    void update(int columnIndex, int index, Map.Entry<String, String> object, String value) {
        if (columnIndex == 0) {
            this.onKeyUpdated(index, object, value);
        } else if (columnIndex == 1) {
            this.onValueUpdated(index, object, value);
        } else if (columnIndex == 2) {
            this.onRemoveEntry(object);
        }
    }

    private void onKeyUpdated(int index, Map.Entry<String, String> object, String value) {
        LinkedHashMap<String, String> _m = new LinkedHashMap<String, String>((Map<String, String>)this.getValue());
        String lastKeyValue = object.getKey();
        String mapValue = "";
        if (lastKeyValue != null) {
            mapValue = (String)_m.remove(lastKeyValue);
        }
        _m.put(value, mapValue);
        this.setValue(_m, true);
    }

    private void onValueUpdated(int index, Map.Entry<String, String> object, String value) {
        String key = this.getKeyParameter(index);
        LinkedHashMap<String, String> _m = new LinkedHashMap<String, String>((Map<String, String>)this.getValue());
        _m.put(key, value);
        this.setValue(_m, true);
    }

    private void onRemoveEntry(Map.Entry<String, String> object) {
        if (this.getValue() != null) {
            LinkedHashMap<String, String> _m = new LinkedHashMap<String, String>((Map<String, String>)this.getValue());
            _m.remove(object.getKey());
            this.setValue(_m, true);
        }
    }

    private void onAddEntry() {
        String key = DashbuilderCommonConstants.INSTANCE.newValue();
        String value = DashbuilderCommonConstants.INSTANCE.newValue();
        LinkedHashMap<String, String> _m = new LinkedHashMap<String, String>();
        _m.put(key, value);
        if (this.getValue() != null) {
            _m.putAll((Map<String, String>)this.getValue());
        }
        this.setValue(_m, true);
    }

    private void setValue(Map<String, String> value, boolean fireEvents) {
        this.view.clearError();
        Map<String, String> before = this.value;
        this.value = value;
        this.redraw();
        if (fireEvents) {
            this.valueChangeEvent.fire(new ValueChangeEvent<Map<String, String>>(this, before, value));
        }
    }

    private void initDataGrid() {
        this.view.setEmptyText(DashbuilderCommonConstants.INSTANCE.noData());
        this.addColumns();
    }

    private void addColumns() {
        this.view.addTextColumn(0, DashbuilderCommonConstants.INSTANCE.key(), false, 20);
        this.view.addTextColumn(1, DashbuilderCommonConstants.INSTANCE.value(), false, 20);
        this.view.addButtonColumn(2, DashbuilderCommonConstants.INSTANCE.actions(), 20);
    }

    private String getKeyParameter(int index) {
        if (this.getValue() != null && !this.getValue().isEmpty() && index > -1) {
            int x = 0;
            for (Map.Entry entry : this.getValue().entrySet()) {
                if (index == x) {
                    return (String)entry.getKey();
                }
                ++x;
            }
        }
        return null;
    }

    private void redraw() {
        this.view.removeColumn(0);
        this.view.removeColumn(0);
        this.view.removeColumn(0);
        this.initDataGrid();
        int count = this.value != null ? this.value.size() : 0;
        LinkedList<Map.Entry<String, String>> list = this.value != null ? new LinkedList<Map.Entry<String, String>>(this.value.entrySet()) : new LinkedList();
        this.view.setRowCount(count);
        this.view.setData(list);
    }

    public static interface View
    extends UberView<MapEditor> {
        public View setEmptyText(String var1);

        public View setAddText(String var1);

        public View addTextColumn(int var1, String var2, boolean var3, int var4);

        public View addButtonColumn(int var1, String var2, int var3);

        public View removeColumn(int var1);

        public View setRowCount(int var1);

        public View setData(List<Map.Entry<String, String>> var1);

        public View showError(SafeHtml var1);

        public View clearError();
    }
}

