/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.group;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public enum DateIntervalType {
    MILLISECOND,
    HUNDRETH,
    TENTH,
    SECOND,
    MINUTE,
    HOUR,
    DAY,
    DAY_OF_WEEK,
    WEEK,
    MONTH,
    QUARTER,
    YEAR,
    DECADE,
    CENTURY,
    MILLENIUM;

    public static List<DateIntervalType> FIXED_INTERVALS_SUPPORTED;
    private static final Map<DateIntervalType, Long> DURATION_IN_MILLIS;
    private static final DateIntervalType[] _typeArray;

    public int getIndex() {
        return this.ordinal();
    }

    public static DateIntervalType getByIndex(int index) {
        return _typeArray[index];
    }

    public static DateIntervalType getByName(String interval) {
        if (interval == null) {
            return null;
        }
        try {
            return DateIntervalType.valueOf(interval.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int compare(DateIntervalType interval1, DateIntervalType interval2) {
        long d1 = DateIntervalType.getDurationInMillis(interval1);
        long d2 = DateIntervalType.getDurationInMillis(interval2);
        return Long.valueOf(d1).compareTo(d2);
    }

    public static long getDurationInMillis(DateIntervalType type) {
        if (!DURATION_IN_MILLIS.containsKey((Object)type)) {
            return 0L;
        }
        return DURATION_IN_MILLIS.get((Object)type);
    }

    static {
        FIXED_INTERVALS_SUPPORTED = Arrays.asList(QUARTER, MONTH, DAY_OF_WEEK, HOUR, MINUTE, SECOND);
        DURATION_IN_MILLIS = new EnumMap<DateIntervalType, Long>(DateIntervalType.class);
        long milli = 1L;
        DURATION_IN_MILLIS.put(MILLISECOND, milli);
        long hundreth = 10L;
        DURATION_IN_MILLIS.put(HUNDRETH, hundreth);
        long tenth = 100L;
        DURATION_IN_MILLIS.put(TENTH, tenth);
        long second = 1000L;
        DURATION_IN_MILLIS.put(SECOND, second);
        long minute = second * 60L;
        DURATION_IN_MILLIS.put(MINUTE, minute);
        long hour = minute * 60L;
        DURATION_IN_MILLIS.put(HOUR, hour);
        long day = hour * 24L;
        DURATION_IN_MILLIS.put(DAY, day);
        DURATION_IN_MILLIS.put(DAY_OF_WEEK, day);
        long week = day * 7L;
        DURATION_IN_MILLIS.put(WEEK, week);
        long month = day * 31L;
        DURATION_IN_MILLIS.put(MONTH, month);
        long quarter = month * 3L;
        DURATION_IN_MILLIS.put(QUARTER, quarter);
        long year = month * 12L;
        DURATION_IN_MILLIS.put(YEAR, year);
        long decade = year * 10L;
        DURATION_IN_MILLIS.put(DECADE, decade);
        long century = year * 100L;
        DURATION_IN_MILLIS.put(CENTURY, century);
        long millenium = year * 1000L;
        DURATION_IN_MILLIS.put(MILLENIUM, millenium);
        _typeArray = DateIntervalType.values();
    }
}

