/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.impl;

import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetBuilder;
import org.dashbuilder.dataset.DataSetFactory;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class DataSetBuilderImpl
implements DataSetBuilder {
    protected DataSet dataSet = DataSetFactory.newEmptyDataSet();

    @Override
    public DataSetBuilderImpl uuid(String uuid) {
        this.dataSet.setUUID(uuid);
        return this;
    }

    @Override
    public DataSetBuilderImpl label(String columnId) {
        this.dataSet.addColumn(columnId, ColumnType.LABEL);
        return this;
    }

    @Override
    public DataSetBuilderImpl text(String columnId) {
        this.dataSet.addColumn(columnId, ColumnType.TEXT);
        return this;
    }

    @Override
    public DataSetBuilderImpl number(String columnId) {
        this.dataSet.addColumn(columnId, ColumnType.NUMBER);
        return this;
    }

    @Override
    public DataSetBuilderImpl date(String columnId) {
        this.dataSet.addColumn(columnId, ColumnType.DATE);
        return this;
    }

    @Override
    public DataSetBuilderImpl column(String columnId, ColumnType type) {
        this.dataSet.addColumn(columnId, type);
        return this;
    }

    @Override
    public DataSetBuilderImpl row(Object ... values) {
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            DataColumn column = this.dataSet.getColumnByIndex(i);
            column.getValues().add(value);
        }
        return this;
    }

    @Override
    public DataSet buildDataSet() {
        return this.dataSet;
    }
}

