/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.date;

import java.util.Date;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class TimeAmount {
    private long quantity = 1L;
    private DateIntervalType type = DateIntervalType.DAY;

    public TimeAmount() {
        this(1L, DateIntervalType.YEAR);
    }

    public TimeAmount(long quantity, DateIntervalType sizeType) {
        this.quantity = quantity;
        this.type = sizeType;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    public DateIntervalType getType() {
        return this.type;
    }

    public void setType(DateIntervalType type) {
        this.type = type;
    }

    public long toMillis() {
        return this.quantity * DateIntervalType.getDurationInMillis(this.type);
    }

    public String toString() {
        return this.quantity + " " + this.type.name().toLowerCase();
    }

    public TimeAmount cloneInstance() {
        TimeAmount clone = new TimeAmount();
        clone.quantity = this.quantity;
        clone.type = this.type;
        return clone;
    }

    public void adjustDate(Date d) {
        if (DateIntervalType.MILLENIUM.equals((Object)this.type)) {
            d.setYear(d.getYear() + (int)this.quantity * 1000);
        }
        if (DateIntervalType.CENTURY.equals((Object)this.type)) {
            d.setYear(d.getYear() + (int)this.quantity * 100);
        }
        if (DateIntervalType.DECADE.equals((Object)this.type)) {
            d.setYear(d.getYear() + (int)this.quantity * 10);
        }
        if (DateIntervalType.YEAR.equals((Object)this.type)) {
            d.setYear(d.getYear() + (int)this.quantity);
        }
        if (DateIntervalType.QUARTER.equals((Object)this.type)) {
            d.setMonth(d.getMonth() + (int)this.quantity * 3);
        }
        if (DateIntervalType.MONTH.equals((Object)this.type)) {
            d.setMonth(d.getMonth() + (int)this.quantity);
        }
        if (DateIntervalType.WEEK.equals((Object)this.type)) {
            d.setDate(d.getDate() + (int)this.quantity * 7);
        }
        if (DateIntervalType.DAY.equals((Object)this.type)) {
            d.setDate(d.getDate() + (int)this.quantity);
        }
        if (DateIntervalType.HOUR.equals((Object)this.type)) {
            d.setHours(d.getHours() + (int)this.quantity);
        }
        if (DateIntervalType.MINUTE.equals((Object)this.type)) {
            d.setMinutes(d.getMinutes() + (int)this.quantity);
        }
        if (DateIntervalType.SECOND.equals((Object)this.type)) {
            d.setSeconds(d.getSeconds() + (int)this.quantity);
        }
    }

    public static TimeAmount parse(String timeAmount) {
        char ch;
        int i;
        if (timeAmount == null || timeAmount.length() == 0) {
            throw new IllegalArgumentException("Empty time amount expression");
        }
        String number = "";
        String expr = timeAmount.trim();
        boolean isNegative = expr.startsWith("-");
        boolean isPositive = expr.startsWith("+");
        int n = i = isNegative || isPositive ? 1 : 0;
        while (i < expr.length() && Character.isDigit(ch = expr.charAt(i))) {
            number = number + ch;
            ++i;
        }
        String type = expr.substring(i).trim();
        DateIntervalType intervalType = DateIntervalType.getByName(type);
        if (number.length() == 0) {
            throw new IllegalArgumentException("Missing quantity (ex '-10year'): " + timeAmount);
        }
        if (intervalType == null) {
            throw new IllegalArgumentException("Invalid interval type (ex '-10year'): " + timeAmount);
        }
        return new TimeAmount(Long.parseLong(number) * (long)(isNegative ? -1 : 1), intervalType);
    }
}

