/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.impl.MemSizeEstimator;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class DataSetImpl
implements DataSet {
    protected DataSetDef definition;
    @NotNull(message="{dataSetApi_dataSetImpl_uuid_notNull}")
    protected String uuid = null;
    @NotNull(message="{dataSetApi_dataSetImpl_creationDate_notNull}")
    protected Date creationDate = new Date();
    protected List<DataColumnImpl> columns = new ArrayList<DataColumnImpl>();
    protected int rowCountNonTrimmed = -1;

    @Override
    public DataSetMetadata getMetadata() {
        return new DataSetMetadataImpl(this);
    }

    @Override
    public DataSetDef getDefinition() {
        return this.definition;
    }

    @Override
    public void setDefinition(DataSetDef definition) {
        this.definition = definition;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public List<DataColumn> getColumns() {
        return new ArrayList<DataColumn>(this.columns);
    }

    @Override
    public void setColumns(List<DataColumn> columnList) {
        this.columns.clear();
        for (DataColumn column : columnList) {
            this.columns.add((DataColumnImpl)column);
        }
    }

    @Override
    public DataColumn getColumnById(String id) {
        for (DataColumn dataColumn : this.columns) {
            if (dataColumn.getId().equals(id)) {
                return dataColumn;
            }
            GroupFunction gf = dataColumn.getGroupFunction();
            if (gf == null || gf.getSourceId() == null || !gf.getSourceId().equals(id)) continue;
            return dataColumn;
        }
        return null;
    }

    @Override
    public DataColumn getColumnByIndex(int index) {
        if (this.columns == null || this.columns.isEmpty()) {
            throw new IllegalArgumentException("The data set is empty.");
        }
        if (index >= this.columns.size()) {
            throw new IllegalArgumentException("The column index " + index + " is out of bounds: " + (this.columns.size() - 1));
        }
        return this.columns.get(index);
    }

    @Override
    public int getColumnIndex(DataColumn dataColumn) {
        if (dataColumn == null || "".equals(dataColumn.getId())) {
            throw new IllegalArgumentException("Wrong column specified.");
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            if (!dataColumn.getId().equalsIgnoreCase(this.columns.get(i).getId())) continue;
            return i;
        }
        throw new IllegalArgumentException("The column with id " + dataColumn.getId() + " does not exist.");
    }

    @Override
    public DataSet addColumn(String id, ColumnType type) {
        return this.addColumn(id, type, null);
    }

    @Override
    public DataSet addColumn(String id, ColumnType type, List values) {
        DataColumnImpl c = new DataColumnImpl();
        c.setDataSet(this);
        c.setId(id);
        c.setColumnType(type);
        if (values != null) {
            c.setValues(values);
        }
        this.columns.add(c);
        return this;
    }

    @Override
    public DataSet addColumn(DataColumn column) {
        this.columns.add((DataColumnImpl)column);
        return this;
    }

    @Override
    public DataSet removeColumn(String id) {
        Iterator<DataColumnImpl> it = this.columns.iterator();
        while (it.hasNext()) {
            DataColumn column = it.next();
            if (!column.getId().equals(id)) continue;
            it.remove();
        }
        return this;
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    @Override
    public int getRowCount() {
        if (this.columns == null || this.columns.isEmpty()) {
            return 0;
        }
        return this.columns.get(0).getValues().size();
    }

    @Override
    public int getRowCountNonTrimmed() {
        if (this.rowCountNonTrimmed == -1) {
            return this.getRowCount();
        }
        return this.rowCountNonTrimmed;
    }

    @Override
    public void setRowCountNonTrimmed(int rowCountNonTrimmed) {
        this.rowCountNonTrimmed = rowCountNonTrimmed;
    }

    @Override
    public Object getValueAt(int row, String columnId) {
        DataColumn columnObj = this.getColumnById(columnId);
        return this.getValueAt(row, columnObj);
    }

    @Override
    public Object getValueAt(int row, int column) {
        DataColumn columnObj = this.getColumnByIndex(column);
        return this.getValueAt(row, columnObj);
    }

    protected Object getValueAt(int row, DataColumn column) {
        if (row >= this.getRowCount()) {
            throw new IllegalArgumentException("The row index " + row + " is out of bounds: " + (this.getRowCount() - 1));
        }
        return column.getValues().get(row);
    }

    @Override
    public DataSet setValueAt(int row, int column, Object value) {
        this._setValueAt(row, column, value, false);
        return this;
    }

    public DataSet addValueAt(int row, int column, Object value) {
        this._setValueAt(row, column, value, true);
        return this;
    }

    public DataSet addValueAt(int column, Object value) {
        this._setValueAt(-1, column, value, true);
        return this;
    }

    protected void _setValueAt(int row, int column, Object value, boolean insert) {
        DataColumn columnObj = this.getColumnByIndex(column);
        List l = columnObj.getValues();
        if (row > l.size()) {
            throw new IllegalArgumentException("The row index " + row + " is out of bounds: " + (l.size() - 1));
        }
        if (row < 0 || row == l.size()) {
            l.add(value);
        } else if (insert) {
            l.add(row, value);
        } else {
            l.set(row, value);
        }
    }

    @Override
    public DataSet setValuesAt(int row, Object ... values) {
        this._setValuesAt(row, false, values);
        return this;
    }

    @Override
    public DataSet addValuesAt(int row, Object ... values) {
        this._setValuesAt(row, true, values);
        return this;
    }

    @Override
    public DataSet addValues(Object ... values) {
        this._setValuesAt(-1, true, values);
        return this;
    }

    protected void _setValuesAt(int row, boolean insert, Object ... values) {
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            this._setValueAt(row, i, value, insert);
        }
    }

    @Override
    public DataSet addEmptyRowAt(int row) {
        this._setEmptyRowAt(row, true);
        return this;
    }

    protected void _setEmptyRowAt(int row, boolean insert) {
        for (int i = 0; i < this.columns.size(); ++i) {
            DataColumn column = this.columns.get(i);
            if (ColumnType.DATE.equals((Object)column.getColumnType())) {
                this._setValueAt(row, i, new Date(), insert);
                continue;
            }
            if (ColumnType.NUMBER.equals((Object)column.getColumnType())) {
                this._setValueAt(row, i, 0.0, insert);
                continue;
            }
            this._setValueAt(row, i, "", insert);
        }
    }

    @Override
    public DataSet trim(int offset, int rows) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset can't be negative: " + offset);
        }
        if (offset == 0 && (rows <= 0 || rows >= this.getRowCount())) {
            this.rowCountNonTrimmed = -1;
            return this;
        }
        if (offset >= this.getRowCount()) {
            throw new IllegalArgumentException("Offset can't be greater than the number of rows: " + offset);
        }
        DataSetImpl other = this.cloneEmpty();
        other.rowCountNonTrimmed = this.getRowCount();
        for (int i = 0; i < this.columns.size(); ++i) {
            DataColumn column = this.columns.get(i);
            DataColumn colOther = other.getColumns().get(i);
            List values = column.getValues();
            List valOther = colOther.getValues();
            for (int j = offset; j < values.size() && j < offset + rows; ++j) {
                Object value = values.get(j);
                valOther.add(value);
            }
        }
        return other;
    }

    @Override
    public DataSet trim(List<Integer> rows) {
        if (rows == null) {
            return this;
        }
        DataSetImpl other = this.cloneEmpty();
        other.rowCountNonTrimmed = this.getRowCount();
        if (rows.isEmpty()) {
            return other;
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            List values = this.columns.get(i).getValues();
            List valOther = other.getColumns().get(i).getValues();
            for (Integer row : rows) {
                if (row >= values.size()) {
                    throw new IllegalArgumentException("Row number is out of bounds: " + row);
                }
                Object value = values.get(row);
                valOther.add(value);
            }
        }
        return other;
    }

    @Override
    public DataSetImpl cloneEmpty() {
        DataSetImpl other = new DataSetImpl();
        for (int i = 0; i < this.columns.size(); ++i) {
            DataColumn column = this.columns.get(i);
            DataColumn otherCol = column.cloneEmpty();
            other.addColumn(otherCol);
        }
        return other;
    }

    @Override
    public DataSetImpl cloneInstance() {
        DataSetImpl other = new DataSetImpl();
        for (int i = 0; i < this.columns.size(); ++i) {
            DataColumn column = this.columns.get(i);
            DataColumn otherCol = column.cloneInstance();
            other.addColumn(otherCol);
        }
        return other;
    }

    public boolean equals(Object obj) {
        try {
            DataSetImpl other = (DataSetImpl)obj;
            if (other == null) {
                return false;
            }
            if (this.getEstimatedSize() != other.getEstimatedSize()) {
                return false;
            }
            if (this.columns.size() != other.columns.size()) {
                return false;
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                if (this.columns.get(i).equals(other.columns.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public long getEstimatedSize() {
        int nrows = this.getRowCount();
        if (nrows == 0) {
            return 0L;
        }
        List<DataColumn> columns = this.getColumns();
        int ncells = nrows * columns.size();
        int result = ncells * 4;
        for (int i = 0; i < columns.size(); ++i) {
            Object firstRowValue = this.getValueAt(0, i);
            if (firstRowValue instanceof String) {
                for (int j = 0; j < nrows; ++j) {
                    String stringValue = (String)this.getValueAt(j, i);
                    result += MemSizeEstimator.sizeOfString(stringValue);
                }
                continue;
            }
            int singleValueSize = MemSizeEstimator.sizeOf(firstRowValue);
            result += nrows * singleValueSize;
        }
        return result;
    }
}

