/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.sort;

import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.impl.AbstractDataSetOp;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class DataSetSort
extends AbstractDataSetOp {
    protected List<ColumnSort> columnSortList = new ArrayList<ColumnSort>();

    @Override
    public DataSetOpType getType() {
        return DataSetOpType.SORT;
    }

    public void addSortColumn(ColumnSort ... columnSorts) {
        for (ColumnSort columnSort : columnSorts) {
            this.columnSortList.add(columnSort);
        }
    }

    public List<ColumnSort> getColumnSortList() {
        return this.columnSortList;
    }

    public DataSetSort invertOrder() {
        for (ColumnSort columnSort : this.getColumnSortList()) {
            SortOrder order = columnSort.getOrder();
            if (SortOrder.ASCENDING.equals((Object)order)) {
                columnSort.setOrder(SortOrder.DESCENDING);
                continue;
            }
            if (!SortOrder.DESCENDING.equals((Object)order)) continue;
            columnSort.setOrder(SortOrder.ASCENDING);
        }
        return this;
    }

    @Override
    public DataSetSort cloneInstance() {
        DataSetSort clone = new DataSetSort();
        for (ColumnSort columnSort : this.columnSortList) {
            clone.addSortColumn(columnSort.cloneInstance());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        try {
            DataSetSort other = (DataSetSort)obj;
            if (this.columnSortList.size() != other.columnSortList.size()) {
                return false;
            }
            for (int i = 0; i < this.columnSortList.size(); ++i) {
                ColumnSort otherEl;
                ColumnSort el = this.columnSortList.get(i);
                if (el.equals(otherEl = other.columnSortList.get(i))) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

