/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider;

import org.dashbuilder.dataset.def.BeanDataSetDef;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.def.StaticDataSetDef;

public enum DataSetProviderType {
    STATIC,
    BEAN,
    SQL,
    CSV,
    ELASTICSEARCH;


    public static DataSetProviderType getByName(String name) {
        try {
            return DataSetProviderType.valueOf(name.toUpperCase());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static DataSetDef createDataSetDef(DataSetProviderType type) {
        switch (type) {
            case STATIC: {
                return new StaticDataSetDef();
            }
            case BEAN: {
                return new BeanDataSetDef();
            }
            case CSV: {
                return new CSVDataSetDef();
            }
            case SQL: {
                return new SQLDataSetDef();
            }
            case ELASTICSEARCH: {
                return new ElasticSearchDataSetDef();
            }
        }
        throw new RuntimeException("Unknown type: " + (Object)((Object)type));
    }
}

