/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.def;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.validation.groups.BeanDataSetDefValidation;

public class BeanDataSetDef
extends DataSetDef {
    @NotNull(message="{dataSetApi_beanDataSetDef_generatorClass_notNull}", groups={BeanDataSetDefValidation.class})
    @Size(min=1, message="{dataSetApi_beanDataSetDef_generatorClass_notNull}", groups={BeanDataSetDefValidation.class})
    protected String generatorClass;
    protected Map<String, String> paramaterMap = new HashMap<String, String>();

    public BeanDataSetDef() {
        super.setProvider(DataSetProviderType.BEAN);
    }

    public String getGeneratorClass() {
        return this.generatorClass;
    }

    public void setGeneratorClass(String generatorClass) {
        this.generatorClass = generatorClass;
    }

    public Map<String, String> getParamaterMap() {
        return this.paramaterMap;
    }

    public void setParamaterMap(Map<String, String> paramaterMap) {
        this.paramaterMap = paramaterMap;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            BeanDataSetDef other = (BeanDataSetDef)obj;
            if (!super.equals(other)) {
                return false;
            }
            if (this.generatorClass != null && !this.generatorClass.equals(other.generatorClass)) {
                return false;
            }
            if (this.paramaterMap.size() != other.paramaterMap.size()) {
                return false;
            }
            for (String key : this.paramaterMap.keySet()) {
                String value = this.paramaterMap.get(key);
                if (!other.paramaterMap.containsKey(key)) {
                    return false;
                }
                if (other.paramaterMap.get(key).equals(value)) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public DataSetDef clone() {
        BeanDataSetDef def = new BeanDataSetDef();
        this.clone(def);
        def.setGeneratorClass(this.getGeneratorClass());
        def.setParamaterMap(this.getParamaterMap());
        return def;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append("UUID=").append(this.UUID).append("\n");
        out.append("Provider=").append(this.provider).append("\n");
        out.append("Public=").append(this.isPublic).append("\n");
        out.append("Push enabled=").append(this.pushEnabled).append("\n");
        out.append("Push max size=").append(this.pushMaxSize).append(" Kb\n");
        out.append("Generator class=").append(this.generatorClass).append("\n");
        for (String param : this.paramaterMap.keySet()) {
            out.append("Generator ").append(param).append("=").append(this.paramaterMap.get(param)).append("\n");
        }
        return out.toString();
    }
}

