/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import javax.enterprise.event.Event;
import org.dashbuilder.dataprovider.DataSetProviderRegistryCDI;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRegisteredEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;
import org.dashbuilder.dataset.impl.CSVDataSetDefBuilderImpl;
import org.dashbuilder.exception.ExceptionManager;
import org.dashbuilder.scheduler.SchedulerCDI;
import org.dashbuilder.test.BaseCDITest;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;

@RunWith(value=Arquillian.class)
public class DataSetDefRegistryCDITest
extends BaseCDITest {
    @Mock
    DataSetProviderRegistryCDI dataSetProviderRegistry;
    @Mock
    SchedulerCDI scheduler;
    @Mock
    ExceptionManager exceptionManager;
    @Mock
    Event<DataSetDefModifiedEvent> dataSetDefModifiedEvent;
    @Mock
    Event<DataSetDefRegisteredEvent> dataSetDefRegisteredEvent;
    @Mock
    Event<DataSetDefRemovedEvent> dataSetDefRemovedEvent;
    @Mock
    Event<DataSetStaleEvent> dataSetStaleEvent;
    DataSetDefRegistryCDI dataSetDefRegistry;
    public DataSetDef dataSetDef = ((CSVDataSetDefBuilderImpl)DataSetDefFactory.newCSVDataSetDef().uuid("testDset")).buildDef();

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.dataSetDefRegistry = (DataSetDefRegistryCDI)Mockito.spy((Object)new DataSetDefRegistryCDI(0xA00000, this.mockIOService(), this.dataSetProviderRegistry, this.scheduler, this.exceptionManager, this.dataSetDefModifiedEvent, this.dataSetDefRegisteredEvent, this.dataSetDefRemovedEvent, this.dataSetStaleEvent));
        Mockito.when((Object)this.dataSetDefRegistry.convert((Path)Mockito.any(Path.class))).thenReturn(Mockito.mock(org.uberfire.backend.vfs.Path.class));
        Mockito.when((Object)this.dataSetDefRegistry.convert((org.uberfire.backend.vfs.Path)Mockito.any(org.uberfire.backend.vfs.Path.class))).thenReturn(Mockito.mock(Path.class));
    }

    @Test
    public void testRegistryDataSetDef() throws Exception {
        this.dataSetDefRegistry.registerDataSetDef(this.dataSetDef);
        ((IOService)Mockito.verify((Object)this.getIOService())).write((Path)Mockito.any(Path.class), Mockito.anyString(), new OpenOption[0]);
        ((Event)Mockito.verify(this.dataSetDefRegisteredEvent)).fire(Mockito.any(DataSetDefRegisteredEvent.class));
    }

    @Test
    public void testDeleteDataSetDef() throws Exception {
        Mockito.when((Object)this.ioService.exists((Path)Mockito.any(Path.class))).thenReturn((Object)true);
        this.dataSetDefRegistry.registerDataSetDef(this.dataSetDef);
        this.dataSetDefRegistry.removeDataSetDef(this.dataSetDef.getUUID());
        ((IOService)Mockito.verify((Object)this.getIOService(), (VerificationMode)Mockito.atLeastOnce())).deleteIfExists((Path)Mockito.any(Path.class), new DeleteOption[]{(DeleteOption)Mockito.eq((Object)StandardDeleteOption.NON_EMPTY_DIRECTORIES)});
        ((Event)Mockito.verify(this.dataSetDefRemovedEvent)).fire(Mockito.any(DataSetDefRemovedEvent.class));
    }
}

