/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset;

import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import org.dashbuilder.dataset.DataSetDefDeployerCDI;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetDefDeployerCDITest {
    @Spy
    DataSetDefDeployerCDI dataSetDefDeployer;

    @Test
    public void testDataSetDirNotDetected() throws Exception {
        this.dataSetDefDeployer.init();
        ((DataSetDefDeployerCDI)Mockito.verify((Object)this.dataSetDefDeployer, (VerificationMode)Mockito.never())).deploy(Mockito.anyString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataSetDirDetected() throws Exception {
        File f = this.createMarkerFile("app.html.template");
        try {
            this.dataSetDefDeployer.init();
            ((DataSetDefDeployerCDI)Mockito.verify((Object)this.dataSetDefDeployer)).deploy(this.getDataSetsDir().getPath());
        }
        finally {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataSetDirDetected2() throws Exception {
        File f = this.createMarkerFile("security-management.properties");
        try {
            this.dataSetDefDeployer.init();
            ((DataSetDefDeployerCDI)Mockito.verify((Object)this.dataSetDefDeployer)).deploy(this.getDataSetsDir().getPath());
        }
        finally {
            f.delete();
        }
    }

    public File getDataSetsDir() throws Exception {
        URL testDsetUrl = Thread.currentThread().getContextClassLoader().getResource("WEB-INF/datasets/test.dset");
        return new File(testDsetUrl.getPath()).getParentFile();
    }

    public File createMarkerFile(String name) throws Exception {
        File webInfDir = this.getDataSetsDir().getParentFile();
        File classesDir = new File(webInfDir, "classes");
        classesDir.mkdir();
        File markerFile = new File(classesDir, name);
        if (!markerFile.exists()) {
            FileWriter out = new FileWriter(markerFile);
            out.write("test");
            out.close();
        }
        return markerFile;
    }
}

