/*
 * Decompiled with CFR 0.152.
 */
import javax.inject.Inject;
import org.dashbuilder.Bootstrap;
import org.dashbuilder.DataSetCore;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataprovider.DataSetProviderRegistryCDI;
import org.dashbuilder.dataset.DataSetDefDeployer;
import org.dashbuilder.dataset.DataSetDefDeployerCDI;
import org.dashbuilder.dataset.DataSetDefRegistryCDI;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.test.BaseCDITest;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;

@RunWith(value=Arquillian.class)
public class BootstrapTest
extends BaseCDITest {
    public static final String CSV_JSON = "{\n  \"uuid\": \"expenseReports\",\n  \"name\": \"Expense Reports\",\n  \"provider\": \"CSV\",\n}";
    @Inject
    Bootstrap bootstrap;
    @Inject
    DataSetProviderRegistryCDI providerRegistryCDI;
    @Inject
    DataSetDefRegistryCDI dataSetDefRegistryCDI;
    @Inject
    DataSetDefDeployerCDI dataSetDefDeployerCDI;

    @Before
    public void setUp() throws Exception {
        this.bootstrap.init();
    }

    @Test
    public void testStartupAnnotation() throws Exception {
        Startup startup = Bootstrap.class.getAnnotation(Startup.class);
        Assert.assertNotNull((Object)startup);
        Assert.assertEquals((Object)startup.value(), (Object)StartupType.BOOTSTRAP);
    }

    @Test
    public void testProviderRegistryInit() throws Exception {
        this.bootstrap.init();
        DataSetProviderRegistry dataSetProviderRegistry = DataSetCore.get().getDataSetProviderRegistry();
        Assert.assertEquals((Object)dataSetProviderRegistry, (Object)this.providerRegistryCDI);
        Assert.assertEquals((long)dataSetProviderRegistry.getAvailableTypes().size(), (long)5L);
        DataSetDefJSONMarshaller jsonMarshaller = DataSetCore.get().getDataSetDefJSONMarshaller();
        jsonMarshaller.fromJson(CSV_JSON);
    }

    @Test
    public void testDataSetDefRegistryInit() throws Exception {
        DataSetProviderRegistry providerRegistry = this.dataSetDefRegistryCDI.getDataSetProviderRegistry();
        DataSetDefJSONMarshaller jsonMarshaller = this.dataSetDefRegistryCDI.getDataSetDefJsonMarshaller();
        Assert.assertNotNull((Object)providerRegistry);
        Assert.assertNotNull((Object)jsonMarshaller);
        Assert.assertEquals((Object)jsonMarshaller, (Object)this.providerRegistryCDI.getDataSetDefJSONMarshaller());
    }

    @Test
    public void testDataSetDeployerInit() throws Exception {
        DataSetDefDeployer dataSetDefDeployer = DataSetCore.get().getDataSetDefDeployer();
        Assert.assertNotNull((Object)dataSetDefDeployer);
        Assert.assertEquals((Object)dataSetDefDeployer, (Object)this.dataSetDefDeployerCDI);
    }

    @Test
    public void testNoListenerRegistration() throws Exception {
        Assert.assertEquals((long)this.dataSetDefRegistryCDI.getListeners().size(), (long)0L);
    }
}

