/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.csv;

import java.net.URL;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.backend.DataSetDefDeployer;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CSVAutoDeployDataSetTest {
    @Inject
    DataSetManager dataSetManager;
    @Inject
    DataSetDefDeployer dataSetDefDeployer;
    @Inject
    DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports.dset");
        String deploymentFolder = fileURL.toString().replaceAll("file:", "").replaceAll("expenseReports.dset", "");
        this.dataSetDefDeployer.deploy(deploymentFolder);
    }

    @Test
    public void testExpenseReportsDataSet() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("expenseReports")).buildLookup());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
        Assertions.assertThat((int)result.getColumns().size()).isEqualTo(6);
    }

    @Test
    public void testWorldPopulationDataSet() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset("worldPopulation")).buildLookup());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((int)result.getRowCount()).isGreaterThan(100);
        Assertions.assertThat((int)result.getColumns().size()).isEqualTo(5);
    }
}

