/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.csv;

import java.net.URL;
import javax.inject.Inject;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.CSVDataSetDefBuilderImpl;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class CSVDataSetBasicTest {
    public static final String EXPENSE_REPORTS = "dataset_expense_reports";
    @Inject
    DataSetManager dataSetManager;
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;
    @Inject
    DataSetFormatter dataSetFormatter;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Before
    public void setUp() throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource("expenseReports.csv");
        this.dataSetDefRegistry.registerDataSetDef(((CSVDataSetDefBuilderImpl)((CSVDataSetDefBuilderImpl)((CSVDataSetDefBuilderImpl)((CSVDataSetDefBuilderImpl)((CSVDataSetDefBuilderImpl)DataSetFactory.newCSVDataSetDef().uuid(EXPENSE_REPORTS)).fileURL(fileURL.toString()).label("id")).label("office")).label("department")).label("author")).date("date", "MM-dd-yyyy").number("amount", "#,###.##").separatorChar(';').quoteChar('\"').escapeChar('\\').buildDef());
    }

    @Test
    public void testLoadDataSet() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
        org.fest.assertions.api.Assertions.assertThat((int)result.getColumns().size()).isEqualTo(6);
    }

    @Test
    public void testLookupDataSet() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EXPENSE_REPORTS)).filter("amount", new ColumnFilter[]{FilterFactory.isLowerThan((Comparable)Integer.valueOf(1000))})).group("department")).column("department")).column(AggregateFunctionType.COUNT, "#items")).column("amount", AggregateFunctionType.SUM)).buildLookup());
        Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"Engineering", "16.00", "6,547.56"}, {"Services", "5.00", "2,504.50"}, {"Sales", "8.00", "3,213.53"}, {"Support", "6.00", "2,343.70"}, {"Management", "11.00", "6,017.47"}}, (int)0);
    }

    private void printDataSet(DataSet dataSet) {
        System.out.print(this.dataSetFormatter.formatDataSet(dataSet, "{", "}", ",\n", "\"", "\"", ", ") + "\n\n");
    }
}

