/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.def.CSVDataSetDef;

public class CSVParser {
    protected transient Map<String, DateFormat> _dateFormatMap = new HashMap<String, DateFormat>();
    protected transient Map<String, DecimalFormat> _numberFormatMap = new HashMap<String, DecimalFormat>();
    protected CSVDataSetDef dataSetDef;

    public CSVParser(CSVDataSetDef def) {
        this.dataSetDef = def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet load() throws Exception {
        InputStream is = this.getCSVInputStream();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            CSVReader csvReader = new CSVReader((Reader)br, this.dataSetDef.getSeparatorChar(), this.dataSetDef.getQuoteChar(), this.dataSetDef.getEscapeChar());
            String[] header = csvReader.readNext();
            if (header == null) {
                throw new IOException("The CSV has no header: " + this.dataSetDef);
            }
            String[] firstRow = csvReader.readNext();
            if (firstRow == null || firstRow.length < header.length) {
                firstRow = null;
            }
            DataSet dataSet = DataSetFactory.newEmptyDataSet();
            for (int i = 0; i < header.length; ++i) {
                String columnId = header[i];
                ColumnType type = ColumnType.LABEL;
                if (firstRow != null) {
                    type = this.calculateType(columnId, firstRow[i]);
                }
                dataSet.addColumn(columnId, type);
            }
            if (firstRow != null) {
                Object[] row = this.processLine(dataSet, firstRow);
                dataSet.setValuesAt(dataSet.getRowCount(), row);
                String[] line = csvReader.readNext();
                while (line != null && line.length == header.length) {
                    row = this.processLine(dataSet, line);
                    dataSet.setValuesAt(dataSet.getRowCount(), row);
                    line = csvReader.readNext();
                }
            }
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
        finally {
            is.close();
        }
    }

    protected InputStream getCSVInputStream() throws Exception {
        String path = this.dataSetDef.getFilePath();
        if (!StringUtils.isBlank((String)path)) {
            File f = this.getCSVFile();
            if (f != null) {
                return new FileInputStream(f);
            }
            throw new IllegalArgumentException("CSV file not found: " + this.dataSetDef.getFilePath());
        }
        String url = this.dataSetDef.getFileURL();
        if (!StringUtils.isBlank((String)url)) {
            return new URL(url).openStream();
        }
        throw new IllegalArgumentException("CSV location not specified. Missing path or URL: " + this.dataSetDef);
    }

    public File getCSVFile() throws Exception {
        File defFile;
        String path = this.dataSetDef.getFilePath();
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        File f = new File(path);
        if (f.exists()) {
            return f;
        }
        String defFilePath = this.dataSetDef.getDefFilePath();
        if (!StringUtils.isBlank((String)defFilePath) && (defFile = new File(defFilePath)).exists() && (f = new File(defFile.getParent(), path)).exists()) {
            return f;
        }
        return null;
    }

    protected ColumnType calculateType(String columnId, String value) {
        DataColumn column = this.dataSetDef.getDataSet().getColumnById(columnId);
        if (column != null) {
            return column.getColumnType();
        }
        try {
            DateFormat dateFormat = this.getDateFormat(columnId);
            dateFormat.parse(value);
            return ColumnType.DATE;
        }
        catch (Exception e) {
            try {
                DecimalFormat numberFormat = this.getNumberFormat(columnId);
                numberFormat.parse(value);
                return ColumnType.NUMBER;
            }
            catch (Exception ee) {
                return ColumnType.LABEL;
            }
        }
    }

    protected Object[] processLine(DataSet dataSet, String[] line) throws Exception {
        Object[] row = new Object[line.length];
        for (int j = 0; j < line.length; ++j) {
            String valueStr = line[j];
            DataColumn column = dataSet.getColumnByIndex(j);
            row[j] = !StringUtils.isBlank((String)valueStr) ? this.parseValue(column, valueStr) : null;
        }
        return row;
    }

    protected Object parseValue(DataColumn column, String value) throws Exception {
        ColumnType type = column.getColumnType();
        try {
            if (type.equals((Object)ColumnType.DATE)) {
                DateFormat dateFormat = this.getDateFormat(column.getId());
                return dateFormat.parse(value);
            }
            if (type.equals((Object)ColumnType.NUMBER)) {
                DecimalFormat numberFormat = this.getNumberFormat(column.getId());
                return numberFormat.parse(value).doubleValue();
            }
            return value;
        }
        catch (ParseException e) {
            String msg = "Error parsing value: " + value + ", " + e.getMessage() + ". Check column's data type consistency!";
            throw new Exception(msg);
        }
    }

    protected DateFormat getDateFormat(String columnId) {
        DateFormat format = this._dateFormatMap.get(columnId);
        if (format == null) {
            format = new SimpleDateFormat(this.dataSetDef.getPattern(columnId));
            this._dateFormatMap.put(columnId, format);
        }
        return format;
    }

    protected DecimalFormat getNumberFormat(String columnId) {
        DecimalFormat format = this._numberFormatMap.get(columnId);
        if (format == null) {
            DecimalFormatSymbols numberSymbols = new DecimalFormatSymbols();
            numberSymbols.setGroupingSeparator(this.dataSetDef.getNumberGroupSeparator(columnId));
            numberSymbols.setDecimalSeparator(this.dataSetDef.getNumberDecimalSeparator(columnId));
            format = new DecimalFormat(this.dataSetDef.getPattern(columnId), numberSymbols);
            this._numberFormatMap.put(columnId, format);
        }
        return format;
    }
}

