/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.csv;

import java.io.File;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.backend.StaticDataSetProvider;
import org.dashbuilder.dataprovider.backend.csv.CSVFileStorage;
import org.dashbuilder.dataprovider.backend.csv.CSVParser;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="csv")
public class CSVDataSetProvider
implements DataSetProvider {
    @Inject
    protected StaticDataSetProvider staticDataSetProvider;
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;
    @Inject
    protected CSVFileStorage csvStorage;
    @Inject
    protected Logger log;

    public DataSetProviderType getType() {
        return DataSetProviderType.CSV;
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        DataSet dataSet = this.lookupDataSet(def, null);
        if (dataSet == null) {
            return null;
        }
        return dataSet.getMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def.getUUID(), null);
        CSVDataSetDef csvDef = (CSVDataSetDef)def;
        if (lookup != null && lookup.testMode() || dataSet == null || this.hasCSVFileChanged(dataSet, csvDef)) {
            CSVParser csvParser = new CSVParser(csvDef, this.csvStorage);
            dataSet = csvParser.load();
            dataSet.setUUID(def.getUUID());
            dataSet.setDefinition(def);
            this.staticDataSetProvider.registerDataSet(dataSet);
        }
        try {
            dataSet = this.staticDataSetProvider.lookupDataSet(def, lookup);
        }
        finally {
            if (lookup != null && lookup.testMode()) {
                this.staticDataSetProvider.removeDataSet(def.getUUID());
            }
        }
        return dataSet;
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def, null);
        if (dataSet == null) {
            return false;
        }
        return this.hasCSVFileChanged(dataSet, (CSVDataSetDef)def);
    }

    protected boolean hasCSVFileChanged(DataSet dataSet, CSVDataSetDef def) {
        if (StringUtils.isBlank((CharSequence)def.getFilePath())) {
            return false;
        }
        File f = new File(def.getFilePath());
        return f.exists() && f.lastModified() > dataSet.getCreationDate().getTime();
    }

    protected void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.CSV.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    protected void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.CSV.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    protected void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        DataSetDef def = event.getOldDataSetDef();
        if (DataSetProviderType.CSV.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    private void remove(String uuid) {
        this.staticDataSetProvider.removeDataSet(uuid);
    }
}

