/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.editor.client.screens;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflowFactory;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.DataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.ErrorEvent;
import org.dashbuilder.client.widgets.dataset.event.TabChangedEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.backend.EditDataSetDef;
import org.dashbuilder.dataset.client.editor.DataSetDefEditor;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.editor.client.screens.DataSetDefEditorPresenter;
import org.dashbuilder.dataset.editor.client.screens.DataSetDefScreenView;
import org.dashbuilder.dataset.editor.client.screens.DataSetDefType;
import org.dashbuilder.dataset.service.DataSetDefVfsServices;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.BasicFileMenuBuilder;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefEditorPresenterTest {
    @Mock
    EventSourceMock<ChangeTitleWidgetEvent> changeTitleNotification;
    @Mock
    EventSourceMock<NotificationEvent> notification;
    @Mock
    VersionRecordManager versionRecordManager;
    @Mock
    BasicFileMenuBuilder menuBuilder;
    @Mock
    DefaultFileNameValidator fileNameValidator;
    @Mock
    PlaceManager placeManager;
    @Mock
    PlaceRequest placeRequest;
    @Mock
    ObservablePath observablePath;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DataSetEditorWorkflowFactory workflowFactory;
    @Mock
    DataSetDefType resourceType;
    @Mock
    ErrorPopupPresenter errorPopupPresenter;
    @Mock
    DataSetDefVfsServices dataSetDefVfsServices;
    @Mock
    DataSetDef dataSetDef;
    @Mock
    DataSetDefEditor dataSetDefEditor;
    @Mock
    DataSetDefScreenView view;
    Caller<DataSetDefVfsServices> services;
    @InjectMocks
    private DataSetDefEditorPresenter presenter;
    final List<DataColumnDef> columns = (List)Mockito.mock(List.class);
    final DataSetEditWorkflow editWorkflow = (DataSetEditWorkflow)Mockito.mock(DataSetEditWorkflow.class);

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.BEAN);
        Mockito.when((Object)this.dataSetDef.getColumns()).thenReturn(this.columns);
        this.services = new CallerMock((Object)this.dataSetDefVfsServices);
        this.presenter.services = this.services;
        this.presenter.workflow = this.editWorkflow;
        EditDataSetDef editDataSetDef = (EditDataSetDef)Mockito.mock(EditDataSetDef.class);
        Mockito.when((Object)editDataSetDef.getDefinition()).thenReturn((Object)this.dataSetDef);
        Mockito.when((Object)editDataSetDef.getColumns()).thenReturn(this.columns);
        Mockito.when((Object)this.dataSetDefVfsServices.load((Path)Mockito.any(Path.class))).thenReturn((Object)editDataSetDef);
        Mockito.when((Object)this.dataSetDefVfsServices.get((Path)Mockito.any(Path.class))).thenReturn((Object)this.dataSetDef);
        Mockito.when((Object)this.workflowFactory.edit((DataSetProviderType)Mockito.any(DataSetProviderType.class))).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.getDataSetDef()).thenReturn((Object)this.dataSetDef);
        Mockito.when((Object)this.editWorkflow.getEditor()).thenReturn((Object)this.dataSetDefEditor);
        Mockito.when((Object)this.editWorkflow.edit((DataSetDef)Mockito.any(DataSetDef.class), (List)Mockito.any(List.class))).thenReturn((Object)this.editWorkflow);
        Assert.assertEquals((Object)this.view.asWidget(), (Object)this.presenter.getWidget());
    }

    @Test
    public void testLoadContent() throws Exception {
        this.presenter.loadContent();
        ((DataSetDefVfsServices)Mockito.verify((Object)this.dataSetDefVfsServices, (VerificationMode)Mockito.times((int)1))).load((Path)Mockito.any(Path.class));
        ((EventSourceMock)Mockito.verify(this.changeTitleNotification, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(ChangeTitleWidgetEvent.class));
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)this.editWorkflow);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).edit(this.dataSetDef, this.columns);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showPreviewTab();
    }

    @Test
    public void testLoadContentNullified() throws Exception {
        Mockito.when((Object)this.dataSetDefVfsServices.load((Path)Mockito.any(Path.class))).thenReturn(null);
        this.presenter.loadContent();
        ((DataSetDefVfsServices)Mockito.verify((Object)this.dataSetDefVfsServices, (VerificationMode)Mockito.times((int)1))).load((Path)Mockito.any(Path.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testLoadDefinition() throws Exception {
        Exception loadContentException = (Exception)Mockito.mock(Exception.class);
        ((DataSetDefVfsServices)Mockito.doThrow((Throwable)loadContentException).when((Object)this.dataSetDefVfsServices)).load((Path)Mockito.any(Path.class));
        this.presenter.loadContent();
        ((DataSetDefVfsServices)Mockito.verify((Object)this.dataSetDefVfsServices, (VerificationMode)Mockito.times((int)1))).get((Path)Mockito.any(Path.class));
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)this.editWorkflow);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).edit(this.dataSetDef, this.columns);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showPreviewTab();
    }

    @Test
    public void testGetDataSetDef() {
        Assert.assertEquals((Object)this.dataSetDef, (Object)this.presenter.getDataSetDef());
    }

    @Test
    public void testGetDataSetDefNullified() {
        Mockito.when((Object)this.editWorkflow.getDataSetDef()).thenReturn(null);
        DataSetDef d = this.presenter.getDataSetDef();
        Assert.assertNull((Object)d);
    }

    @Test
    public void testOnTestEvent() {
        TestDataSetRequestEvent event = (TestDataSetRequestEvent)Mockito.mock(TestDataSetRequestEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.hasErrors()).thenReturn((Object)false);
        this.presenter.onTestEvent(event);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).testDataSet((DataSetEditorWorkflow.TestDataSetCallback)Mockito.any(DataSetEditorWorkflow.TestDataSetCallback.class));
    }

    @Test
    public void testOnTestEventWithErrors() {
        TestDataSetRequestEvent event = (TestDataSetRequestEvent)Mockito.mock(TestDataSetRequestEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.hasErrors()).thenReturn((Object)true);
        this.presenter.onTestEvent(event);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).testDataSet((DataSetEditorWorkflow.TestDataSetCallback)Mockito.any(DataSetEditorWorkflow.TestDataSetCallback.class));
    }

    @Test
    public void testOnValidateSuccess() {
        Mockito.when((Object)this.editWorkflow.hasErrors()).thenReturn((Object)false);
        this.presenter.onValidate().execute();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).flush();
        ArgumentCaptor dataCaptor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)1))).fire(dataCaptor.capture());
        NotificationEvent ne = (NotificationEvent)dataCaptor.getValue();
        Assert.assertNotNull((Object)ne);
        Assert.assertEquals((Object)NotificationEvent.NotificationType.SUCCESS, (Object)ne.getType());
    }

    @Test
    public void testOnValidateFailed() {
        Mockito.when((Object)this.editWorkflow.hasErrors()).thenReturn((Object)true);
        this.presenter.onValidate().execute();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).flush();
        ArgumentCaptor dataCaptor = ArgumentCaptor.forClass(NotificationEvent.class);
        ((EventSourceMock)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)1))).fire(dataCaptor.capture());
        NotificationEvent ne = (NotificationEvent)dataCaptor.getValue();
        Assert.assertNotNull((Object)ne);
        Assert.assertEquals((Object)NotificationEvent.NotificationType.ERROR, (Object)ne.getType());
    }

    public void testOnSave() {
        this.presenter.save();
    }

    @Test
    public void testShowError() {
        ClientRuntimeError error = (ClientRuntimeError)Mockito.mock(ClientRuntimeError.class);
        Mockito.when((Object)error.getCause()).thenReturn((Object)"errorCause");
        this.presenter.showError(error);
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).clear();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(DataSetDef.class), (List)Mockito.any(List.class));
    }

    @Test
    public void testOnCancelEvent() {
        CancelRequestEvent event = (CancelRequestEvent)Mockito.mock(CancelRequestEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.editWorkflow);
        this.presenter.onCancelEvent(event);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).clear();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(DataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testOnErrorEvent() {
        ErrorEvent event = (ErrorEvent)Mockito.mock(ErrorEvent.class);
        Mockito.when((Object)event.getClientRuntimeError()).thenReturn(null);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)"errorMessage");
        this.presenter.onErrorEvent(event);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).clear();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(DataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testOnTabChangedEvent_ConfigurationTab() {
        TabChangedEvent event = (TabChangedEvent)Mockito.mock(TabChangedEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetDefEditor);
        Mockito.when((Object)event.getTabId()).thenReturn((Object)"configuration");
        this.presenter.onTabChangedEvent(event);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).clearButtons();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showTestButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(DataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testOnTabChangedEvent_PreviewTab() {
        TabChangedEvent event = (TabChangedEvent)Mockito.mock(TabChangedEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetDefEditor);
        Mockito.when((Object)event.getTabId()).thenReturn((Object)"preview");
        this.presenter.onTabChangedEvent(event);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).clearButtons();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(DataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testOnTabChangedEvent_AdvancedTab() {
        TabChangedEvent event = (TabChangedEvent)Mockito.mock(TabChangedEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetDefEditor);
        Mockito.when((Object)event.getTabId()).thenReturn((Object)"advanced");
        this.presenter.onTabChangedEvent(event);
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).clearButtons();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((DataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(DataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }
}

