/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.editor.client.screens;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.widgets.dataset.event.EditDataSetEvent;
import org.dashbuilder.client.widgets.dataset.event.ErrorEvent;
import org.dashbuilder.client.widgets.dataset.explorer.DataSetExplorer;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.editor.client.screens.DataSetDefExplorerScreen;
import org.dashbuilder.dataset.service.DataSetDefVfsServices;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefExplorerScreenTest {
    @Mock
    PlaceRequest placeRequest;
    @Mock
    PlaceManager placeManager;
    @Mock
    EventSourceMock<NotificationEvent> notification;
    @Mock
    ErrorPopupPresenter errorPopupPresenter;
    @Mock
    DataSetExplorer explorerWidget;
    @Mock
    DataSetDefVfsServices dataSetDefVfsServices;
    @Mock
    Caller<DataSetDefVfsServices> services;
    @InjectMocks
    DataSetDefExplorerScreen presenter;

    @Before
    public void setup() throws Exception {
        this.presenter.services = this.services;
        Assert.assertEquals((Object)this.explorerWidget, (Object)this.presenter.getView());
        ((Caller)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                RemoteCallback callback = (RemoteCallback)invocationOnMock.getArguments()[0];
                callback.callback(Mockito.mock(Path.class));
                return null;
            }
        }).when(this.services)).call((RemoteCallback)Mockito.any(RemoteCallback.class));
    }

    @Test
    public void testNewDataSet() {
        this.presenter.newDataSet();
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo("DataSetDefWizard");
    }

    @Test(expected=ClassCastException.class)
    public void testOnEditDataSetEvent() {
        DataSetDef def = (DataSetDef)Mockito.mock(DataSetDef.class);
        EditDataSetEvent editDataSetEvent = (EditDataSetEvent)Mockito.mock(EditDataSetEvent.class);
        Mockito.when((Object)editDataSetEvent.getDef()).thenReturn((Object)def);
        this.presenter.onEditDataSetEvent(editDataSetEvent);
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo((PlaceRequest)Mockito.any(PathPlaceRequest.class));
    }

    @Test
    public void testOnErrorEvent() {
        ErrorEvent errorDataSetEvent = (ErrorEvent)Mockito.mock(ErrorEvent.class);
        Mockito.when((Object)errorDataSetEvent.getMessage()).thenReturn((Object)"errorMessage");
        this.presenter.onErrorEvent(errorDataSetEvent);
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage("errorMessage");
    }
}

