/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataset.editor.client.screens;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.DataSetEditorWorkflowFactory;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.DataSetBasicAttributesWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.create.DataSetProviderTypeWorkflow;
import org.dashbuilder.client.widgets.dataset.editor.workflow.edit.SQLDataSetEditWorkflow;
import org.dashbuilder.client.widgets.dataset.event.CancelRequestEvent;
import org.dashbuilder.client.widgets.dataset.event.ErrorEvent;
import org.dashbuilder.client.widgets.dataset.event.TabChangedEvent;
import org.dashbuilder.client.widgets.dataset.event.TestDataSetRequestEvent;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.editor.SQLDataSetDefEditor;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.dashbuilder.dataset.editor.client.screens.DataSetDefScreenView;
import org.dashbuilder.dataset.editor.client.screens.DataSetDefWizardScreen;
import org.dashbuilder.dataset.service.DataSetDefVfsServices;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;

@RunWith(value=GwtMockitoTestRunner.class)
public class DataSetDefWizardScreenTest {
    @Mock
    EventSourceMock<NotificationEvent> notification;
    @Mock
    PlaceManager placeManager;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    DataSetEditorWorkflowFactory workflowFactory;
    @Mock
    DataSetClientServices clientServices;
    @Mock
    ErrorPopupPresenter errorPopupPresenter;
    @Mock
    DataSetDefScreenView view;
    @Mock
    DataSetProviderTypeWorkflow dataSetProviderTypeWorkflow;
    @Mock
    SQLDataSetDef dataSetDef;
    @Mock
    SQLDataSetDefEditor dataSetDefEditor;
    @Mock
    DataSetBasicAttributesWorkflow dataSetBasicAttributesWorkflow;
    @Mock
    SQLDataSetEditWorkflow editWorkflow;
    @Mock
    DataSetDefVfsServices dataSetDefVfsServices;
    @Mock
    SavePopUpPresenter savePopUpPresenter;
    Caller<DataSetDefVfsServices> services;
    private DataSetDefWizardScreen presenter;

    @Before
    public void setup() throws Exception {
        this.services = new CallerMock((Object)this.dataSetDefVfsServices);
        Mockito.when((Object)this.dataSetDef.getUUID()).thenReturn((Object)"uuid1");
        Mockito.when((Object)this.dataSetDef.getName()).thenReturn((Object)"name1");
        Mockito.when((Object)this.dataSetDef.getProvider()).thenReturn((Object)DataSetProviderType.SQL);
        Mockito.when((Object)this.workflowFactory.providerType()).thenReturn((Object)this.dataSetProviderTypeWorkflow);
        Mockito.when((Object)this.workflowFactory.edit((DataSetProviderType)Mockito.any(DataSetProviderType.class))).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.dataSetProviderTypeWorkflow.edit((DataSetDef)Mockito.any(DataSetDef.class))).thenReturn((Object)this.dataSetProviderTypeWorkflow);
        Mockito.when((Object)this.dataSetProviderTypeWorkflow.providerTypeEdition()).thenReturn((Object)this.dataSetProviderTypeWorkflow);
        ((DataSetClientServices)Mockito.doAnswer(invocationOnMock -> {
            RemoteCallback callback = (RemoteCallback)invocationOnMock.getArguments()[1];
            callback.callback((Object)this.dataSetDef);
            return null;
        }).when((Object)this.clientServices)).newDataSet((DataSetProviderType)Mockito.any(DataSetProviderType.class), (RemoteCallback)Mockito.any(RemoteCallback.class));
        ((PlaceManager)Mockito.doAnswer(invocationOnMock -> {
            this.presenter.onClose();
            return null;
        }).when((Object)this.placeManager)).closePlace((PlaceRequest)Mockito.any(PlaceRequest.class));
        Mockito.when((Object)this.dataSetBasicAttributesWorkflow.edit((DataSetDef)Mockito.any(DataSetDef.class))).thenReturn((Object)this.dataSetBasicAttributesWorkflow);
        Mockito.when((Object)this.dataSetBasicAttributesWorkflow.basicAttributesEdition()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.getDataSetDef()).thenReturn((Object)this.dataSetDef);
        Mockito.when((Object)this.editWorkflow.edit((DataSetDef)Mockito.any(SQLDataSetDef.class), (List)Mockito.any(List.class))).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.showNextButton()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.showBackButton()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.showTestButton()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.showPreviewTab()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.showConfigurationTab()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.editWorkflow.showAdvancedTab()).thenReturn((Object)this.editWorkflow);
        Mockito.when((Object)this.workflowFactory.basicAttributes((DataSetProviderType)Mockito.any(DataSetProviderType.class))).thenReturn((Object)this.dataSetBasicAttributesWorkflow);
        this.presenter = new DataSetDefWizardScreen(this.beanManager, this.workflowFactory, this.services, this.clientServices, this.notification, this.placeManager, this.errorPopupPresenter, this.savePopUpPresenter, this.view);
        this.presenter.services = this.services;
    }

    @Test
    public void testOnMayClose() {
        this.presenter.init(null);
        Mockito.when((Object)this.dataSetProviderTypeWorkflow.getDataSetDef()).thenReturn(Mockito.mock(SQLDataSetDef.class));
        this.presenter.onMayClose();
        ((DataSetDefScreenView)Mockito.verify((Object)this.view)).confirmClose();
        Assert.assertTrue((boolean)this.presenter.isDirty(Integer.valueOf(this.presenter.getCurrentModelHash())));
    }

    @Test
    public void testOnClose() {
        this.presenter.init(PlaceRequest.NOWHERE);
        DataSetEditorWorkflow currentWorkflow = this.presenter.currentWorkflow;
        this.presenter.onClose();
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory)).dispose(currentWorkflow);
        Assert.assertNull((String)"current workflow null", (Object)this.presenter.currentWorkflow);
    }

    @Test
    public void testShowError() {
        ClientRuntimeError error = (ClientRuntimeError)Mockito.mock(ClientRuntimeError.class);
        Mockito.when((Object)error.getCause()).thenReturn((Object)"errorCause");
        this.presenter.showError(error);
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testInitProviderTypeEdition() {
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        this.presenter.init(placeRequest);
        Util.assertEquals((Object)this.dataSetProviderTypeWorkflow, (Object)this.presenter.currentWorkflow);
        Assert.assertFalse((boolean)this.presenter.isDirty(Integer.valueOf(this.presenter.getCurrentModelHash())));
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory, (VerificationMode)Mockito.times((int)1))).providerType();
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Mockito.any(IsWidget.class));
        ((DataSetProviderTypeWorkflow)Mockito.verify((Object)this.dataSetProviderTypeWorkflow, (VerificationMode)Mockito.times((int)1))).edit((DataSetDef)Mockito.any(DataSetDef.class));
        ((DataSetProviderTypeWorkflow)Mockito.verify((Object)this.dataSetProviderTypeWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetProviderTypeWorkflow)Mockito.verify((Object)this.dataSetProviderTypeWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((DataSetProviderTypeWorkflow)Mockito.verify((Object)this.dataSetProviderTypeWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
    }

    @Test
    public void testOnProviderTypeSelected() throws Exception {
        Mockito.when((Object)this.dataSetProviderTypeWorkflow.getProviderType()).thenReturn((Object)DataSetProviderType.SQL);
        this.presenter.onProviderTypeSelected(this.dataSetProviderTypeWorkflow);
        Util.assertEquals((Object)this.dataSetBasicAttributesWorkflow, (Object)this.presenter.currentWorkflow);
        Assert.assertFalse((boolean)this.presenter.isDirty(Integer.valueOf(this.presenter.getCurrentModelHash())));
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Mockito.any(IsWidget.class));
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)1))).edit((DataSetDef)Mockito.any(DataSetDef.class));
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showTestButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showBackButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
    }

    @Test
    public void testOnTestEventWithErrors() {
        TestDataSetRequestEvent event = (TestDataSetRequestEvent)Mockito.mock(TestDataSetRequestEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetBasicAttributesWorkflow);
        Mockito.when((Object)this.dataSetBasicAttributesWorkflow.hasErrors()).thenReturn((Object)true);
        this.presenter.currentWorkflow = this.dataSetBasicAttributesWorkflow;
        this.presenter.onTestEvent(event);
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)0))).testDataSet((DataSetEditorWorkflow.TestDataSetCallback)Mockito.any(DataSetEditorWorkflow.TestDataSetCallback.class));
    }

    @Test
    public void testOnTestEventAndCompleteEdition() {
        final DataSet dataSet = (DataSet)Mockito.mock(DataSet.class);
        DataColumn col1 = (DataColumn)Mockito.mock(DataColumn.class);
        Mockito.when((Object)col1.getId()).thenReturn((Object)"col1");
        Mockito.when((Object)col1.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        DataColumn col2 = (DataColumn)Mockito.mock(DataColumn.class);
        Mockito.when((Object)col2.getId()).thenReturn((Object)"col2");
        Mockito.when((Object)col2.getColumnType()).thenReturn((Object)ColumnType.LABEL);
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
        columns.add(col1);
        columns.add(col2);
        Mockito.when((Object)dataSet.getColumns()).thenReturn(columns);
        TestDataSetRequestEvent event = (TestDataSetRequestEvent)Mockito.mock(TestDataSetRequestEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetBasicAttributesWorkflow);
        Mockito.when((Object)this.dataSetBasicAttributesWorkflow.hasErrors()).thenReturn((Object)false);
        Mockito.when((Object)this.dataSetBasicAttributesWorkflow.getDataSetDef()).thenReturn((Object)this.dataSetDef);
        ((DataSetBasicAttributesWorkflow)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocationOnMock) throws Throwable {
                DataSetEditorWorkflow.TestDataSetCallback callback = (DataSetEditorWorkflow.TestDataSetCallback)invocationOnMock.getArguments()[0];
                callback.onSuccess(dataSet);
                return null;
            }
        }).when((Object)this.dataSetBasicAttributesWorkflow)).testDataSet((DataSetEditorWorkflow.TestDataSetCallback)Mockito.any(DataSetEditorWorkflow.TestDataSetCallback.class));
        this.presenter.currentWorkflow = this.dataSetBasicAttributesWorkflow;
        this.presenter.onTestEvent(event);
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)1))).testDataSet((DataSetEditorWorkflow.TestDataSetCallback)Mockito.any(DataSetEditorWorkflow.TestDataSetCallback.class));
        Util.assertEquals((Object)this.editWorkflow, (Object)this.presenter.currentWorkflow);
        Assert.assertTrue((boolean)this.presenter.isDirty(Integer.valueOf(this.presenter.getCurrentModelHash())));
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory, (VerificationMode)Mockito.times((int)1))).edit((DataSetProviderType)Mockito.any(DataSetProviderType.class));
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)1))).setWidget((IsWidget)Mockito.any(IsWidget.class));
        ArgumentCaptor dataCaptor = ArgumentCaptor.forClass(List.class);
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).edit((DataSetDef)Mockito.any(SQLDataSetDef.class), (List)dataCaptor.capture());
        List columnsCaptured = (List)dataCaptor.getValue();
        Util.assertNotNull((Object)columnsCaptured);
        Util.assertEquals((Object)2, (Object)columnsCaptured.size());
        Util.assertEquals((Object)"col1", (Object)((DataColumnDef)columnsCaptured.get(0)).getId());
        Util.assertEquals((Object)"col2", (Object)((DataColumnDef)columnsCaptured.get(1)).getId());
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showPreviewTab();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showNextButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showBackButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
    }

    @Test
    public void testOnSave() {
        Path path = (Path)Mockito.mock(Path.class);
        DataSetDef dataSetDef = DataSetDefFactory.newBeanDataSetDef().buildDef();
        PlaceRequest placeRequest = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.when((Object)this.dataSetDefVfsServices.save((DataSetDef)Mockito.any(DataSetDef.class), Mockito.anyString())).thenReturn((Object)path);
        Mockito.when((Object)this.dataSetProviderTypeWorkflow.getDataSetDef()).thenReturn((Object)dataSetDef);
        this.presenter.init(placeRequest);
        this.presenter.onSave(dataSetDef, "saveMessage");
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).goTo("DataSetAuthoringHome");
        ((EventSourceMock)Mockito.verify(this.notification, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(NotificationEvent.class));
        ((PlaceManager)Mockito.verify((Object)this.placeManager, (VerificationMode)Mockito.times((int)1))).closePlace((PlaceRequest)Mockito.any(PlaceRequest.class));
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory)).dispose((DataSetEditorWorkflow)this.dataSetProviderTypeWorkflow);
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory, (VerificationMode)Mockito.times((int)0))).edit((DataSetProviderType)Mockito.any(DataSetProviderType.class));
        Assert.assertNull((String)"current workflow null", (Object)this.presenter.currentWorkflow);
        Assert.assertFalse((boolean)this.presenter.isDirty(Integer.valueOf(this.presenter.getCurrentModelHash())));
        Assert.assertTrue((boolean)this.presenter.mayClose());
    }

    @Test
    public void testOnCancelEvent() {
        this.presenter.currentWorkflow = this.dataSetBasicAttributesWorkflow;
        CancelRequestEvent event = (CancelRequestEvent)Mockito.mock(CancelRequestEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetBasicAttributesWorkflow);
        this.presenter.onCancelEvent(event);
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory, (VerificationMode)Mockito.times((int)1))).providerType();
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory, (VerificationMode)Mockito.times((int)0))).edit((DataSetProviderType)Mockito.any(DataSetProviderType.class));
        ((DataSetEditorWorkflowFactory)Mockito.verify((Object)this.workflowFactory, (VerificationMode)Mockito.times((int)0))).basicAttributes((DataSetProviderType)Mockito.any(DataSetProviderType.class));
    }

    @Test
    public void testOnErrorEvent() {
        ErrorEvent event = (ErrorEvent)Mockito.mock(ErrorEvent.class);
        Mockito.when((Object)event.getClientRuntimeError()).thenReturn(null);
        Mockito.when((Object)event.getMessage()).thenReturn((Object)"errorMessage");
        this.presenter.currentWorkflow = this.dataSetBasicAttributesWorkflow;
        this.presenter.onErrorEvent(event);
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)0))).clear();
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)0))).clearButtons();
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((DataSetBasicAttributesWorkflow)Mockito.verify((Object)this.dataSetBasicAttributesWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(DataSetDef.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)1))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testOnTabChangedEvent_ConfigurationTab() {
        Mockito.when((Object)this.editWorkflow.getEditor()).thenReturn((Object)this.dataSetDefEditor);
        TabChangedEvent event = (TabChangedEvent)Mockito.mock(TabChangedEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetDefEditor);
        Mockito.when((Object)event.getTabId()).thenReturn((Object)"configuration");
        this.presenter.currentWorkflow = this.editWorkflow;
        this.presenter.onTabChangedEvent(event);
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).clearButtons();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showTestButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showNextButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showBackButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(SQLDataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testOnTabChangedEvent_PreviewTab() {
        Mockito.when((Object)this.editWorkflow.getEditor()).thenReturn((Object)this.dataSetDefEditor);
        TabChangedEvent event = (TabChangedEvent)Mockito.mock(TabChangedEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetDefEditor);
        Mockito.when((Object)event.getTabId()).thenReturn((Object)"preview");
        this.presenter.currentWorkflow = this.editWorkflow;
        this.presenter.onTabChangedEvent(event);
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).clearButtons();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showNextButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showBackButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(SQLDataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }

    @Test
    public void testOnTabChangedEvent_AdvancedTab() {
        Mockito.when((Object)this.editWorkflow.getEditor()).thenReturn((Object)this.dataSetDefEditor);
        TabChangedEvent event = (TabChangedEvent)Mockito.mock(TabChangedEvent.class);
        Mockito.when((Object)event.getContext()).thenReturn((Object)this.dataSetDefEditor);
        Mockito.when((Object)event.getTabId()).thenReturn((Object)"advanced");
        this.presenter.currentWorkflow = this.editWorkflow;
        this.presenter.onTabChangedEvent(event);
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).clearButtons();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showNextButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)1))).showBackButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).showTestButton();
        ((SQLDataSetEditWorkflow)Mockito.verify((Object)this.editWorkflow, (VerificationMode)Mockito.times((int)0))).edit((DataSetDef)Mockito.any(SQLDataSetDef.class), (List)Mockito.any(List.class));
        ((ErrorPopupPresenter)Mockito.verify((Object)this.errorPopupPresenter, (VerificationMode)Mockito.times((int)0))).showMessage(Mockito.anyString());
        ((DataSetDefScreenView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)0))).setWidget((IsWidget)Mockito.any(IsWidget.class));
    }
}

