/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@ApplicationScoped
public class ElasticSearchValueTypeMapper {
    private static final String DATE_DEFAULT_FORMAT_KEY = "dateOptionalTime";
    private static final DateTimeFormatter DATE_DEFAULT_FORMAT = ISODateTimeFormat.dateOptionalTimeParser();
    private static final String NUMERIC_FLOAT = FieldMappingResponse.FieldType.FLOAT.name().toLowerCase();
    private static final String NUMERIC_DOUBLE = FieldMappingResponse.FieldType.DOUBLE.name().toLowerCase();
    private static final String NUMERIC_SHORT = FieldMappingResponse.FieldType.SHORT.name().toLowerCase();
    private static final String NUMERIC_INTEGER = FieldMappingResponse.FieldType.INTEGER.name().toLowerCase();
    private static final String NUMERIC_LONG = FieldMappingResponse.FieldType.LONG.name().toLowerCase();

    public String defaultDateFormat() {
        return DATE_DEFAULT_FORMAT_KEY;
    }

    public String defaulNumberFormat() {
        return NUMERIC_DOUBLE;
    }

    public String parseText(ElasticSearchDataSetDef definition, String columnId, String string) throws ParseException {
        return this.parseString(definition, columnId, string, false);
    }

    public String parseLabel(ElasticSearchDataSetDef definition, String columnId, String string, boolean isColumnGroup) throws ParseException {
        return this.parseString(definition, columnId, string, true);
    }

    protected String parseString(ElasticSearchDataSetDef definition, String columnId, String string, boolean isColumnGroup) throws ParseException {
        if (string == null) {
            return "";
        }
        if (isColumnGroup && string.startsWith("0")) {
            return string.substring(1);
        }
        return string;
    }

    public Double parseNumeric(ElasticSearchDataSetDef definition, String columnId, String number) throws ParseException {
        if (this.isEmpty(number)) {
            return 0.0;
        }
        String coreType = definition.getPattern(columnId);
        if (this.isEmpty(coreType)) {
            coreType = this.defaulNumberFormat();
        }
        Double result = null;
        if (coreType.equalsIgnoreCase(NUMERIC_FLOAT)) {
            result = new Float(Float.parseFloat(number)).doubleValue();
        } else if (coreType.equalsIgnoreCase(NUMERIC_DOUBLE)) {
            result = Double.parseDouble(number);
        } else if (coreType.equalsIgnoreCase(NUMERIC_SHORT)) {
            result = new Float(Short.parseShort(number)).doubleValue();
        } else if (coreType.equalsIgnoreCase(NUMERIC_INTEGER)) {
            result = new Float(Integer.parseInt(number)).doubleValue();
        } else if (coreType.equalsIgnoreCase(NUMERIC_LONG)) {
            result = new Float(Long.parseLong(number)).doubleValue();
        } else {
            DecimalFormat format = new DecimalFormat(coreType);
            Number n = format.parse(number);
            result = n.doubleValue();
        }
        return result;
    }

    public Date parseDate(ElasticSearchDataSetDef definition, String columnId, String date) throws ParseException {
        if (this.isEmpty(date)) {
            return null;
        }
        String datePattern = definition.getPattern(columnId);
        boolean isDefaultDateFormat = this.isEmpty(datePattern) || datePattern.equalsIgnoreCase(DATE_DEFAULT_FORMAT_KEY);
        DateTimeFormatter formatter = isDefaultDateFormat ? DATE_DEFAULT_FORMAT : DateTimeFormat.forPattern((String)datePattern);
        DateTime dateTime = formatter.parseDateTime(date);
        return dateTime.toDate();
    }

    public Date parseDate(ElasticSearchDataSetDef definition, String columnId, long date) {
        return new Date(date);
    }

    public String formatText(ElasticSearchDataSetDef definition, String columnId, String string) {
        return this.formatString(definition, columnId, string);
    }

    public String formatLabel(ElasticSearchDataSetDef definition, String columnId, String string) {
        return this.formatString(definition, columnId, string);
    }

    protected String formatString(ElasticSearchDataSetDef definition, String columnId, String string) {
        return string;
    }

    public String formatNumeric(ElasticSearchDataSetDef definition, String columnId, Double number) {
        String coreType;
        if (number == null) {
            number = 0.0;
        }
        if (this.isEmpty(coreType = definition.getPattern(columnId))) {
            coreType = this.defaulNumberFormat();
        }
        String result = null;
        if (coreType.equalsIgnoreCase(NUMERIC_FLOAT)) {
            result = Float.toString(number.floatValue());
        } else if (coreType.equalsIgnoreCase(NUMERIC_DOUBLE)) {
            result = Double.toString(number);
        } else if (coreType.equalsIgnoreCase(NUMERIC_SHORT)) {
            result = Short.toString(number.shortValue());
        } else if (coreType.equalsIgnoreCase(NUMERIC_INTEGER)) {
            result = Integer.toString(number.intValue());
        } else if (coreType.equalsIgnoreCase(NUMERIC_LONG)) {
            result = Long.toString(number.longValue());
        } else {
            DecimalFormat format = new DecimalFormat(coreType);
            result = format.format(number);
        }
        return result;
    }

    public String formatDate(ElasticSearchDataSetDef definition, String columnId, Date date) {
        if (date == null) {
            return "";
        }
        String datePattern = definition.getPattern(columnId);
        boolean isDefaultDateFormat = this.isEmpty(datePattern) || datePattern.equalsIgnoreCase(DATE_DEFAULT_FORMAT_KEY);
        DateTimeFormatter formatter = isDefaultDateFormat ? DATE_DEFAULT_FORMAT : DateTimeFormat.forPattern((String)datePattern);
        return formatter.print(date.getTime());
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

