/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTestBase;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticSearchDataSetTest
extends ElasticSearchDataSetTestBase {
    protected static final String EL_EXAMPLE_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports.dset";
    protected static final String EL_EXAMPLE_CSENSITIVE_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports-csensitive.dset";
    protected static final String EL_DATASET_UUID = "expense_reports";
    protected static final String EL_DATASET_CSENSITIVE_UUID = "expense_reports_csensitive";

    @Before
    public void registerDataSet() throws Exception {
        this._registerDataSet(EL_EXAMPLE_DATASET_DEF);
        this._registerDataSet(EL_EXAMPLE_CSENSITIVE_DATASET_DEF);
    }

    @Test
    public void testColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("id", SortOrder.ASCENDING)).buildLookup());
        Assert.assertNotNull((Object)result.getColumns());
        Assert.assertTrue((result.getColumns().size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.getColumnByIndex(0).getId().equals("id"));
        Assert.assertTrue((boolean)result.getColumnByIndex(1).getId().equals("amount"));
        Assert.assertTrue((boolean)result.getColumnByIndex(2).getId().equals("department"));
        Assert.assertTrue((boolean)result.getColumnByIndex(3).getId().equals("employee"));
        Assert.assertTrue((boolean)result.getColumnByIndex(4).getId().equals("date"));
        Assert.assertTrue((boolean)result.getColumnByIndex(5).getId().equals("city"));
        Assert.assertTrue((boolean)result.getColumnByIndex(0).getColumnType().equals((Object)ColumnType.NUMBER));
        Assert.assertTrue((boolean)result.getColumnByIndex(1).getColumnType().equals((Object)ColumnType.NUMBER));
        Assert.assertTrue((boolean)result.getColumnByIndex(2).getColumnType().equals((Object)ColumnType.LABEL));
        Assert.assertTrue((boolean)result.getColumnByIndex(3).getColumnType().equals((Object)ColumnType.TEXT));
        Assert.assertTrue((boolean)result.getColumnByIndex(4).getColumnType().equals((Object)ColumnType.DATE));
        Assert.assertTrue((boolean)result.getColumnByIndex(5).getColumnType().equals((Object)ColumnType.LABEL));
    }

    @Test
    public void testBasicLookup() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
    }

    @Test
    public void testDefaultLookup() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)1.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(49, 0)).isEqualTo((Object)50.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)120.35f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 2)).isEqualTo((Object)"Engineering");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 3)).isEqualTo((Object)"Roxie Foraker");
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse("2012-12-11");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 4)).isEqualTo((Object)date);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 5)).isEqualTo((Object)"Barcelona");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 0)).isEqualTo((Object)2.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 1)).isEqualTo((Object)1100.1f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 2)).isEqualTo((Object)"Engineering");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 3)).isEqualTo((Object)"Roxie Foraker");
        date = new SimpleDateFormat("yyyy-MM-dd").parse("2012-12-01");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 4)).isEqualTo((Object)date);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 5)).isEqualTo((Object)"Barcelona");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(8, 0)).isEqualTo((Object)9.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(8, 1)).isEqualTo((Object)75.75);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(8, 2)).isEqualTo((Object)"Sales");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(8, 3)).isEqualTo((Object)"Nita Marling");
        date = new SimpleDateFormat("yyyy-MM-dd").parse("2012-05-11");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(8, 4)).isEqualTo((Object)date);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(8, 5)).isEqualTo((Object)"Madrid");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(30, 0)).isEqualTo((Object)31.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(30, 1)).isEqualTo((Object)234.34f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(30, 2)).isEqualTo((Object)"Management");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(30, 3)).isEqualTo((Object)"Hannah B. Mackey");
        date = new SimpleDateFormat("yyyy-MM-dd").parse("2010-09-01");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(30, 4)).isEqualTo((Object)date);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(30, 5)).isEqualTo((Object)"Raleigh");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(46, 0)).isEqualTo((Object)47.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(46, 1)).isEqualTo((Object)565.56f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(46, 2)).isEqualTo((Object)"Management");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(46, 3)).isEqualTo((Object)"Patricia J. Behr");
        date = new SimpleDateFormat("yyyy-MM-dd").parse("2009-04-14");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(46, 4)).isEqualTo((Object)date);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(46, 5)).isEqualTo((Object)"London");
    }

    @Test
    public void testDefaultLookupWithSorting() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("id", SortOrder.DESCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(50);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)50.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(49, 0)).isEqualTo((Object)1.0);
    }

    @Test(expected=RuntimeException.class)
    public void testSortingWithNonExistingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("mycolumn", SortOrder.DESCENDING)).buildLookup());
    }

    @Test
    public void testLookupTrim() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).sort("id", SortOrder.ASCENDING)).rowNumber(10)).rowOffset(40)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(10);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)41.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(9, 0)).isEqualTo((Object)50.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(6, 0)).isEqualTo((Object)47.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(6, 1)).isEqualTo((Object)565.56f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(6, 2)).isEqualTo((Object)"Management");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(6, 3)).isEqualTo((Object)"Patricia J. Behr");
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse("2009-04-14");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(6, 4)).isEqualTo((Object)date);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(6, 5)).isEqualTo((Object)"London");
    }

    @Test
    public void testGroupFunctions() throws Exception {
        DataSetLookup lookup = ((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column(AggregateFunctionType.COUNT, "#items")).column("amount", AggregateFunctionType.MIN, "min")).column("amount", AggregateFunctionType.MAX, "max")).column("amount", AggregateFunctionType.AVERAGE, "avg")).column("amount", AggregateFunctionType.SUM, "sum")).column("city", AggregateFunctionType.DISTINCT, "distinct")).sort("id", SortOrder.ASCENDING)).buildLookup();
        DataSet result = this.dataSetManager.lookupDataSet(lookup);
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)50.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)43.03f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 2)).isEqualTo((Object)1402.3f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 3)).isEqualTo((Object)504.6232014465332);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 4)).isEqualTo((Object)25231.16007232666);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 5)).isEqualTo((Object)6.0);
    }

    @Test
    public void testGroupFunctionsWithAggregatedColumnsWithNoResultingColumnId() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column(AggregateFunctionType.COUNT, "#items")).column("amount", AggregateFunctionType.MIN)).column("amount", AggregateFunctionType.MAX)).column("amount", AggregateFunctionType.AVERAGE)).column("amount", AggregateFunctionType.SUM)).column("city", AggregateFunctionType.DISTINCT)).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)50.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)43.03f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 2)).isEqualTo((Object)1402.3f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 3)).isEqualTo((Object)504.6232014465332);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 4)).isEqualTo((Object)25231.16007232666);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 5)).isEqualTo((Object)6.0);
    }

    @Test
    public void testGroupByLabelDynamic() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("department")).column("department", "Department")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.MIN, "min")).column("amount", AggregateFunctionType.MAX, "max")).column("amount", AggregateFunctionType.AVERAGE, "average")).column("amount", AggregateFunctionType.SUM, "total")).sort("amount", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(5);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)"Engineering");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)19.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 2)).isEqualTo((Object)120.35f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 3)).isEqualTo((Object)1402.3f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 4)).isEqualTo((Object)534.2136836804842);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 5)).isEqualTo((Object)10150.0599899292);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 0)).isEqualTo((Object)"Management");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 1)).isEqualTo((Object)11.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 2)).isEqualTo((Object)43.03f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 3)).isEqualTo((Object)992.2f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 4)).isEqualTo((Object)547.0427315451882);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 5)).isEqualTo((Object)6017.47004699707);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 0)).isEqualTo((Object)"Sales");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 1)).isEqualTo((Object)8.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 2)).isEqualTo((Object)75.75);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 3)).isEqualTo((Object)995.3f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 4)).isEqualTo((Object)401.6912536621094);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 5)).isEqualTo((Object)3213.53f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 0)).isEqualTo((Object)"Services");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 1)).isEqualTo((Object)5.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 2)).isEqualTo((Object)152.25);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 3)).isEqualTo((Object)911.11f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 4)).isEqualTo((Object)500.9f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 5)).isEqualTo((Object)2504.499969482422);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 0)).isEqualTo((Object)"Support");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 1)).isEqualTo((Object)7.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 2)).isEqualTo((Object)300.01f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 3)).isEqualTo((Object)1001.9f);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 4)).isEqualTo((Object)477.942862374442);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 5)).isEqualTo((Object)3345.6000366210938);
    }

    @Test(expected=RuntimeException.class)
    public void testAggregationByNoFunctionColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column("department", "Department")).column(AggregateFunctionType.COUNT, "#items")).sort("id", SortOrder.ASCENDING)).buildLookup());
    }

    @Test
    public void testAggregationWithColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("department")).column("department", "Department")).column(AggregateFunctionType.COUNT, "#items")).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(5);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)"Engineering");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)19.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 0)).isEqualTo((Object)"Management");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(1, 1)).isEqualTo((Object)11.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 0)).isEqualTo((Object)"Sales");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(2, 1)).isEqualTo((Object)8.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 0)).isEqualTo((Object)"Services");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(3, 1)).isEqualTo((Object)5.0);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 0)).isEqualTo((Object)"Support");
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(4, 1)).isEqualTo((Object)7.0);
    }

    @Test(expected=RuntimeException.class)
    public void testAggregationGroupByNonExistingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("mycolumn")).buildLookup());
    }

    @Test(expected=RuntimeException.class)
    public void testAggregationFunctionByNonExistingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("department")).column("department", "Department")).column(AggregateFunctionType.COUNT, "Occurrences")).column("mycolumn", AggregateFunctionType.MIN, "min")).buildLookup());
    }

    @Test
    public void testFilterEqualsByStringNotAnalyzed() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("city", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(6);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        Assertions.assertDataSetValue((DataSet)result, (int)5, (int)0, (String)"6.00");
    }

    @Test
    public void testFilterEqualsByStringAnalyzed() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Nita Marling"))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"9.00");
        Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"12.00");
    }

    @Test
    public void testFilterLikeToByStringAnalyzedAndCaseSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"Jul%", (boolean)true)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"jul%", (boolean)true)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"Jul%", (boolean)true)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"jul%", (boolean)true)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
    }

    @Test
    public void testFilterLikeToByStringAnalyzedAndCaseUnSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"Jul%", (boolean)false)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"jul%", (boolean)false)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"Jul%", (boolean)false)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_CSENSITIVE_UUID)).filter("employee", new ColumnFilter[]{FilterFactory.likeTo((String)"employee", (String)"jul%", (boolean)false)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
    }

    @Test
    public void testFilterLikeToByStringNotAnalyzedAndCaseSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("department", new ColumnFilter[]{FilterFactory.likeTo((String)"department", (String)"Sal%", (boolean)true)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(8);
    }

    @Test(expected=RuntimeException.class)
    public void testFilterLikeToByStringNotAnalyzedAndCaseUnSensitive() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("department", new ColumnFilter[]{FilterFactory.likeTo((String)"department", (String)"Sal%", (boolean)false)})).sort("id", SortOrder.ASCENDING)).buildLookup());
        this.printDataSet(result);
    }

    @Test
    public void testFilterByNumber() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("amount", new ColumnFilter[]{FilterFactory.between((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"6.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"17.00");
        Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"33.00");
    }

    @Test
    public void testFilterByDate() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(2012, 0, 0, 0, 0);
        Timestamp date = new Timestamp(c.getTime().getTime());
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("date", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)new Timestamp(date.getTime()))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(15);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"2.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"3.00");
        Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"4.00");
        Assertions.assertDataSetValue((DataSet)result, (int)4, (int)0, (String)"5.00");
        Assertions.assertDataSetValue((DataSet)result, (int)5, (int)0, (String)"6.00");
        Assertions.assertDataSetValue((DataSet)result, (int)6, (int)0, (String)"7.00");
        Assertions.assertDataSetValue((DataSet)result, (int)7, (int)0, (String)"8.00");
        Assertions.assertDataSetValue((DataSet)result, (int)8, (int)0, (String)"9.00");
        Assertions.assertDataSetValue((DataSet)result, (int)9, (int)0, (String)"10.00");
        Assertions.assertDataSetValue((DataSet)result, (int)10, (int)0, (String)"11.00");
        Assertions.assertDataSetValue((DataSet)result, (int)11, (int)0, (String)"12.00");
        Assertions.assertDataSetValue((DataSet)result, (int)12, (int)0, (String)"13.00");
        Assertions.assertDataSetValue((DataSet)result, (int)13, (int)0, (String)"14.00");
        Assertions.assertDataSetValue((DataSet)result, (int)14, (int)0, (String)"15.00");
    }

    @Test
    public void testFilterMultipleByDate() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(2010, 0, 0, 0, 0);
        Timestamp date = new Timestamp(c.getTime().getTime());
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("date", new ColumnFilter[]{FilterFactory.lowerThan((Comparable)new Timestamp(date.getTime()))})).filter("amount", new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(500))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(4);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"45.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"47.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"49.00");
        Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"50.00");
    }

    @Test
    public void testFilterMultiple() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("amount", new ColumnFilter[]{FilterFactory.lowerOrEqualsTo((Comparable)Double.valueOf(120.35))})).filter("city", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("city", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).filter("amount", new ColumnFilter[]{FilterFactory.lowerOrEqualsTo((Comparable)Double.valueOf(120.35))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
    }

    @Test
    public void testFilterMultiple2() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("city", new ColumnFilter[]{FilterFactory.notEqualsTo((Comparable)((Object)"Barcelona"))})).filter("amount", new ColumnFilter[]{FilterFactory.greaterOrEqualsTo((Comparable)Integer.valueOf(1000))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"15.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"23.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"24.00");
    }

    @Test(expected=RuntimeException.class)
    public void testFilterByNonExistingColumn() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("myfield", new ColumnFilter[]{FilterFactory.greaterOrEqualsTo((Comparable)Integer.valueOf(1000))})).buildLookup());
    }

    @Test
    public void testANDExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("amount", new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(100)), FilterFactory.lowerThan((Comparable)Integer.valueOf(150))})})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
    }

    @Test
    public void testORExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("amount", new ColumnFilter[]{FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.lowerThan((Comparable)Integer.valueOf(200)), FilterFactory.greaterThan((Comparable)Integer.valueOf(1000))})})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(11);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"2.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"6.00");
        Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"9.00");
        Assertions.assertDataSetValue((DataSet)result, (int)4, (int)0, (String)"10.00");
        Assertions.assertDataSetValue((DataSet)result, (int)5, (int)0, (String)"15.00");
        Assertions.assertDataSetValue((DataSet)result, (int)6, (int)0, (String)"17.00");
        Assertions.assertDataSetValue((DataSet)result, (int)7, (int)0, (String)"23.00");
        Assertions.assertDataSetValue((DataSet)result, (int)8, (int)0, (String)"24.00");
        Assertions.assertDataSetValue((DataSet)result, (int)9, (int)0, (String)"30.00");
        Assertions.assertDataSetValue((DataSet)result, (int)10, (int)0, (String)"33.00");
    }

    @Test
    public void testNOTExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("amount", new ColumnFilter[]{FilterFactory.NOT((ColumnFilter[])new ColumnFilter[]{FilterFactory.greaterThan((Comparable)Integer.valueOf(200))})})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(7);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"6.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"9.00");
        Assertions.assertDataSetValue((DataSet)result, (int)3, (int)0, (String)"10.00");
        Assertions.assertDataSetValue((DataSet)result, (int)4, (int)0, (String)"17.00");
        Assertions.assertDataSetValue((DataSet)result, (int)5, (int)0, (String)"30.00");
        Assertions.assertDataSetValue((DataSet)result, (int)6, (int)0, (String)"33.00");
    }

    @Test
    public void testCombinedExpression() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("amount", new ColumnFilter[]{FilterFactory.AND((ColumnFilter[])new ColumnFilter[]{FilterFactory.equalsTo((String)"department", (Comparable)((Object)"Sales")), FilterFactory.OR((ColumnFilter[])new ColumnFilter[]{FilterFactory.NOT((ColumnFilter[])new ColumnFilter[]{FilterFactory.lowerThan((Comparable)Integer.valueOf(300))}), FilterFactory.equalsTo((String)"city", (Comparable)((Object)"Madrid"))})})})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(7);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"9.00");
        Assertions.assertDataSetValue((DataSet)result, (int)6, (int)0, (String)"28.00");
    }

    @Test
    public void testFilterByAnalyzedAndNonAnalyzedColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("city", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).filter("employee", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Jamie Gilbeau"))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"4.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"5.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"6.00");
    }

    @Test
    public void testFilterByNonAnalyzedAndNonAnalyzedColumns() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("city", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Barcelona"))})).filter("department", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Engineering"))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(3);
        Assertions.assertDataSetValue((DataSet)result, (int)0, (int)0, (String)"1.00");
        Assertions.assertDataSetValue((DataSet)result, (int)1, (int)0, (String)"2.00");
        Assertions.assertDataSetValue((DataSet)result, (int)2, (int)0, (String)"3.00");
    }

    @Test
    public void testAggregationAndFilterByAnalyzedField() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column(AggregateFunctionType.COUNT, "#items")).filter("employee", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Roxie Foraker"))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)5.0);
    }

    @Test
    public void testAggregationAndFilterByNonAnalyzedField() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).column(AggregateFunctionType.COUNT, "#items")).filter("department", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"Engineering"))})).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.fest.assertions.api.Assertions.assertThat((int)result.getRowCount()).isEqualTo(1);
        org.fest.assertions.api.Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)19.0);
    }
}

