/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTestBase;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.sort.SortOrder;
import org.fest.assertions.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ElasticSearchDataSetDatesTest
extends ElasticSearchDataSetTestBase {
    protected static final String EL_EXAMPLE_DATASET_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/expensereports.dset";
    protected static final String EL_DATASET_UUID = "expense_reports";

    @Before
    public void registerDataSet() throws Exception {
        this._registerDataSet(EL_EXAMPLE_DATASET_DEF);
    }

    @Test
    public void testGroupByDynamicAutomaticInvertvalsCalculation() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).dynamic(5, true)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"2009", "13.00", "6,126.13"}, {"2010", "11.00", "5,252.96"}, {"2011", "11.00", "6,515.38"}, {"2012", "15.00", "7,336.69"}}, (int)0);
    }

    @Test
    public void testGroupByYearDynamic() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).dynamic(DateIntervalType.YEAR, true)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"2009", "13.00", "6,126.13"}, {"2010", "11.00", "5,252.96"}, {"2011", "11.00", "6,515.38"}, {"2012", "15.00", "7,336.69"}}, (int)0);
    }

    @Test
    public void testGroupByYearDynamicWithNoColumnId() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).dynamic(DateIntervalType.YEAR, true)).column("date")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).sort("id", SortOrder.ASCENDING)).buildLookup());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"2009", "13.00", "6,126.13"}, {"2010", "11.00", "5,252.96"}, {"2011", "11.00", "6,515.38"}, {"2012", "15.00", "7,336.69"}}, (int)0);
    }

    @Test
    public void testGroupByMonthDynamic() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).dynamic(99, DateIntervalType.MONTH, true)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).sort("id", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(48);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)"2009-01");
        Assertions.assertThat((Object)result.getValueAt(0, 1)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)result.getValueAt(0, 2)).isEqualTo((Object)921.9f);
        Assertions.assertThat((Object)result.getValueAt(1, 0)).isEqualTo((Object)"2009-02");
        Assertions.assertThat((Object)result.getValueAt(1, 1)).isEqualTo((Object)1.0);
        Assertions.assertThat((Object)result.getValueAt(1, 2)).isEqualTo((Object)700.66f);
        Assertions.assertThat((Object)result.getValueAt(47, 0)).isEqualTo((Object)"2012-12");
        Assertions.assertThat((Object)result.getValueAt(47, 1)).isEqualTo((Object)2.0);
        Assertions.assertThat((Object)result.getValueAt(47, 2)).isEqualTo((Object)1220.4499740600586);
    }

    @Test
    public void testGroupByDayDynamic() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).dynamic(9999, DateIntervalType.DAY, true)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).sort("id", SortOrder.ASCENDING)).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(1438);
        Assertions.assertThat((Object)result.getValueAt(0, 0)).isEqualTo((Object)"2009-01-04");
    }

    @Test
    public void testTimeFrameFunction() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).filter("date", new ColumnFilter[]{FilterFactory.timeFrame((String)"10second")})).buildLookup());
        Assertions.assertThat((int)result.getRowCount()).isEqualTo(0);
    }

    @Test
    public void testGroupByMonthFixed() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.MONTH, true)).column("date", "date")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"1", "3.00", "2,324.20"}, {"2", "6.00", "2,885.57"}, {"3", "5.00", "2,413.45"}, {"4", "3.00", "2,160.06"}, {"5", "5.00", "2,503.34"}, {"6", "9.00", "4,113.87"}, {"7", "4.00", "2,354.04"}, {"8", "2.00", "452.25"}, {"9", "3.00", "693.35"}, {"10", "3.00", "1,366.40"}, {"11", "3.00", "1,443.75"}, {"12", "4.00", "2,520.88"}}, (int)0);
    }

    @Test
    public void testGroupByMonthReverse() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.MONTH, true)).desc()).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"12", "4.00", "2,520.88"}, {"11", "3.00", "1,443.75"}, {"10", "3.00", "1,366.40"}, {"9", "3.00", "693.35"}, {"8", "2.00", "452.25"}, {"7", "4.00", "2,354.04"}, {"6", "9.00", "4,113.87"}, {"5", "5.00", "2,503.34"}, {"4", "3.00", "2,160.06"}, {"3", "5.00", "2,413.45"}, {"2", "6.00", "2,885.57"}, {"1", "3.00", "2,324.20"}}, (int)0);
    }

    @Test
    public void testGroupByMonthFirstMonth() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.MONTH, true)).firstMonth(Month.NOVEMBER)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup());
        this.printDataSet(result);
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"11", "3.00", "1,443.75"}, {"12", "4.00", "2,520.88"}, {"1", "3.00", "2,324.20"}, {"2", "6.00", "2,885.57"}, {"3", "5.00", "2,413.45"}, {"4", "3.00", "2,160.06"}, {"5", "5.00", "2,503.34"}, {"6", "9.00", "4,113.87"}, {"7", "4.00", "2,354.04"}, {"8", "2.00", "452.25"}, {"9", "3.00", "693.35"}, {"10", "3.00", "1,366.40"}}, (int)0);
    }

    @Test
    public void testGroupByMonthFirstMonthReverse() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.MONTH, true)).desc()).firstMonth(Month.MARCH)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"3", "5.00", "2,413.45"}, {"2", "6.00", "2,885.57"}, {"1", "3.00", "2,324.20"}, {"12", "4.00", "2,520.88"}, {"11", "3.00", "1,443.75"}, {"10", "3.00", "1,366.40"}, {"9", "3.00", "693.35"}, {"8", "2.00", "452.25"}, {"7", "4.00", "2,354.04"}, {"6", "9.00", "4,113.87"}, {"5", "5.00", "2,503.34"}, {"4", "3.00", "2,160.06"}}, (int)0);
    }

    @Test
    public void testGroupByWeekFirstDayMonday() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.DAY_OF_WEEK, true)).firstDay(DayOfWeek.MONDAY)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup().cloneInstance());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"2", "6.00", "2,278.07"}, {"3", "7.00", "3,932.06"}, {"4", "7.00", "2,965.08"}, {"5", "5.00", "2,759.12"}, {"6", "12.00", "5,170.74"}, {"7", "6.00", "3,880.54"}, {"1", "7.00", "4,245.55"}}, (int)0);
    }

    @Test
    public void testGroupByWeekFirstDayMondayDesc() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.DAY_OF_WEEK, true)).firstDay(DayOfWeek.MONDAY)).desc()).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup().cloneInstance());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"2", "6.00", "2,278.07"}, {"1", "7.00", "4,245.55"}, {"7", "6.00", "3,880.54"}, {"6", "12.00", "5,170.74"}, {"5", "5.00", "2,759.12"}, {"4", "7.00", "2,965.08"}, {"3", "7.00", "3,932.06"}}, (int)0);
    }

    @Test
    public void testGroupByWeekFirstDaySunday() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.DAY_OF_WEEK, true)).firstDay(DayOfWeek.SUNDAY)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup().cloneInstance());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"1", "7.00", "4,245.55"}, {"2", "6.00", "2,278.07"}, {"3", "7.00", "3,932.06"}, {"4", "7.00", "2,965.08"}, {"5", "5.00", "2,759.12"}, {"6", "12.00", "5,170.74"}, {"7", "6.00", "3,880.54"}}, (int)0);
    }

    @Test
    public void testGroupByQuarter() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_UUID)).group("date")).fixed(DateIntervalType.QUARTER, true)).column("date", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("amount", AggregateFunctionType.SUM, "totalAmount")).buildLookup().cloneInstance());
        org.dashbuilder.dataset.Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"1", "14.00", "7,623.22"}, {"2", "17.00", "8,777.27"}, {"3", "9.00", "3,499.64"}, {"4", "10.00", "5,331.03"}}, (int)0);
    }
}

