/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AbstractAdapter;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;

public class AggregationsDeserializer
extends AbstractAdapter<AggregationsDeserializer>
implements JsonDeserializer<SearchHitResponse[]> {
    public AggregationsDeserializer(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns) {
        super(client, metadata, columns);
    }

    public SearchHitResponse[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject aggregationsObject;
        Set entries;
        LinkedList<SearchHitResponse> result = null;
        if (typeOfT.equals(SearchHitResponse[].class) && (entries = (aggregationsObject = (JsonObject)json).entrySet()) != null && !entries.isEmpty()) {
            HashMap<String, JsonElement> noBucketFields = new HashMap<String, JsonElement>();
            result = new LinkedList<SearchHitResponse>();
            for (Map.Entry entry : entries) {
                String columnId = (String)entry.getKey();
                JsonElement columnAggregationElement = (JsonElement)entry.getValue();
                if (columnAggregationElement == null || !columnAggregationElement.isJsonObject()) continue;
                JsonElement bucketsElement = ((JsonObject)columnAggregationElement).get("buckets");
                if (bucketsElement != null && bucketsElement.isJsonArray()) {
                    Iterator bucketsIt = ((JsonArray)bucketsElement).iterator();
                    while (bucketsIt.hasNext()) {
                        HashMap<String, JsonElement> bucketFields = new HashMap<String, JsonElement>();
                        JsonObject bucket = (JsonObject)bucketsIt.next();
                        Set bucketEntries = bucket.entrySet();
                        boolean keyAsStringFound = false;
                        for (Map.Entry bucketEntry : bucketEntries) {
                            String aggName = (String)bucketEntry.getKey();
                            if ("key_as_string".equals(aggName)) {
                                bucketFields.put(columnId, (JsonElement)bucketEntry.getValue());
                                keyAsStringFound = true;
                                continue;
                            }
                            if (!keyAsStringFound && "key".equals(aggName)) {
                                bucketFields.put(columnId, (JsonElement)bucketEntry.getValue());
                                continue;
                            }
                            if ("doc_count".equals(aggName) || this.getColumn(aggName) == null) continue;
                            JsonElement aggValueElement = (JsonElement)bucketEntry.getValue();
                            if (aggValueElement != null && aggValueElement.isJsonPrimitive()) {
                                bucketFields.put(aggName, aggValueElement);
                                continue;
                            }
                            if (aggValueElement == null || !aggValueElement.isJsonObject()) continue;
                            bucketFields.put(aggName, ((JsonObject)bucketEntry.getValue()).get("value"));
                        }
                        result.add(this.createHitResponse(this.metadata, bucketFields, this.columns));
                    }
                    continue;
                }
                JsonElement aggValueElement = ((JsonObject)columnAggregationElement).get("value");
                if (aggValueElement == null || !aggValueElement.isJsonPrimitive()) continue;
                noBucketFields.put(columnId, aggValueElement);
            }
            if (!noBucketFields.isEmpty()) {
                result.add(this.createHitResponse(this.metadata, noBucketFields, this.columns));
            }
        }
        if (result == null) {
            return null;
        }
        return result.toArray(new SearchHitResponse[result.size()]);
    }

    private SearchHitResponse createHitResponse(DataSetMetadata metadata, Map<String, JsonElement> fields, List<DataColumn> columns) throws JsonParseException {
        try {
            return new SearchHitResponse(this.orderAndParseFields(metadata, fields, columns));
        }
        catch (ParseException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

