/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.DataSetManager;
import org.dashbuilder.dataset.backend.DataSetDefJSONMarshaller;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.elasticsearch.bootstrap.Elasticsearch;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Assert;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class ElasticSearchDataSetTestBase {
    static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataSetTestBase.class);
    public static final String EL_SERVER = "http://localhost:9200/";
    protected static final String EL_PROPERTY_ELASTICSEARCH = "elasticsearch";
    protected static final String EL_PROPERTY_HOME = "es.path.home";
    protected static final String EL_PROPERTY_FOREGROUND = "es.foreground";
    protected static final String EL_PROPERTY_SCRIPT_INLINE = "es.script.inline";
    protected static final String EL_PROPERTY_SCRIPT_INDEXED = "es.script.indexed";
    protected static final String EL_CONFIG_DIR = "config";
    protected static final String EL_CONFIG_ELASTICSEARCH = "org/dashbuilder/dataprovider/backend/elasticsearch/server/config/elasticsearch.yml";
    protected static final String EL_CONFIG_LOGGING = "org/dashbuilder/dataprovider/backend/elasticsearch/server/config/logging.yml";
    protected static final String EL_EXAMPLE_INDEX = "expensereports";
    protected static final String EL_EXAMPLE_MAPPINGS = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-mappings.json";
    protected static final String EL_EXAMPLE_DATA = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-data.json";
    protected static final String EL_EXAMPLE_CSENSITIVE_INDEX = "expensereports-sensitive";
    protected static final String EL_EXAMPLE_CSENSITIVE_MAPPINGS = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-csensitive-mappings.json";
    protected static final String EL_EXAMPLE_CSENSITIVE_DATA = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-csensitive-data.json";
    protected static final String EL_EXAMPLE_MORE_DATA = "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-more-data.json";
    protected static final String EL_EXAMPLE_COLUMN_ID = "id";
    protected static final String EL_EXAMPLE_COLUMN_AMOUNT = "amount";
    protected static final String EL_EXAMPLE_COLUMN_DEPT = "department";
    protected static final String EL_EXAMPLE_COLUMN_EMPLOYEE = "employee";
    protected static final String EL_EXAMPLE_COLUMN_DATE = "date";
    protected static final String EL_EXAMPLE_COLUMN_CITY = "city";
    protected static final String EL_EXAMPLE_DEPT_ENGINEERING = "Engineering";
    protected static final String EL_EXAMPLE_DEPT_SERVICES = "Services";
    protected static final String EL_EXAMPLE_DEPT_MANAGEMENT = "Management";
    protected static final String EL_EXAMPLE_DEPT_SALES = "Sales";
    protected static final String EL_EXAMPLE_DEPT_SUPPORT = "Support";
    protected static final String EL_EXAMPLE_CITY_BARCELONA = "Barcelona";
    protected static final String EL_EXAMPLE_CITY_MADRID = "Madrid";
    protected static final String EL_EXAMPLE_CITY_RALEIGH = "Raleigh";
    protected static final String EL_EXAMPLE_CITY_LONDON = "London";
    protected static final String EL_EXAMPLE_EMP_ROXIE = "Roxie Foraker";
    protected static final String EL_EXAMPLE_EMP_JAMIE = "Jamie Gilbeau";
    protected static final String EL_EXAMPLE_EMP_NITA = "Nita Marling";
    protected static final String EL_EXAMPLE_EMP_HANNA = "Hannah B. Mackey";
    protected static final String EL_EXAMPLE_EMP_PATRICIA = "Patricia J. Behr";
    protected static final String EL_REST_BULK = "_bulk";
    protected static final String EL_REST_COUNT = "_count";
    protected static final int EL_REST_RESPONSE_OK = 200;
    protected static final int EL_REST_RESPONSE_CREATED = 201;
    protected static final String HEADER_ACCEPT = "Accept";
    protected static final String HEADER_CONTENTTYPE = "content-type";
    protected static final String CONTENTTYPE_TEXTPLAIN = "text/plain; charset=utf-8";
    protected static final String CONTENTTYPE_JSON = "application/json; charset=utf-8";
    protected static final String ENCODING = "UTF-8";
    protected static final String SYMBOL_SLASH = "/";
    @Inject
    DataSetManager dataSetManager;
    @Inject
    DataSetFormatter dataSetFormatter;
    @Inject
    DataSetDefRegistry dataSetDefRegistry;
    @Inject
    DataSetDefJSONMarshaller jsonMarshaller;
    private static Thread ELS_THREAD = new Thread("dashbuilder_test_ELS"){

        @Override
        public void run() {
            ElasticSearchDataSetTestBase.startInstance();
        }
    };

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    public static void runELServer(TemporaryFolder elHomeFolder) throws Exception {
        File elHome = elHomeFolder.newFolder("dashbuilder-elasticsearch");
        File elHomeConfig = new File(elHome, EL_CONFIG_DIR);
        URL configFileUrl = Thread.currentThread().getContextClassLoader().getResource(EL_CONFIG_ELASTICSEARCH);
        URL loggingFileUrl = Thread.currentThread().getContextClassLoader().getResource(EL_CONFIG_LOGGING);
        File configFile = new File(configFileUrl.getFile());
        File loggingFile = new File(loggingFileUrl.getFile());
        if (!elHomeConfig.mkdirs()) {
            throw new RuntimeException("Cannot create config directory at [" + elHomeConfig.getAbsolutePath() + "].");
        }
        FileUtils.copyFileToDirectory((File)configFile, (File)elHomeConfig);
        FileUtils.copyFileToDirectory((File)loggingFile, (File)elHomeConfig);
        System.setProperty(EL_PROPERTY_ELASTICSEARCH, "");
        System.setProperty(EL_PROPERTY_FOREGROUND, "yes");
        System.setProperty(EL_PROPERTY_HOME, elHome.getAbsolutePath());
        System.setProperty(EL_PROPERTY_SCRIPT_INLINE, "on");
        System.setProperty(EL_PROPERTY_SCRIPT_INDEXED, "on");
        ElasticSearchDataSetTestBase.startInstance();
    }

    public static void createAndPopulateExpenseReportsIndex() throws Exception {
        ElasticSearchUrlBuilder urlBuilder = new ElasticSearchUrlBuilder(EL_SERVER, EL_EXAMPLE_INDEX);
        ElasticSearchDataSetTestBase.createIndexELServer(urlBuilder, EL_EXAMPLE_MAPPINGS);
        ElasticSearchDataSetTestBase.populateELServer(urlBuilder, EL_EXAMPLE_DATA);
        ElasticSearchDataSetTestBase.testMappingCreated(urlBuilder);
        ElasticSearchDataSetTestBase.testDocumentsCount(urlBuilder);
    }

    public static void createAndPopulateExpenseReportsCSensitiveIndex() throws Exception {
        ElasticSearchUrlBuilder urlBuilder = new ElasticSearchUrlBuilder(EL_SERVER, EL_EXAMPLE_CSENSITIVE_INDEX);
        ElasticSearchDataSetTestBase.createIndexELServer(urlBuilder, EL_EXAMPLE_CSENSITIVE_MAPPINGS);
        ElasticSearchDataSetTestBase.populateELServer(urlBuilder, EL_EXAMPLE_CSENSITIVE_DATA);
        ElasticSearchDataSetTestBase.testMappingCreated(urlBuilder);
        ElasticSearchDataSetTestBase.testDocumentsCount(urlBuilder);
    }

    private static void startInstance() {
        Elasticsearch.main((String[])new String[0]);
    }

    public static void createIndexELServer(ElasticSearchUrlBuilder urlBuilder, String jsonMappingsFile) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        String mappingsContent = ElasticSearchDataSetTestBase.getFileAsString(jsonMappingsFile);
        HttpPost httpPost = new HttpPost(urlBuilder.getIndexRoot());
        StringEntity inputMappings = new StringEntity(mappingsContent);
        inputMappings.setContentType(CONTENTTYPE_JSON);
        httpPost.setEntity((HttpEntity)inputMappings);
        CloseableHttpResponse mappingsResponse = httpclient.execute((HttpUriRequest)httpPost);
        if (mappingsResponse.getStatusLine().getStatusCode() != 200) {
            ElasticSearchDataSetTestBase.log("Error response body:");
            ElasticSearchDataSetTestBase.log(ElasticSearchDataSetTestBase.responseAsString(mappingsResponse));
        }
        Assert.assertEquals((long)200L, (long)mappingsResponse.getStatusLine().getStatusCode());
    }

    public static void populateELServer(ElasticSearchUrlBuilder urlBuilder, String dataFile) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        File dataContentFile = new File(Thread.currentThread().getContextClassLoader().getResource(dataFile).getFile());
        ElasticSearchDataSetTestBase.addDocuments(httpclient, urlBuilder, dataContentFile);
        Thread.sleep(5000L);
    }

    protected static void addDocuments(CloseableHttpClient httpClient, ElasticSearchUrlBuilder urlBuilder, File dataContentFile) throws Exception {
        HttpPost httpPost2 = new HttpPost(urlBuilder.getBulk());
        FileEntity inputData = new FileEntity(dataContentFile);
        inputData.setContentType(CONTENTTYPE_JSON);
        httpPost2.addHeader(HEADER_ACCEPT, CONTENTTYPE_JSON);
        httpPost2.addHeader(HEADER_CONTENTTYPE, CONTENTTYPE_JSON);
        httpPost2.setEntity((HttpEntity)inputData);
        CloseableHttpResponse dataResponse = httpClient.execute((HttpUriRequest)httpPost2);
        if (dataResponse.getStatusLine().getStatusCode() != 200) {
            ElasticSearchDataSetTestBase.log("Error response body:");
            ElasticSearchDataSetTestBase.log(ElasticSearchDataSetTestBase.responseAsString(dataResponse));
        }
        httpPost2.completed();
        Assert.assertEquals((long)dataResponse.getStatusLine().getStatusCode(), (long)200L);
    }

    protected static void addDocument(ElasticSearchUrlBuilder urlBuilder, CloseableHttpClient httpclient, String type, String document) throws Exception {
        HttpPost httpPut = new HttpPost(urlBuilder.getIndexRoot() + SYMBOL_SLASH + type);
        StringEntity inputData = new StringEntity(document);
        inputData.setContentType(CONTENTTYPE_JSON);
        httpPut.addHeader(HEADER_ACCEPT, CONTENTTYPE_JSON);
        httpPut.addHeader(HEADER_CONTENTTYPE, CONTENTTYPE_JSON);
        httpPut.setEntity((HttpEntity)inputData);
        CloseableHttpResponse dataResponse = httpclient.execute((HttpUriRequest)httpPut);
        if (dataResponse.getStatusLine().getStatusCode() != 201) {
            ElasticSearchDataSetTestBase.log("Error response body:");
            ElasticSearchDataSetTestBase.log(ElasticSearchDataSetTestBase.responseAsString(dataResponse));
        }
        Assert.assertEquals((long)dataResponse.getStatusLine().getStatusCode(), (long)201L);
    }

    public static void stopELServer(TemporaryFolder elHomeFolder) throws Exception {
        System.clearProperty(EL_PROPERTY_ELASTICSEARCH);
        System.clearProperty(EL_PROPERTY_FOREGROUND);
        System.clearProperty(EL_PROPERTY_HOME);
        System.clearProperty(EL_PROPERTY_SCRIPT_INLINE);
        System.clearProperty(EL_PROPERTY_SCRIPT_INDEXED);
        Elasticsearch.close((String[])new String[0]);
        elHomeFolder.delete();
    }

    protected ElasticSearchDataSetDef _registerDataSet(String resource) throws Exception {
        URL fileURL = Thread.currentThread().getContextClassLoader().getResource(resource);
        String json = IOUtils.toString((URL)fileURL);
        ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)this.jsonMarshaller.fromJson(json);
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        return def;
    }

    public static void testMappingCreated(ElasticSearchUrlBuilder urlBuilder) throws Exception {
        Object[] response = ElasticSearchDataSetTestBase.doGet(urlBuilder.getIndexRoot());
        Assert.assertEquals((Object)response[0], (Object)200);
        ElasticSearchDataSetTestBase.log("Mappings for index [expensereports]:");
        ElasticSearchDataSetTestBase.log(response[1]);
    }

    public static void testDocumentsCount(ElasticSearchUrlBuilder urlBuilder) throws Exception {
        Object[] response = ElasticSearchDataSetTestBase.doGet(urlBuilder.getIndexCount());
        Assert.assertEquals((Object)response[0], (Object)200);
        ElasticSearchDataSetTestBase.log("Count for index [expensereports]:");
        ElasticSearchDataSetTestBase.log(response[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getFileAsString(String file) throws Exception {
        InputStream mappingsFileUrl = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        StringWriter writer = null;
        String fileContent = null;
        try {
            writer = new StringWriter();
            IOUtils.copy((InputStream)mappingsFileUrl, (Writer)writer, (String)ENCODING);
            fileContent = writer.toString();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return fileContent.replaceAll("\n", "\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Object[] doGet(String url) throws Exception {
        Object[] response = null;
        if (url == null || url.trim().length() == 0) {
            return response;
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse response1 = httpclient.execute((HttpUriRequest)httpGet);
        try {
            HttpEntity entity1 = response1.getEntity();
            String responseBody = ElasticSearchDataSetTestBase.responseAsString(response1);
            int responseStatus = response1.getStatusLine().getStatusCode();
            response = new Object[]{responseStatus, responseBody};
            EntityUtils.consume((HttpEntity)entity1);
        }
        finally {
            response1.close();
        }
        return response;
    }

    protected static String responseAsString(CloseableHttpResponse response) throws IOException {
        return ElasticSearchDataSetTestBase.streamAsString(response.getEntity().getContent());
    }

    protected static String streamAsString(InputStream inputStream) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)ENCODING);
        return writer.toString();
    }

    protected static void log(Object message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message.toString());
        }
    }

    protected void printDataSet(DataSet dataSet) {
        String SPACER = "| \t |";
        if (dataSet == null) {
            ElasticSearchDataSetTestBase.log("DataSet is null");
        }
        if (dataSet.getRowCount() == 0) {
            ElasticSearchDataSetTestBase.log("DataSet is empty");
        }
        List dataSetColumns = dataSet.getColumns();
        int colColunt = dataSetColumns.size();
        int rowCount = dataSet.getRowCount();
        ElasticSearchDataSetTestBase.log("********************************************************************************************************************************************************");
        for (int row = 0; row < rowCount; ++row) {
            ElasticSearchDataSetTestBase.log("| \t |");
            for (int col = 0; col < colColunt; ++col) {
                Object value = dataSet.getValueAt(row, col);
                ElasticSearchDataSetTestBase.log(value);
                ElasticSearchDataSetTestBase.log("| \t |");
            }
            ElasticSearchDataSetTestBase.log("");
        }
        ElasticSearchDataSetTestBase.log("********************************************************************************************************************************************************");
    }

    public static class ElasticSearchUrlBuilder {
        private String serverUrl;
        private String index;

        public ElasticSearchUrlBuilder(String serverUrl, String index) {
            Assert.assertTrue((serverUrl != null && serverUrl.trim().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((index != null && index.trim().length() > 0 && !index.endsWith(ElasticSearchDataSetTestBase.SYMBOL_SLASH) ? 1 : 0) != 0);
            this.serverUrl = serverUrl;
            this.index = index;
            if (!this.serverUrl.endsWith(ElasticSearchDataSetTestBase.SYMBOL_SLASH)) {
                this.serverUrl = this.serverUrl + ElasticSearchDataSetTestBase.SYMBOL_SLASH;
            }
        }

        public String getRoot() {
            return this.serverUrl;
        }

        public String getIndexRoot() {
            return this.serverUrl + this.index;
        }

        public String getIndexCount() {
            return this.getIndexRoot() + ElasticSearchDataSetTestBase.SYMBOL_SLASH + ElasticSearchDataSetTestBase.EL_REST_COUNT;
        }

        public String getBulk() {
            return this.serverUrl + ElasticSearchDataSetTestBase.EL_REST_BULK;
        }
    }
}

