/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetProvider;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchJSONParser;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;

@ApplicationScoped
public class ElasticSearchClientFactory {
    @Inject
    protected ElasticSearchValueTypeMapper valueTypeMapper;
    @Inject
    protected ElasticSearchJSONParser jsonParser;
    @Inject
    protected ElasticSearchUtils utils;

    public ElasticSearchClient newClient(ElasticSearchDataSetDef elasticSearchDataSetDef) {
        ElasticSearchClient client = this.newClient();
        return ElasticSearchClientFactory.configure(client, elasticSearchDataSetDef);
    }

    private ElasticSearchClient newClient() {
        return this.newJestClient();
    }

    private ElasticSearchClient newJestClient() {
        return new ElasticSearchJestClient(this, this.valueTypeMapper, this.utils);
    }

    public static ElasticSearchClient configure(ElasticSearchClient client, ElasticSearchDataSetDef elasticSearchDataSetDef) {
        String[] types;
        String serverURL = elasticSearchDataSetDef.getServerURL();
        String clusterName = elasticSearchDataSetDef.getClusterName();
        if (serverURL == null || serverURL.trim().length() == 0) {
            throw new IllegalArgumentException("Server URL is not set.");
        }
        if (clusterName == null || clusterName.trim().length() == 0) {
            throw new IllegalArgumentException("Cluster name is not set.");
        }
        client.serverURL(serverURL).clusterName(clusterName);
        String[] indexes = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getIndex());
        if (indexes != null && indexes.length > 0) {
            client.index(indexes);
        }
        if ((types = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getType())) != null && types.length > 0) {
            client.type(types);
        }
        return client;
    }
}

