/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import javax.inject.Inject;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetProvider;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTestBase;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.fest.assertions.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class ElasticSearchDataSetCacheTest
extends ElasticSearchDataSetTestBase {
    protected static final String EL_EXAMPLE_DATASETS_ROOT = "org/dashbuilder/dataprovider/backend/elasticsearch/";
    protected static final String EL_DATASET_UUID = "expense_reports";
    @Inject
    ElasticSearchDataSetProvider elasticSearchDataSetProvider;

    @Test
    public void testDataSetNonCached() throws Exception {
        this._testDataSetCache(null, false, 52);
    }

    public void testDataSetStaticCache() throws Exception {
        this._testDataSetCache("static_cache", false, 50);
    }

    protected void _testDataSetCache(String scenario, boolean outdated, int rows) throws Exception {
        String fileName = scenario != null ? "expensereports-" + scenario + ".dset" : "expensereports.dset";
        ElasticSearchDataSetDef def = this._registerDataSet(EL_EXAMPLE_DATASETS_ROOT + fileName);
        String dataSetUUID = scenario != null ? "expense_reports_" + scenario : EL_DATASET_UUID;
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(dataSetUUID)).buildLookup());
        ElasticSearchDataSetTestBase.ElasticSearchUrlBuilder urlBuilder = new ElasticSearchDataSetTestBase.ElasticSearchUrlBuilder("http://localhost:9200/", "expensereports");
        ElasticSearchDataSetCacheTest.populateELServer(urlBuilder, "org/dashbuilder/dataprovider/backend/elasticsearch/server/example-data/expensereports-more-data.json");
        Assertions.assertThat((boolean)this.elasticSearchDataSetProvider.isDataSetOutdated((DataSetDef)def)).isEqualTo(outdated);
        DataSet result2 = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(dataSetUUID)).rowNumber(100)).buildLookup());
        Assertions.assertThat((int)result2.getRowCount()).isEqualTo(rows);
    }
}

