/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AggregationSerializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AggregationsDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.HitDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.QuerySerializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.SearchResponseDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.jboss.arquillian.junit.Arquillian;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=Arquillian.class)
public class ElasticSearchJestClientTest {
    @Mock
    protected DataSetMetadata metadata;
    @Mock
    protected ElasticSearchDataSetDef definition;
    protected ElasticSearchClientFactory clientFactory = new ElasticSearchClientFactory();
    protected ElasticSearchValueTypeMapper typeMapper = new ElasticSearchValueTypeMapper();
    protected ElasticSearchUtils utils = new ElasticSearchUtils(this.typeMapper);
    protected ElasticSearchJestClient client = new ElasticSearchJestClient(this.clientFactory, this.typeMapper, this.utils);
    protected ElasticSearchJestClient anotherClient = new ElasticSearchJestClient(this.clientFactory, this.typeMapper, this.utils);

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.metadata.getNumberOfColumns()).thenReturn((Object)6);
        Mockito.when((Object)this.metadata.getColumnId(0)).thenReturn((Object)"id");
        Mockito.when((Object)this.metadata.getColumnType(0)).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnType("id")).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnId(1)).thenReturn((Object)"city");
        Mockito.when((Object)this.metadata.getColumnType(1)).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnType("city")).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnId(2)).thenReturn((Object)"department");
        Mockito.when((Object)this.metadata.getColumnType(2)).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnType("department")).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnId(3)).thenReturn((Object)"employee");
        Mockito.when((Object)this.metadata.getColumnType(3)).thenReturn((Object)ColumnType.TEXT);
        Mockito.when((Object)this.metadata.getColumnType("employee")).thenReturn((Object)ColumnType.TEXT);
        Mockito.when((Object)this.metadata.getColumnId(4)).thenReturn((Object)"date");
        Mockito.when((Object)this.metadata.getColumnType(4)).thenReturn((Object)ColumnType.DATE);
        Mockito.when((Object)this.metadata.getColumnType("date")).thenReturn((Object)ColumnType.DATE);
        Mockito.when((Object)this.metadata.getColumnId(5)).thenReturn((Object)"amount");
        Mockito.when((Object)this.metadata.getColumnType(5)).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnType("amount")).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getDefinition()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getServerURL()).thenReturn((Object)"http://localhost:9200/");
        Mockito.when((Object)this.definition.getClusterName()).thenReturn((Object)"elasticsearch");
        Mockito.when((Object)this.definition.getIndex()).thenReturn((Object)"expensereports");
        Mockito.when((Object)this.definition.getType()).thenReturn((Object)"expense");
        Mockito.when((Object)this.definition.getPattern("id")).thenReturn((Object)"integer");
        Mockito.when((Object)this.definition.getPattern("date")).thenReturn((Object)"MM-dd-YYYY");
    }

    @Test
    public void testQuerySerializer() {
        GsonBuilder builder = new GsonBuilder();
        QuerySerializer querySerializer = new QuerySerializer(this.client, this.metadata, new ArrayList());
        builder.registerTypeAdapter(Query.class, (Object)querySerializer);
        Gson gson = builder.create();
        Query query = new Query(Query.Type.MATCH_ALL);
        String serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"query\":{\"match_all\":{}}}");
        query = new Query("department", Query.Type.MATCH);
        query.setParam(Query.Parameter.VALUE.name(), (Object)"Sales");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"query\":{\"match\":{\"department\":\"Sales\"}}}");
        query = new Query("department", Query.Type.WILDCARD);
        query.setParam(Query.Parameter.VALUE.name(), (Object)"Sal%");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"query\":{\"wildcard\":{\"department\":\"Sal%\"}}}");
        query = new Query("employee", Query.Type.QUERY_STRING);
        query.setParam(Query.Parameter.DEFAULT_FIELD.name(), (Object)"employee");
        query.setParam(Query.Parameter.DEFAULT_OPERATOR.name(), (Object)"AND");
        query.setParam(Query.Parameter.QUERY.name(), (Object)"Tony%");
        query.setParam(Query.Parameter.LOWERCASE_EXPANDED_TERMS.name(), (Object)"false");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"query\":{\"query_string\":{\"default_field\":\"employee\",\"default_operator\":\"AND\",\"query\":\"Tony%\",\"lowercase_expanded_terms\":\"false\"}}}");
        query = new Query("department", Query.Type.FILTERED);
        Query subQuery = new Query(Query.Type.MATCH_ALL);
        Query subFilter = new Query("amount", Query.Type.TERM);
        subFilter.setParam(Query.Parameter.VALUE.name(), (Object)"Sales");
        query.setParam(Query.Parameter.QUERY.name(), (Object)subQuery);
        query.setParam(Query.Parameter.FILTER.name(), (Object)subFilter);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"query\":{\"filtered\":{\"query\":{\"match_all\":{}},\"filter\":{\"term\":{\"amount\":\"Sales\"}}}}}");
        query = new Query("department", Query.Type.BOOL);
        query.setParam(Query.Parameter.MUST.name(), (Object)new Query(Query.Type.MATCH_ALL));
        query.setParam(Query.Parameter.MUST_NOT.name(), (Object)new Query(Query.Type.MATCH_ALL));
        query.setParam(Query.Parameter.SHOULD.name(), (Object)new Query(Query.Type.MATCH_ALL));
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"query\":{\"bool\":{\"must\":{\"match_all\":{}},\"must_not\":{\"match_all\":{}},\"should\":{\"match_all\":{}}}}}");
        query = new Query("department", Query.Type.TERM);
        query.setParam(Query.Parameter.VALUE.name(), (Object)"Sales");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"filter\":{\"term\":{\"department\":\"Sales\"}}}");
        query = new Query("department", Query.Type.AND);
        LinkedList<Query> filters = new LinkedList<Query>();
        filters.add(new Query("department", Query.Type.TERM).setParam(Query.Parameter.VALUE.name(), (Object)"Sales"));
        filters.add(new Query("amount", Query.Type.RANGE).setParam(Query.Parameter.GT.name(), (Object)100));
        query.setParam(Query.Parameter.FILTERS.name(), filters);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"filter\":{\"and\":[{\"term\":{\"department\":\"Sales\"}},{\"range\":{\"amount\":{\"gt\":100}}}]}}");
        query = new Query("department", Query.Type.OR);
        filters = new LinkedList();
        filters.add(new Query("department", Query.Type.TERM).setParam(Query.Parameter.VALUE.name(), (Object)"Sales"));
        filters.add(new Query("amount", Query.Type.RANGE).setParam(Query.Parameter.GT.name(), (Object)100));
        query.setParam(Query.Parameter.FILTERS.name(), filters);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"filter\":{\"or\":[{\"term\":{\"department\":\"Sales\"}},{\"range\":{\"amount\":{\"gt\":100}}}]}}");
        query = new Query("department", Query.Type.NOT);
        query.setParam(Query.Parameter.FILTER.name(), (Object)new Query("city", Query.Type.TERM).setParam(Query.Parameter.VALUE.name(), (Object)"London"));
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"filter\":{\"not\":{\"term\":{\"city\":\"London\"}}}}");
        query = new Query("department", Query.Type.EXISTS);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"filter\":{\"exists\":{\"field\":\"department\"}}}");
        query = new Query("amount", Query.Type.RANGE);
        query.setParam(Query.Parameter.LT.name(), (Object)100);
        query.setParam(Query.Parameter.LTE.name(), (Object)200);
        query.setParam(Query.Parameter.GT.name(), (Object)300);
        query.setParam(Query.Parameter.GTE.name(), (Object)400);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)serializedQuery, (Object)"{\"filter\":{\"range\":{\"amount\":{\"lt\":100,\"lte\":200,\"gt\":300,\"gte\":400}}}}");
    }

    @Test
    public void testSearchResponseDeserialization() throws Exception {
        String response = "{\"took\":4,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"failed\":0},\"hits\":{\"total\":8,\"max_score\":2.609438,\"hits\":[{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"12\",\"_score\":2.609438,\"_source\":{\"id\":12, \"city\": \"Madrid\", \"department\": \"Sales\", \"employee\": \"Nita Marling\" ,\"date\": \"03-02-2012\" , \"amount\":344.9}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"20\",\"_score\":2.609438,\"_source\":{\"id\":20, \"city\": \"Brno\", \"department\": \"Sales\", \"employee\": \"Neva Hunger\" ,\"date\": \"06-11-2011\" , \"amount\":995.3}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"21\",\"_score\":2.609438,\"_source\":{\"id\":21, \"city\": \"Brno\", \"department\": \"Sales\", \"employee\": \"Neva Hunger\" ,\"date\": \"06-11-2011\" , \"amount\":234.3}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"10\",\"_score\":2.2039728,\"_source\":{\"id\":10, \"city\": \"Madrid\", \"department\": \"Sales\", \"employee\": \"Nita Marling\" ,\"date\": \"03-11-2012\" , \"amount\":100}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"27\",\"_score\":2.2039728,\"_source\":{\"id\":27, \"city\": \"Westford\", \"department\": \"Sales\", \"employee\": \"Jerri Preble\" ,\"date\": \"12-23-2010\" , \"amount\":899.03}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"9\",\"_score\":1.9162908,\"_source\":{\"id\":9, \"city\": \"Madrid\", \"department\": \"Sales\", \"employee\": \"Nita Marling\" ,\"date\": \"05-11-2012\" , \"amount\":75.75}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"11\",\"_score\":1.9162908,\"_source\":{\"id\":11, \"city\": \"Madrid\", \"department\": \"Sales\", \"employee\": \"Nita Marling\" ,\"date\": \"03-16-2012\" , \"amount\":220.8}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"28\",\"_score\":1.9162908,\"_source\":{\"id\":28, \"city\": \"Westford\", \"department\": \"Sales\", \"employee\": \"Jerri Preble\" ,\"date\": \"11-30-2010\" , \"amount\":343.45}}]}}";
        DataColumnImpl col0 = new DataColumnImpl("id", ColumnType.NUMBER);
        DataColumnImpl col1 = new DataColumnImpl("city", ColumnType.LABEL);
        DataColumnImpl col2 = new DataColumnImpl("department", ColumnType.LABEL);
        DataColumnImpl col3 = new DataColumnImpl("employee", ColumnType.TEXT);
        DataColumnImpl col4 = new DataColumnImpl("date", ColumnType.DATE);
        DataColumnImpl col5 = new DataColumnImpl("amount", ColumnType.NUMBER);
        LinkedList<DataColumnImpl> columns = new LinkedList<DataColumnImpl>();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        columns.add(col3);
        columns.add(col4);
        columns.add(col5);
        GsonBuilder builder = new GsonBuilder();
        SearchResponseDeserializer searchResponseDeserializer = new SearchResponseDeserializer(this.client, this.metadata, columns);
        HitDeserializer hitDeserializer = new HitDeserializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(SearchResponse.class, (Object)searchResponseDeserializer);
        builder.registerTypeAdapter(SearchHitResponse.class, (Object)hitDeserializer);
        Gson gson = builder.create();
        SearchResponse result = (SearchResponse)gson.fromJson(response, SearchResponse.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)result.getTookInMillis(), (long)4L);
        Assert.assertEquals((double)result.getMaxScore(), (double)2.609437942504883, (double)0.1);
        Assert.assertEquals((long)result.getResponseStatus(), (long)200L);
        Assert.assertEquals((long)result.getShardFailures(), (long)0L);
        Assert.assertEquals((long)result.getTotalShards(), (long)5L);
        Assert.assertEquals((long)result.getSuccessfulShards(), (long)5L);
        Assert.assertEquals((long)result.getTotalHits(), (long)8L);
        Assert.assertEquals((long)result.getHits().length, (long)8L);
        SearchHitResponse hit0 = result.getHits()[0];
        Assert.assertNotNull((Object)hit0);
        Assert.assertEquals((Object)hit0.getIndex(), (Object)"expensereports");
        Assert.assertEquals((Object)hit0.getType(), (Object)"expense");
        Assert.assertEquals((Object)hit0.getId(), (Object)"12");
        Assert.assertEquals((double)hit0.getScore(), (double)2.609437942504883, (double)0.1);
        LinkedHashMap hit0Fields = hit0.getFields();
        Assert.assertNotNull((Object)hit0Fields);
        Assert.assertEquals((long)hit0Fields.size(), (long)6L);
        Assert.assertEquals((Object)hit0Fields.get("id").toString(), (Object)"12.0");
        Assert.assertEquals((Object)hit0Fields.get("city").toString(), (Object)"Madrid");
        Assert.assertEquals((Object)hit0Fields.get("department").toString(), (Object)"Sales");
        Assert.assertEquals((Object)hit0Fields.get("employee").toString(), (Object)"Nita Marling");
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse("2012-03-02");
        Assert.assertEquals(hit0Fields.get("date"), (Object)date);
        Assert.assertEquals((Object)hit0Fields.get("amount").toString(), (Object)"344.9");
        SearchHitResponse hit7 = result.getHits()[7];
        Assert.assertNotNull((Object)hit7);
        Assert.assertEquals((Object)hit7.getIndex(), (Object)"expensereports");
        Assert.assertEquals((Object)hit7.getType(), (Object)"expense");
        Assert.assertEquals((Object)hit7.getId(), (Object)"28");
        Assert.assertEquals((double)hit7.getScore(), (double)1.9162907600402832, (double)0.1);
        LinkedHashMap hit7Fields = hit7.getFields();
        Assert.assertNotNull((Object)hit7Fields);
        Assert.assertEquals((long)hit7Fields.size(), (long)6L);
        Assert.assertEquals((Object)hit7Fields.get("id").toString(), (Object)"28.0");
        Assert.assertEquals((Object)hit7Fields.get("city").toString(), (Object)"Westford");
        Assert.assertEquals((Object)hit7Fields.get("department").toString(), (Object)"Sales");
        Assert.assertEquals((Object)hit7Fields.get("employee").toString(), (Object)"Jerri Preble");
        date = new SimpleDateFormat("yyyy-MM-dd").parse("2010-11-30");
        Assert.assertEquals(hit7Fields.get("date"), (Object)date);
        Assert.assertEquals((Object)hit7Fields.get("amount").toString(), (Object)"343.45");
    }

    @Test
    public void testAggregationSerializer() {
        ElasticSearchJestClient c = (ElasticSearchJestClient)ElasticSearchClientFactory.configure((ElasticSearchClient)this.anotherClient, (ElasticSearchDataSetDef)this.definition);
        GsonBuilder builder = new GsonBuilder();
        DataColumnImpl col0 = new DataColumnImpl("department-count", ColumnType.NUMBER);
        DataColumnImpl col1 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        DataColumnImpl col2 = new DataColumnImpl("amount-max", ColumnType.NUMBER);
        DataColumnImpl col3 = new DataColumnImpl("amount-avg", ColumnType.NUMBER);
        DataColumnImpl col4 = new DataColumnImpl("amount-sum", ColumnType.NUMBER);
        DataColumnImpl col5 = new DataColumnImpl("amount-distinct", ColumnType.NUMBER);
        LinkedList<DataColumnImpl> columns = new LinkedList<DataColumnImpl>();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        columns.add(col3);
        columns.add(col4);
        columns.add(col5);
        AggregationSerializer aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns, c);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        Gson gson = builder.create();
        DataSetGroup aggregation = new DataSetGroup();
        aggregation.setDataSetUUID("testUUID");
        aggregation.setColumnGroup(null);
        aggregation.setJoin(false);
        GroupFunction countFunction = new GroupFunction("department", "department-count", AggregateFunctionType.COUNT);
        GroupFunction minFunction = new GroupFunction("amount", "amount-min", AggregateFunctionType.MIN);
        GroupFunction maxFunction = new GroupFunction("amount", "amount-max", AggregateFunctionType.MAX);
        GroupFunction avgFunction = new GroupFunction("amount", "amount-avg", AggregateFunctionType.AVERAGE);
        GroupFunction sumFunction = new GroupFunction("amount", "amount-sum", AggregateFunctionType.SUM);
        GroupFunction distinctFunction = new GroupFunction("amount", "amount-distinct", AggregateFunctionType.DISTINCT);
        aggregation.addGroupFunction(new GroupFunction[]{countFunction, minFunction, maxFunction, avgFunction, sumFunction, distinctFunction});
        String aggregationResult = gson.toJson((Object)aggregation, DataSetGroup.class);
        Assert.assertEquals((Object)aggregationResult, (Object)"{\"aggregations\":{\"department-count\":{\"value_count\":{\"field\":\"department\"}},\"amount-min\":{\"min\":{\"field\":\"amount\"}},\"amount-max\":{\"max\":{\"field\":\"amount\"}},\"amount-avg\":{\"avg\":{\"field\":\"amount\"}},\"amount-sum\":{\"sum\":{\"field\":\"amount\"}},\"amount-distinct\":{\"cardinality\":{\"field\":\"amount\"}}}}");
        builder = new GsonBuilder();
        col0 = new DataColumnImpl("departmentGrouped", ColumnType.NUMBER);
        col1 = new DataColumnImpl("amount-count", ColumnType.NUMBER);
        col2 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        columns = new LinkedList();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns, c);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        gson = builder.create();
        DataSetGroup groupByAggregation = new DataSetGroup();
        groupByAggregation.setDataSetUUID("testUUID");
        groupByAggregation.setJoin(false);
        groupByAggregation.setColumnGroup(new ColumnGroup("department", "departmentGrouped", GroupStrategy.DYNAMIC));
        GroupFunction groupByCountFunction = new GroupFunction("amount", "amount-count", AggregateFunctionType.COUNT);
        GroupFunction groupByMinFunction = new GroupFunction("amount", "amount-min", AggregateFunctionType.MIN);
        groupByAggregation.addGroupFunction(new GroupFunction[]{groupByCountFunction, groupByMinFunction});
        aggregationResult = gson.toJson((Object)groupByAggregation, DataSetGroup.class);
        Assert.assertEquals((Object)aggregationResult, (Object)"{\"aggregations\":{\"departmentGrouped\":{\"terms\":{\"field\":\"department\",\"order\":{\"_term\":\"asc\"},\"min_doc_count\":1,\"size\":0},\"aggregations\":{\"amount-count\":{\"value_count\":{\"field\":\"amount\"}},\"amount-min\":{\"min\":{\"field\":\"amount\"}}}}}}");
        builder = new GsonBuilder();
        col0 = new DataColumnImpl("amount", ColumnType.NUMBER);
        col1 = new DataColumnImpl("amount-max", ColumnType.NUMBER);
        col2 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        columns = new LinkedList();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns, c);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        gson = builder.create();
        DataSetGroup histogramAggreagation = new DataSetGroup();
        histogramAggreagation.setDataSetUUID("testUUID");
        histogramAggreagation.setColumnGroup(new ColumnGroup("amount", "amount", GroupStrategy.DYNAMIC, 99, "20"));
        histogramAggreagation.setJoin(false);
        groupByCountFunction = new GroupFunction("amount", "amount-max", AggregateFunctionType.MAX);
        groupByMinFunction = new GroupFunction("amount", "amount-min", AggregateFunctionType.MIN);
        histogramAggreagation.addGroupFunction(new GroupFunction[]{groupByCountFunction, groupByMinFunction});
        aggregationResult = gson.toJson((Object)histogramAggreagation, DataSetGroup.class);
        Assert.assertEquals((Object)aggregationResult, (Object)"{\"aggregations\":{\"amount\":{\"histogram\":{\"field\":\"amount\",\"interval\":20,\"order\":{\"_key\":\"asc\"},\"min_doc_count\":1},\"aggregations\":{\"amount-max\":{\"max\":{\"field\":\"amount\"}},\"amount-min\":{\"min\":{\"field\":\"amount\"}}}}}}");
        builder = new GsonBuilder();
        col0 = new DataColumnImpl("amount", ColumnType.NUMBER);
        col1 = new DataColumnImpl("amount-max", ColumnType.NUMBER);
        col2 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        columns = new LinkedList();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns, c);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        gson = builder.create();
        histogramAggreagation = new DataSetGroup();
        histogramAggreagation.setDataSetUUID("testUUID");
        ColumnGroup cg = new ColumnGroup("amount", "amount", GroupStrategy.DYNAMIC, 99, "20");
        cg.setEmptyIntervalsAllowed(true);
        histogramAggreagation.setColumnGroup(cg);
        histogramAggreagation.setJoin(false);
        groupByCountFunction = new GroupFunction("amount", "amount-max", AggregateFunctionType.MAX);
        groupByMinFunction = new GroupFunction("amount", "amount-min", AggregateFunctionType.MIN);
        histogramAggreagation.addGroupFunction(new GroupFunction[]{groupByCountFunction, groupByMinFunction});
        aggregationResult = gson.toJson((Object)histogramAggreagation, DataSetGroup.class);
        Assert.assertEquals((Object)aggregationResult, (Object)"{\"aggregations\":{\"amount\":{\"histogram\":{\"field\":\"amount\",\"interval\":20,\"order\":{\"_key\":\"asc\"},\"min_doc_count\":0},\"aggregations\":{\"amount-max\":{\"max\":{\"field\":\"amount\"}},\"amount-min\":{\"min\":{\"field\":\"amount\"}}}}}}");
    }

    @Test
    public void testAggregationDeserializer() {
        String aggregations1 = "{ \"departmentGrouped\": {\n        \"doc_count_error_upper_bound\": 0,\n        \"sum_other_doc_count\": 0,\n        \"buckets\": [\n            {\n                \"key\": \"Engineering\",\n                \"doc_count\": 19,\n                \"amount-count\": {\n                    \"value\": 19\n                },\n                \"amount-min\": {\n                    \"value\": 120.3499984741211\n                }\n            },\n            {\n                \"key\": \"Management\",\n                \"doc_count\": 11,\n                \"amount-count\": {\n                    \"value\": 11\n                },\n                \"amount-min\": {\n                    \"value\": 43.029998779296875\n                }\n            },\n            {\n                \"key\": \"Sales\",\n                \"doc_count\": 8,\n                \"amount-count\": {\n                    \"value\": 8\n                },\n                \"amount-min\": {\n                    \"value\": 75.75\n                }\n            },\n            {\n                \"key\": \"Services\",\n                \"doc_count\": 5,\n                \"amount-count\": {\n                    \"value\": 5\n                },\n                \"amount-min\": {\n                    \"value\": 152.25\n                }\n            },\n            {\n                \"key\": \"Support\",\n                \"doc_count\": 7,\n                \"amount-count\": {\n                    \"value\": 7\n                },\n                \"amount-min\": {\n                    \"value\": 300.010009765625\n                }\n            }\n        ]\n    }\n}";
        DataColumnImpl deptColumn = new DataColumnImpl("departmentGrouped", ColumnType.LABEL);
        DataColumnImpl amounutCountColumn = new DataColumnImpl("amount-count", ColumnType.NUMBER);
        DataColumnImpl amounutMinColumn = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        LinkedList<DataColumnImpl> columns = new LinkedList<DataColumnImpl>();
        columns.add(deptColumn);
        columns.add(amounutCountColumn);
        columns.add(amounutMinColumn);
        GsonBuilder builder = new GsonBuilder();
        AggregationsDeserializer aggregationsDeserializer = new AggregationsDeserializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(SearchHitResponse[].class, (Object)aggregationsDeserializer);
        Gson gson = builder.create();
        SearchHitResponse[] hits = (SearchHitResponse[])gson.fromJson(aggregations1, SearchHitResponse[].class);
        Assert.assertTrue((hits != null ? 1 : 0) != 0);
        Assert.assertTrue((hits.length == 5 ? 1 : 0) != 0);
        SearchHitResponse hit0 = hits[0];
        Assert.assertTrue((hit0 != null ? 1 : 0) != 0);
        LinkedHashMap hit0Fields = hit0.getFields();
        Assert.assertTrue((hit0Fields != null ? 1 : 0) != 0);
        Assert.assertTrue((hit0Fields.size() == 3 ? 1 : 0) != 0);
        String hit0AmountCount = hit0Fields.get("amount-count").toString();
        String hit0Dept = hit0Fields.get("departmentGrouped").toString();
        String hit0AmountMin = hit0Fields.get("amount-min").toString();
        Assert.assertEquals((Object)hit0AmountCount, (Object)"19.0");
        Assert.assertEquals((Object)hit0Dept, (Object)"Engineering");
        Assert.assertEquals((Object)hit0AmountMin, (Object)"120.3499984741211");
        SearchHitResponse hit1 = hits[1];
        Assert.assertTrue((hit1 != null ? 1 : 0) != 0);
        LinkedHashMap hit1Fields = hit1.getFields();
        Assert.assertTrue((hit1Fields != null ? 1 : 0) != 0);
        Assert.assertTrue((hit1Fields.size() == 3 ? 1 : 0) != 0);
        String hit1AmountCount = hit1Fields.get("amount-count").toString();
        String hit1Dept = hit1Fields.get("departmentGrouped").toString();
        String hit1AmountMin = hit1Fields.get("amount-min").toString();
        Assert.assertEquals((Object)hit1AmountCount, (Object)"11.0");
        Assert.assertEquals((Object)hit1Dept, (Object)"Management");
        Assert.assertEquals((Object)hit1AmountMin, (Object)"43.029998779296875");
        SearchHitResponse hit4 = hits[4];
        Assert.assertTrue((hit4 != null ? 1 : 0) != 0);
        LinkedHashMap hit4Fields = hit4.getFields();
        Assert.assertTrue((hit4Fields != null ? 1 : 0) != 0);
        Assert.assertTrue((hit4Fields.size() == 3 ? 1 : 0) != 0);
        String hit4AmountCount = hit4Fields.get("amount-count").toString();
        String hit4Dept = hit4Fields.get("departmentGrouped").toString();
        String hit4AmountMin = hit4Fields.get("amount-min").toString();
        Assert.assertEquals((Object)hit4AmountCount, (Object)"7.0");
        Assert.assertEquals((Object)hit4Dept, (Object)"Support");
        Assert.assertEquals((Object)hit4AmountMin, (Object)"300.010009765625");
    }
}

