/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.util;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchJSONParser;
import org.dashbuilder.test.ShrinkWrapHelper;
import org.fest.assertions.api.Assertions;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class ElasticSearchJSONParserTest {
    private static transient Logger log = LoggerFactory.getLogger((String)ElasticSearchJSONParserTest.class.getName());
    @Inject
    ElasticSearchJSONParser elasticSearchJSONParser;

    @Deployment
    public static Archive<?> createTestArchive() {
        return ShrinkWrapHelper.createJavaArchive().addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    public void testParseMappings() throws Exception {
        InputStream dataStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/dashbuilder/dataprovider/backend/elasticsearch/rest/client/util/fieldMappings.json");
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)dataStream, (Writer)writer, (String)"UTF-8");
        String json = writer.toString();
        Object[] mappings = this.elasticSearchJSONParser.parseFieldMappings(json);
        Assertions.assertThat((Object[])mappings).isNotEmpty();
        Assertions.assertThat((Object[])mappings).hasSize(2);
        Object prop1 = mappings[0];
        Assertions.assertThat((Object)prop1).isNotNull();
        Assertions.assertThat((String)prop1.getName()).isEqualTo((Object)"play_name");
        Assertions.assertThat((Object)prop1.getDataType()).isEqualTo((Object)FieldMappingResponse.FieldType.STRING);
        Assertions.assertThat((Object)prop1.getIndexType()).isEqualTo((Object)FieldMappingResponse.IndexType.NOT_ANALYZED);
        Object prop2 = mappings[1];
        Assertions.assertThat((Object)prop2).isNotNull();
        Assertions.assertThat((String)prop2.getName()).isEqualTo((Object)"speech_number");
        Assertions.assertThat((Object)prop2.getDataType()).isEqualTo((Object)FieldMappingResponse.FieldType.INTEGER);
        Assertions.assertThat((Object)prop2.getIndexType()).isEqualTo((Object)FieldMappingResponse.IndexType.ANALYZED);
    }
}

