/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.dashbuilder.dataprovider.DataSetProvider;
import org.dashbuilder.dataprovider.DataSetProviderType;
import org.dashbuilder.dataprovider.backend.StaticDataSetProvider;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchQueryBuilderFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.CountResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.EmptySearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.IndexMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.MappingsResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.TypeMappingResponse;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetLookupBuilder;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.def.DataColumnDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.events.DataSetDefModifiedEvent;
import org.dashbuilder.dataset.events.DataSetDefRemovedEvent;
import org.dashbuilder.dataset.events.DataSetStaleEvent;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.dashbuilder.dataset.impl.DataSetMetadataImpl;
import org.dashbuilder.dataset.impl.MemSizeEstimator;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.slf4j.Logger;

@ApplicationScoped
@Named(value="elasticsearch")
public class ElasticSearchDataSetProvider
implements DataSetProvider {
    public static final int RESPONSE_CODE_OK = 200;
    private static final String COMMA = ",";
    @Inject
    protected Logger log;
    @Inject
    protected StaticDataSetProvider staticDataSetProvider;
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;
    @Inject
    protected ElasticSearchClientFactory clientFactory;
    @Inject
    protected ElasticSearchValueTypeMapper typeMapper;
    @Inject
    protected ElasticSearchQueryBuilderFactory queryBuilderFactory;
    protected final Map<String, DataSetMetadata> _metadataMap = new HashMap<String, DataSetMetadata>();

    public DataSetProviderType getType() {
        return DataSetProviderType.ELASTICSEARCH;
    }

    public DataSet lookupDataSet(DataSetDef def, DataSetLookup lookup) throws Exception {
        ElasticSearchDataSetDef elDef = (ElasticSearchDataSetDef)def;
        if (elDef.isCacheEnabled()) {
            DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def.getUUID(), null);
            if (dataSet != null) {
                return this.staticDataSetProvider.lookupDataSet(def.getUUID(), lookup);
            }
            long rows = this.getRowCount(elDef);
            if (rows > (long)elDef.getCacheMaxRows().intValue()) {
                return this._lookupDataSet(elDef, lookup);
            }
            dataSet = this._lookupDataSet(elDef, null);
            dataSet.setUUID(def.getUUID());
            dataSet.setDefinition(def);
            this.staticDataSetProvider.registerDataSet(dataSet);
            return this.staticDataSetProvider.lookupDataSet(def.getUUID(), lookup);
        }
        return this._lookupDataSet(elDef, lookup);
    }

    protected DataSet _lookupDataSet(ElasticSearchDataSetDef elDef, DataSetLookup lookup) throws Exception {
        ArrayList<DataSetSort> sortOps;
        List groupOps;
        boolean trim;
        DataSetFilter dataSetFilter;
        boolean isTestMode = lookup != null && lookup.testMode();
        DataSetMetadata metadata = this.getDataSetMetadata((DataSetDef)elDef, isTestMode);
        List<DataColumn> ALL_COLUMNS = this.getAllColumns(metadata);
        if (lookup == null || lookup.getOperationList().isEmpty()) {
            DataSetLookupBuilder builder = (DataSetLookupBuilder)new DataSetLookupBuilderImpl().dataset(elDef.getUUID());
            if (ALL_COLUMNS != null) {
                for (DataColumn column : ALL_COLUMNS) {
                    builder.column(column.getId());
                }
            }
            lookup = builder.buildLookup();
            lookup.setTestMode(isTestMode);
        }
        if ((dataSetFilter = elDef.getDataSetFilter()) != null) {
            lookup.addOperation(new DataSetOp[]{dataSetFilter});
        }
        SearchRequest request = new SearchRequest(metadata);
        int numRows = lookup.getNumberOfRows();
        boolean bl = trim = numRows > 0;
        if (trim) {
            int rowOffset = lookup.getRowOffset();
            request.setStart(rowOffset);
            request.setSize(numRows);
        }
        if ((groupOps = lookup.getOperationList(DataSetGroup.class)) != null && !groupOps.isEmpty()) {
            LinkedList<DataSetGroup> aggregationOps = new LinkedList<DataSetGroup>();
            ArrayList<DataColumn> columns = new ArrayList<DataColumn>();
            for (DataSetGroup groupOp : groupOps) {
                boolean isAggregationOp = false;
                List groupFunctions = groupOp.getGroupFunctions();
                if (groupFunctions != null && !groupFunctions.isEmpty()) {
                    boolean existAnyFunction = false;
                    for (GroupFunction groupFunction : groupFunctions) {
                        String columnId = groupFunction.getSourceId() != null ? groupFunction.getSourceId() : metadata.getColumnId(0);
                        DataColumn column = this.getColumnById(metadata, columnId);
                        if (column != null) {
                            DataColumn c = column.cloneInstance();
                            String cId = groupFunction.getColumnId() != null ? groupFunction.getColumnId() : groupFunction.getSourceId();
                            c.setId(cId);
                            c.setGroupFunction(groupFunction);
                            if (groupFunction.getFunction() != null) {
                                existAnyFunction = true;
                                c.setColumnType(ColumnType.NUMBER);
                            }
                            columns.add(c);
                            if (!existAnyFunction) continue;
                            isAggregationOp = true;
                            continue;
                        }
                        throw new IllegalArgumentException("Grouping function by a non existing column [" + columnId + "] in dataset ");
                    }
                    request.setColumns(columns);
                }
                if (!isAggregationOp) continue;
                aggregationOps.add(groupOp);
            }
            if (!aggregationOps.isEmpty()) {
                request.setAggregations(aggregationOps);
            }
        } else {
            request.setColumns(ALL_COLUMNS);
        }
        List filters = lookup.getOperationList(DataSetFilter.class);
        if (filters != null && !filters.isEmpty()) {
            for (DataSetFilter filerOp : filters) {
                List columnFilters = filerOp.getColumnFilterList();
                if (columnFilters == null || columnFilters.isEmpty()) continue;
                for (ColumnFilter filter : columnFilters) {
                    if (this.existColumn(metadata, filter.getColumnId())) continue;
                    throw new IllegalArgumentException("Filtering by a non existing column [" + filter.getColumnId() + "] in dataset ");
                }
            }
            Query query = this.queryBuilderFactory.newQueryBuilder().metadata(metadata).groupInterval(groupOps).filter(filters).build();
            request.setQuery(query);
        }
        if (((sortOps = lookup.getOperationList(DataSetSort.class)) == null || sortOps.isEmpty()) && elDef.getColumnSort() != null) {
            if (sortOps == null) {
                sortOps = new ArrayList<DataSetSort>();
            }
            DataSetSort defaultSort = new DataSetSort();
            defaultSort.addSortColumn(new ColumnSort[]{elDef.getColumnSort()});
            sortOps.add(defaultSort);
        } else if (sortOps != null) {
            for (DataSetSort sortOp : sortOps) {
                List sorts = sortOp.getColumnSortList();
                if (sorts == null || sorts.isEmpty()) continue;
                for (ColumnSort sort : sorts) {
                    if (this.existColumn(metadata, sort.getColumnId())) continue;
                    throw new IllegalArgumentException("Sorting by a non existing column [" + sort.getColumnId() + "] in dataset ");
                }
            }
        }
        request.setSorting((List<DataSetSort>)sortOps);
        DataSet dataSet = DataSetFactory.newEmptyDataSet();
        dataSet.setColumns(request.getColumns());
        SearchResponse searchResponse = this.clientFactory.newClient(elDef).search((DataSetDef)elDef, metadata, request);
        if (searchResponse instanceof EmptySearchResponse) {
            return dataSet;
        }
        this.fillDataSetValues(elDef, dataSet, searchResponse.getHits());
        if (trim) {
            dataSet.setRowCountNonTrimmed((int)searchResponse.getTotalHits());
        }
        return dataSet;
    }

    protected List<DataColumn> getAllColumns(DataSetMetadata metadata) {
        int numberOfColumns = metadata.getNumberOfColumns();
        ArrayList<DataColumn> columns = new ArrayList<DataColumn>(numberOfColumns);
        for (int x = 0; x < numberOfColumns; ++x) {
            DataColumn column = this.getColumnById(metadata, metadata.getColumnId(x));
            columns.add(column);
        }
        return columns;
    }

    protected DataColumn getColumnById(DataSetMetadata metadata, String columnId) {
        if (metadata == null || columnId == null || columnId.trim().length() == 0) {
            return null;
        }
        int numCols = metadata.getNumberOfColumns();
        for (int x = 0; x < numCols; ++x) {
            String metaColumnId = metadata.getColumnId(x);
            if (!columnId.equals(metaColumnId)) continue;
            DataColumnImpl column = new DataColumnImpl(metadata.getColumnId(x), metadata.getColumnType(x));
            return column;
        }
        return null;
    }

    protected boolean existColumn(DataSetMetadata metadata, String columnId) {
        return this.getColumnById(metadata, columnId) != null;
    }

    protected void fillDataSetValues(ElasticSearchDataSetDef elDef, DataSet dataSet, SearchHitResponse[] hits) throws Exception {
        List dataSetColumns = dataSet.getColumns();
        int position = 0;
        for (SearchHitResponse hit : hits) {
            int columnNumber = 0;
            for (DataColumn column : dataSetColumns) {
                String columnId = column.getId();
                Object value = hit.getFieldValue(columnId);
                dataSet.setValueAt(position, columnNumber, value);
                ++columnNumber;
            }
            ++position;
        }
    }

    public boolean isDataSetOutdated(DataSetDef def) {
        try {
            ElasticSearchDataSetDef elDef = (ElasticSearchDataSetDef)def;
            if (!elDef.isCacheEnabled()) {
                return false;
            }
            DataSet dataSet = this.staticDataSetProvider.lookupDataSet(def, null);
            if (dataSet == null) {
                return false;
            }
            long rows = this.getRowCount(elDef);
            return rows != (long)dataSet.getRowCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public DataSetMetadata getDataSetMetadata(DataSetDef def) throws Exception {
        return this.getDataSetMetadata(def, true);
    }

    private DataSetMetadata getDataSetMetadata(DataSetDef def, boolean isTestMode) throws Exception {
        String columnId;
        ElasticSearchDataSetDef elasticSearchDataSetDef = (ElasticSearchDataSetDef)def;
        if (!isTestMode) {
            DataSetMetadata result = this._metadataMap.get(elasticSearchDataSetDef.getUUID());
            if (result != null) {
                return result;
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Using look-up in test mode. Skipping read data set metadata for uuid [" + def.getUUID() + "] from cache.");
        }
        String[] index = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getIndex());
        String[] type = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getType());
        long rowCount = this.getRowCount(elasticSearchDataSetDef);
        MappingsResponse mappingsResponse = this.clientFactory.newClient(elasticSearchDataSetDef).getMappings(index);
        if (mappingsResponse == null || mappingsResponse.getStatus() != 200) {
            throw new IllegalArgumentException("Cannot retrieve index mappings for index: [" + index[0] + "]. See previous errors.");
        }
        LinkedList<String> columnIds = new LinkedList<String>();
        LinkedList<ColumnType> columnTypes = new LinkedList<ColumnType>();
        Map<String, DataColumn> indexMappingsColumnsMap = this.parseColumnsFromIndexMappings(mappingsResponse.getIndexMappings(), elasticSearchDataSetDef);
        if (indexMappingsColumnsMap == null || indexMappingsColumnsMap.isEmpty()) {
            throw new RuntimeException("There are no column for index [" + index[0] + "] and type [" + ArrayUtils.toString((Object)type) + "].");
        }
        Collection<DataColumn> indexMappingsColumns = indexMappingsColumnsMap.values();
        boolean isAllColumns = elasticSearchDataSetDef.isAllColumnsEnabled();
        List dataSetColumns = elasticSearchDataSetDef.getColumns();
        if (dataSetColumns != null && !dataSetColumns.isEmpty()) {
            for (DataColumnDef column : dataSetColumns) {
                columnId = column.getId();
                DataColumn indexCol = indexMappingsColumnsMap.get(columnId);
                if (indexCol == null) {
                    this.log.warn("The column [" + columnId + "] for the data set definition with UUID [" + def.getUUID() + "] is no longer present in the mappings.");
                    continue;
                }
                ColumnType columnType = column.getColumnType();
                ColumnType indexColumnType = indexCol.getColumnType();
                if (indexColumnType.equals((Object)ColumnType.TEXT) && columnType.equals((Object)ColumnType.LABEL)) {
                    throw new RuntimeException("The column [" + columnId + "] is defined in dataset definition as LABEL, but the column in the index [" + index[0] + "] and type [" + ArrayUtils.toString((Object)type) + "] is using ANALYZED index, you cannot use it as a label.");
                }
                columnIds.add(columnId);
                columnTypes.add(columnType);
            }
        }
        if (def.isAllColumnsEnabled()) {
            for (DataColumn indexMappingsColumn : indexMappingsColumns) {
                columnId = indexMappingsColumn.getId();
                int columnIdx = columnIds.indexOf(columnId);
                boolean columnExists = columnIdx != -1;
                if (columnExists) continue;
                columnIds.add(columnId);
                columnTypes.add(indexMappingsColumn.getColumnType());
            }
        }
        if (columnIds.isEmpty()) {
            throw new RuntimeException("Cannot obtain data set metadata columns for data set with UUID [" + def.getUUID() + "]. All columns flag is not set and there are no column definitions in the data set definition.");
        }
        int _rowCount = (int)rowCount;
        int estimatedSize = this.estimateSize(columnTypes, _rowCount);
        DataSetMetadataImpl result = new DataSetMetadataImpl(def, def.getUUID(), _rowCount, columnIds.size(), columnIds, columnTypes, estimatedSize);
        if (!isTestMode) {
            boolean isDefRegistered;
            boolean bl = isDefRegistered = def.getUUID() != null && this.dataSetDefRegistry.getDataSetDef(def.getUUID()) != null;
            if (isDefRegistered) {
                this._metadataMap.put(def.getUUID(), (DataSetMetadata)result);
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Using look-up in test mode. Skipping adding data set metadata for uuid [" + def.getUUID() + "] into cache.");
        }
        return result;
    }

    private int estimateSize(List<ColumnType> columnTypes, int rowCount) {
        int estimatedSize = 0;
        if (columnTypes != null && !columnTypes.isEmpty()) {
            for (ColumnType type : columnTypes) {
                if (ColumnType.DATE.equals((Object)type)) {
                    estimatedSize += MemSizeEstimator.sizeOf(Date.class) * rowCount;
                    continue;
                }
                if (ColumnType.NUMBER.equals((Object)type)) {
                    estimatedSize += MemSizeEstimator.sizeOf(Double.class) * rowCount;
                    continue;
                }
                estimatedSize += 30 * rowCount;
            }
        }
        return estimatedSize;
    }

    protected Map<String, DataColumn> parseColumnsFromIndexMappings(IndexMappingResponse[] indexMappings, ElasticSearchDataSetDef def) {
        HashMap<String, DataColumnImpl> result = null;
        for (IndexMappingResponse indexMapping : indexMappings) {
            result = new HashMap<String, DataColumnImpl>();
            String indexName = indexMapping.getIndexName();
            TypeMappingResponse[] typeMappings = indexMapping.getTypeMappings();
            if (typeMappings == null || typeMappings.length == 0) {
                throw new IllegalArgumentException("There are no types for index: [" + indexName + "[");
            }
            for (TypeMappingResponse typeMapping : typeMappings) {
                String typeName = typeMapping.getTypeName();
                FieldMappingResponse[] properties = typeMapping.getFields();
                if (properties == null || properties.length == 0) {
                    throw new IllegalArgumentException("There are no fields for index: [" + indexName + "] and type [" + typeName + "[");
                }
                for (FieldMappingResponse fieldMapping : properties) {
                    String fieldName = fieldMapping.getName();
                    String format = fieldMapping.getFormat();
                    String columnId = this.getColumnId(indexName, typeName, fieldName);
                    ColumnType columnType = this.getDataType(fieldMapping);
                    if (columnType != null) {
                        boolean isLabelColumn = ColumnType.LABEL.equals((Object)columnType);
                        boolean isTextColumn = ColumnType.TEXT.equals((Object)columnType);
                        boolean isDateColumn = ColumnType.DATE.equals((Object)columnType);
                        boolean isNumberColumn = ColumnType.NUMBER.equals((Object)columnType);
                        String pattern = def.getPattern(columnId);
                        if (!this.isEmpty(pattern)) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Using pattern [" + pattern + "] given in the data set definition with uuid [" + def.getUUID() + "] for column [" + columnId + "].");
                            }
                        } else if (isLabelColumn || isTextColumn) {
                            FieldMappingResponse.IndexType indexType = fieldMapping.getIndexType();
                            if (indexType == null) {
                                indexType = FieldMappingResponse.IndexType.ANALYZED;
                            }
                            def.setPattern(columnId, indexType.name().toLowerCase());
                        } else if (isNumberColumn) {
                            FieldMappingResponse.FieldType fieldType = fieldMapping.getDataType();
                            def.setPattern(columnId, fieldType.name().toLowerCase());
                        } else if (!this.isEmpty(format)) {
                            def.setPattern(columnId, format);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Using pattern [" + format + "] given by the index mappings response for column [" + columnId + "].");
                            }
                        } else {
                            String defaultPattern = this.typeMapper.defaultDateFormat();
                            def.setPattern(columnId, defaultPattern);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Using default pattern [" + defaultPattern + "] for column [" + columnId + "].");
                            }
                        }
                        DataColumnImpl column = new DataColumnImpl(columnId, columnType);
                        result.put(columnId, column);
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("[" + indexName + "]/[" + typeName + "] - Skipping column retrieved from index mappings response with id [" + columnId + "], as data type for this column is not supported.");
                }
            }
        }
        return result;
    }

    protected String getColumnId(String index, String type, String field) throws IllegalArgumentException {
        if (index == null || index.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot create the column identifier. Index name is not set.");
        }
        if (type == null || type.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot create the column identifier. Document type name is not set.");
        }
        if (field == null || field.trim().length() == 0) {
            throw new IllegalArgumentException("Cannot create the column identifier. Field name is not set.");
        }
        return field;
    }

    protected ColumnType getDataType(FieldMappingResponse fieldMapping) throws IllegalArgumentException {
        FieldMappingResponse.FieldType fieldType = fieldMapping.getDataType();
        if (fieldType == null) {
            return null;
        }
        switch (fieldType) {
            case STRING: {
                if (fieldMapping.getIndexType() != null && fieldMapping.getIndexType().equals((Object)FieldMappingResponse.IndexType.NOT_ANALYZED)) {
                    return ColumnType.LABEL;
                }
                return ColumnType.TEXT;
            }
            case FLOAT: {
                return ColumnType.NUMBER;
            }
            case DOUBLE: {
                return ColumnType.NUMBER;
            }
            case BYTE: {
                return ColumnType.NUMBER;
            }
            case SHORT: {
                return ColumnType.NUMBER;
            }
            case INTEGER: {
                return ColumnType.NUMBER;
            }
            case LONG: {
                return ColumnType.NUMBER;
            }
            case TOKEN_COUNT: {
                return ColumnType.LABEL;
            }
            case DATE: {
                return ColumnType.DATE;
            }
            case BOOLEAN: {
                return ColumnType.LABEL;
            }
            case BINARY: {
                return ColumnType.LABEL;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("The ElasticSearch core data type [" + fieldType.toString() + "] is not suppored.");
        }
        return null;
    }

    protected long getRowCount(ElasticSearchDataSetDef elasticSearchDataSetDef) throws Exception {
        String[] index = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getIndex());
        String[] type = ElasticSearchDataSetProvider.fromString(elasticSearchDataSetDef.getType());
        CountResponse response = this.clientFactory.newClient(elasticSearchDataSetDef).count(index, type);
        if (response != null) {
            return response.getCount();
        }
        return 0L;
    }

    private void onDataSetStaleEvent(@Observes DataSetStaleEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    private void onDataSetDefRemovedEvent(@Observes DataSetDefRemovedEvent event) {
        DataSetDef def = event.getDataSetDef();
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    private void onDataSetDefModifiedEvent(@Observes DataSetDefModifiedEvent event) {
        DataSetDef def = event.getOldDataSetDef();
        if (DataSetProviderType.ELASTICSEARCH.equals((Object)def.getProvider())) {
            this.remove(def.getUUID());
        }
    }

    private void remove(String uuid) {
        this._metadataMap.remove(uuid);
        this.staticDataSetProvider.removeDataSet(uuid);
    }

    public static String[] fromString(String str) {
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{""};
        }
        return str.split(COMMA);
    }

    public static String toString(String[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int total = array.length;
        for (int x = 0; x < total; ++x) {
            String s = array[x];
            builder.append(s);
            if (x >= total - 1) continue;
            builder.append(COMMA);
        }
        return builder.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

