/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.exception.ElasticSearchClientGenericException;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AbstractAdapter;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.backend.BackendIntervalBuilderDynamicDate;
import org.dashbuilder.dataset.date.DayOfWeek;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;

public class AggregationSerializer
extends AbstractAdapter<AggregationSerializer>
implements JsonSerializer<DataSetGroup> {
    protected static final String AGG_ORDER_ASC = "asc";
    protected static final String AGG_ORDER_DESC = "desc";
    protected static final String AGG_FIELD = "field";
    protected static final String AGG_SCRIPT = "script";
    protected static final String AGG_SIZE = "size";
    protected static final String AGG_TERM = "_term";
    protected static final String AGG_ORDER = "order";
    protected static final String AGG_MIN_DOC_COUNT = "min_doc_count";
    protected static final String AGG_TERMS = "terms";
    protected static final String AGG_AGGREGATIONS = "aggregations";
    protected static final String AGG_INTERVAL = "interval";
    protected static final String AGG_KEY = "_key";
    protected static final String AGG_HISTORGRAM = "histogram";
    protected static final String AGG_FORMAT = "format";
    protected static final String AGG_DATE_HISTORGRAM = "date_histogram";
    protected BackendIntervalBuilderDynamicDate intervalBuilder;
    protected ElasticSearchClient anotherClient;

    public AggregationSerializer(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns, ElasticSearchJestClient anotherClient) {
        super(client, metadata, columns);
        this.anotherClient = anotherClient;
        this.intervalBuilder = new BackendIntervalBuilderDynamicDate();
    }

    public AggregationSerializer(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns, SearchRequest request, ElasticSearchJestClient anotherClient) {
        super(client, metadata, columns, request);
        this.anotherClient = anotherClient;
        this.intervalBuilder = new BackendIntervalBuilderDynamicDate();
    }

    public JsonObject serialize(DataSetGroup groupOp, Type typeOfSrc, JsonSerializationContext context) {
        ColumnGroup columnGroup = groupOp.getColumnGroup();
        List groupFunctions = groupOp.getGroupFunctions();
        LinkedList<GroupFunction> columnPickUps = new LinkedList<GroupFunction>();
        JsonObject aggregationsObject = null;
        if (groupFunctions != null && !groupFunctions.isEmpty()) {
            aggregationsObject = new JsonObject();
            for (GroupFunction groupFunction : groupFunctions) {
                if (groupFunction.getFunction() != null) {
                    this.serializeCoreFunction(aggregationsObject, groupFunction);
                    continue;
                }
                columnPickUps.add(groupFunction);
            }
        }
        JsonObject groupByObject = null;
        if (columnGroup != null) {
            groupByObject = new JsonObject();
            String columnId = columnGroup.getColumnId();
            String sourceId = columnGroup.getSourceId();
            if (!columnPickUps.isEmpty()) {
                for (GroupFunction groupFunction : columnPickUps) {
                    if (groupFunction.getFunction() != null) continue;
                    columnId = groupFunction.getColumnId();
                    if (!sourceId.equals(groupFunction.getSourceId())) {
                        throw new RuntimeException("Grouping by this source property [" + sourceId + "] not possible.");
                    }
                    if (this.existColumnInMetadataDef(sourceId)) continue;
                    throw new RuntimeException("Aggregation by column [" + sourceId + "] failed. No column with the given id.");
                }
            }
            this.serializeGroupByFunction(groupByObject, columnGroup, columnId, aggregationsObject);
        } else if (!columnPickUps.isEmpty()) {
            throw new RuntimeException("Column [" + ((GroupFunction)columnPickUps.get(0)).getSourceId() + "] pickup  failed. No grouping is set for this column.");
        }
        return groupByObject != null ? this.buildAggregations(groupByObject) : this.buildAggregations(aggregationsObject);
    }

    protected JsonObject buildAggregations(JsonObject object) {
        JsonObject result = new JsonObject();
        result.add(AGG_AGGREGATIONS, (JsonElement)object);
        return result;
    }

    protected void serializeGroupByFunction(JsonObject parent, ColumnGroup columnGroup, String resultingColumnId, JsonObject aggregationsObject) {
        boolean asc;
        if (columnGroup == null || this.metadata == null) {
            return;
        }
        String sourceId = columnGroup.getSourceId();
        if (resultingColumnId == null) {
            resultingColumnId = sourceId;
        }
        String order = (asc = columnGroup.isAscendingOrder()) ? AGG_ORDER_ASC : AGG_ORDER_DESC;
        ColumnType columnType = this.metadata.getColumnType(sourceId);
        GroupStrategy groupStrategy = columnGroup.getStrategy();
        String intervalSize = columnGroup.getIntervalSize();
        boolean areEmptyIntervalsAllowed = columnGroup.areEmptyIntervalsAllowed();
        int minDocCount = areEmptyIntervalsAllowed ? 0 : 1;
        int maxIntervals = columnGroup.getMaxIntervals();
        if (ColumnType.LABEL.equals((Object)columnType)) {
            JsonObject subObject = new JsonObject();
            subObject.addProperty(AGG_FIELD, sourceId);
            JsonObject orderObject = new JsonObject();
            orderObject.addProperty(AGG_TERM, order);
            subObject.add(AGG_ORDER, (JsonElement)orderObject);
            subObject.addProperty(AGG_MIN_DOC_COUNT, (Number)minDocCount);
            subObject.addProperty(AGG_SIZE, (Number)0);
            JsonObject result = new JsonObject();
            result.add(AGG_TERMS, (JsonElement)subObject);
            if (aggregationsObject != null) {
                result.add(AGG_AGGREGATIONS, (JsonElement)aggregationsObject);
            }
            parent.add(resultingColumnId, (JsonElement)result);
            if (this.columns != null) {
                DataColumn column = this.getColumn(resultingColumnId);
                column.setColumnGroup(new ColumnGroup(sourceId, resultingColumnId, columnGroup.getStrategy(), columnGroup.getMaxIntervals(), columnGroup.getIntervalSize()));
            }
        } else if (ColumnType.NUMBER.equals((Object)columnType)) {
            JsonObject subObject = new JsonObject();
            subObject.addProperty(AGG_FIELD, sourceId);
            if (intervalSize != null) {
                subObject.addProperty(AGG_INTERVAL, (Number)Long.parseLong(intervalSize));
            }
            JsonObject orderObject = new JsonObject();
            orderObject.addProperty(AGG_KEY, order);
            subObject.add(AGG_ORDER, (JsonElement)orderObject);
            subObject.addProperty(AGG_MIN_DOC_COUNT, (Number)minDocCount);
            JsonObject result = new JsonObject();
            result.add(AGG_HISTORGRAM, (JsonElement)subObject);
            if (aggregationsObject != null) {
                result.add(AGG_AGGREGATIONS, (JsonElement)aggregationsObject);
            }
            parent.add(resultingColumnId, (JsonElement)result);
            if (this.columns != null) {
                DataColumn column = this.getColumn(resultingColumnId);
                column.setColumnGroup(new ColumnGroup(sourceId, resultingColumnId, columnGroup.getStrategy(), columnGroup.getMaxIntervals(), columnGroup.getIntervalSize()));
            }
        } else if (ColumnType.DATE.equals((Object)columnType)) {
            DateIntervalType dateIntervalType = null;
            if (GroupStrategy.FIXED.equals((Object)columnGroup.getStrategy())) {
                if (intervalSize != null) {
                    dateIntervalType = DateIntervalType.valueOf((String)intervalSize);
                }
                if (dateIntervalType == null) {
                    throw new RuntimeException("Column [" + columnGroup.getColumnId() + "] is type Date and grouped using a fixed strategy, but the ate interval type is not specified. Please specify it.");
                }
                JsonObject subObject = new JsonObject();
                String[] scripts = this.buildIntervalExtractorScript(sourceId, columnGroup);
                String valueScript = scripts[0];
                String orderScript = scripts[1];
                subObject.addProperty(AGG_SCRIPT, valueScript);
                JsonObject orderObject = new JsonObject();
                if (orderScript == null) {
                    orderObject.addProperty(AGG_TERM, order);
                } else {
                    orderObject.addProperty("_sortOrder", AGG_ORDER_ASC);
                }
                subObject.add(AGG_ORDER, (JsonElement)orderObject);
                subObject.addProperty(AGG_SIZE, (Number)0);
                subObject.addProperty(AGG_MIN_DOC_COUNT, (Number)minDocCount);
                JsonObject result = new JsonObject();
                result.add(AGG_TERMS, (JsonElement)subObject);
                if (orderScript != null) {
                    JsonObject scriptOrderObject = new JsonObject();
                    scriptOrderObject.addProperty(AGG_SCRIPT, orderScript);
                    JsonObject minOrderObject = new JsonObject();
                    minOrderObject.add("min", (JsonElement)scriptOrderObject);
                    if (aggregationsObject == null) {
                        aggregationsObject = new JsonObject();
                    }
                    aggregationsObject.add("_sortOrder", (JsonElement)minOrderObject);
                }
                if (aggregationsObject != null) {
                    result.add(AGG_AGGREGATIONS, (JsonElement)aggregationsObject);
                }
                parent.add(resultingColumnId, (JsonElement)result);
            }
            if (GroupStrategy.DYNAMIC.equals((Object)columnGroup.getStrategy())) {
                if (intervalSize != null) {
                    dateIntervalType = DateIntervalType.valueOf((String)intervalSize);
                } else {
                    try {
                        Date[] limits = this.client.getUtils().calculateDateLimits(this.anotherClient, this.metadata, columnGroup.getSourceId(), this.request != null ? this.request.getQuery() : null);
                        if (limits != null) {
                            dateIntervalType = this.intervalBuilder.calculateIntervalSize(limits[0], limits[1], columnGroup);
                        }
                    }
                    catch (ElasticSearchClientGenericException e) {
                        throw new RuntimeException("Cannot calculate date limits.", e);
                    }
                }
                if (dateIntervalType == null) {
                    throw new RuntimeException("Column [" + columnGroup.getColumnId() + "] is type Date and grouped using a dynamic strategy, but the date interval types cannot be calculated from index documents' data and it is not specified. Please specify it.");
                }
                String interval = ElasticSearchJestClient.getInterval(dateIntervalType);
                String returnFormat = "yyyy-MM-dd";
                switch (dateIntervalType) {
                    case MILLISECOND: {
                        break;
                    }
                    case HUNDRETH: {
                        break;
                    }
                    case TENTH: {
                        break;
                    }
                    case SECOND: {
                        returnFormat = "yyyy-MM-dd HH:mm:ss";
                        break;
                    }
                    case MINUTE: {
                        returnFormat = "yyyy-MM-dd HH:mm";
                        break;
                    }
                    case HOUR: {
                        returnFormat = "yyyy-MM-dd HH";
                        break;
                    }
                    case DAY: {
                        returnFormat = "yyyy-MM-dd";
                        break;
                    }
                    case DAY_OF_WEEK: {
                        returnFormat = "yyyy-MM-dd";
                        break;
                    }
                    case WEEK: {
                        break;
                    }
                    case MONTH: {
                        returnFormat = "yyyy-MM";
                        break;
                    }
                    case QUARTER: {
                        break;
                    }
                    case YEAR: {
                        returnFormat = "yyyy";
                        break;
                    }
                    case DECADE: {
                        break;
                    }
                    case CENTURY: {
                        break;
                    }
                    case MILLENIUM: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("No interval mapping for date interval type [" + dateIntervalType.name() + "].");
                    }
                }
                JsonObject subObject = new JsonObject();
                subObject.addProperty(AGG_FIELD, sourceId);
                subObject.addProperty(AGG_INTERVAL, interval);
                subObject.addProperty(AGG_FORMAT, returnFormat);
                JsonObject orderObject = new JsonObject();
                orderObject.addProperty(AGG_KEY, order);
                subObject.add(AGG_ORDER, (JsonElement)orderObject);
                subObject.addProperty(AGG_MIN_DOC_COUNT, (Number)minDocCount);
                JsonObject result = new JsonObject();
                result.add(AGG_DATE_HISTORGRAM, (JsonElement)subObject);
                if (aggregationsObject != null) {
                    result.add(AGG_AGGREGATIONS, (JsonElement)aggregationsObject);
                }
                parent.add(resultingColumnId, (JsonElement)result);
            }
            if (this.columns != null) {
                DataColumn column = this.getColumn(resultingColumnId);
                column.setColumnType(ColumnType.LABEL);
                column.setIntervalType(dateIntervalType.name());
                column.setColumnGroup(new ColumnGroup(sourceId, resultingColumnId, columnGroup.getStrategy(), columnGroup.getMaxIntervals(), columnGroup.getIntervalSize()));
            }
        } else {
            throw new RuntimeException("No translation supported for column group with sourceId [" + sourceId + "] and group strategy [" + groupStrategy.name() + "].");
        }
    }

    private String[] buildIntervalExtractorScript(String sourceId, ColumnGroup columnGroup) {
        int[] positions;
        DateIntervalType intervalType = DateIntervalType.getByName((String)columnGroup.getIntervalSize());
        Month firstMonth = columnGroup.getFirstMonthOfYear();
        DayOfWeek firstDayOfWeek = columnGroup.getFirstDayOfWeek();
        String script = "new Date(doc[\"{0}\"].value).toCalendar().";
        switch (intervalType) {
            case QUARTER: {
                script = "ceil( ( " + script + "get(Calendar.MONTH) + 1 ) / 3 ).toInteger()";
                break;
            }
            case MONTH: {
                script = script + "get(Calendar.MONTH) + 1";
                break;
            }
            case DAY_OF_WEEK: {
                script = script + "get(Calendar.DAY_OF_WEEK)";
                break;
            }
            case HOUR: {
                script = script + "get(Calendar.HOUR_OF_DAY)";
                break;
            }
            case MINUTE: {
                script = script + "get(Calendar.MINUTE)";
                break;
            }
            case SECOND: {
                script = script + "get(Calendar.SECOND)";
                break;
            }
            default: {
                throw new UnsupportedOperationException("Fixed grouping strategy by interval type " + intervalType.name() + " is not supported.");
            }
        }
        String valueScript = MessageFormat.format(script, sourceId);
        String orderScript = null;
        if (firstMonth != null && intervalType.equals((Object)DateIntervalType.MONTH)) {
            int firstMonthIndex = firstMonth.getIndex();
            positions = this.buildPositionsArray(firstMonthIndex, 12, columnGroup.isAscendingOrder());
            orderScript = "month=" + valueScript + ".toInteger(); list = " + Arrays.toString(positions) + "; list.indexOf(month)";
        }
        if (firstDayOfWeek != null && intervalType.equals((Object)DateIntervalType.DAY_OF_WEEK)) {
            int firstDayIndex = firstDayOfWeek.getIndex();
            positions = this.buildPositionsArray(firstDayIndex, 7, columnGroup.isAscendingOrder());
            orderScript = "day=" + valueScript + ".toInteger(); list = " + Arrays.toString(positions) + "; list.indexOf(day)";
        }
        return new String[]{valueScript, orderScript};
    }

    private int[] buildPositionsArray(int firstElementIndex, int end, boolean asc) {
        int[] positions = new int[end];
        int month = firstElementIndex;
        for (int x = 0; x < end; ++x) {
            if (month > end) {
                month = 1;
            }
            if (month < 1) {
                month = end;
            }
            positions[x] = month++;
            if (asc) continue;
            --month;
        }
        return positions;
    }

    protected void serializeCoreFunction(JsonObject parent, GroupFunction groupFunction) {
        if (parent != null && groupFunction != null) {
            String sourceId = groupFunction.getSourceId();
            if (sourceId != null && !this.existColumnInMetadataDef(sourceId)) {
                throw new RuntimeException("Aggregation by column [" + sourceId + "] failed. No column with the given id.");
            }
            if (sourceId == null) {
                sourceId = this.metadata.getColumnId(0);
            }
            if (sourceId == null) {
                throw new IllegalArgumentException("Aggregation from unknown column id.");
            }
            String columnId = groupFunction.getColumnId();
            if (columnId == null) {
                columnId = sourceId;
            }
            AggregateFunctionType type = groupFunction.getFunction();
            String aggregationName = null;
            ColumnType sourceColumnType = this.metadata.getColumnType(sourceId);
            ColumnType resultingColumnType = sourceColumnType.equals((Object)ColumnType.DATE) ? ColumnType.DATE : ColumnType.NUMBER;
            switch (type) {
                case COUNT: {
                    aggregationName = "value_count";
                    break;
                }
                case DISTINCT: {
                    aggregationName = "cardinality";
                    break;
                }
                case AVERAGE: {
                    aggregationName = "avg";
                    break;
                }
                case SUM: {
                    aggregationName = "sum";
                    break;
                }
                case MIN: {
                    aggregationName = "min";
                    break;
                }
                case MAX: {
                    aggregationName = "max";
                }
            }
            JsonObject fieldObject = new JsonObject();
            fieldObject.addProperty(AGG_FIELD, sourceId);
            JsonObject subObject = new JsonObject();
            subObject.add(aggregationName, (JsonElement)fieldObject);
            parent.add(columnId, (JsonElement)subObject);
        }
    }

    protected boolean existColumnInMetadataDef(String name) {
        if (name == null || this.metadata == null) {
            return false;
        }
        int cols = this.metadata.getNumberOfColumns();
        for (int x = 0; x < cols; ++x) {
            String colName = this.metadata.getColumnId(x);
            if (!name.equals(colName)) continue;
            return true;
        }
        return false;
    }
}

