/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AbstractAdapter;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;

public class SearchQuerySerializer
extends AbstractAdapter<SearchQuerySerializer>
implements JsonSerializer<ElasticSearchJestClient.SearchQuery> {
    protected static final String FIELDS = "fields";
    protected static final String FROM = "from";
    protected static final String QUERY = "query";
    protected static final String SIZE = "size";
    protected static final String AGGREGATIONS = "aggregations";

    public SearchQuerySerializer(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns) {
        super(client, metadata, columns);
    }

    public JsonObject serialize(ElasticSearchJestClient.SearchQuery searchQuery, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject queryObject;
        JsonObject result = new JsonObject();
        String[] fields = searchQuery.getFields();
        JsonObject query = searchQuery.getQuery();
        List<JsonObject> aggregations = searchQuery.getAggregations();
        boolean existAggregations = aggregations != null && !aggregations.isEmpty();
        int start = searchQuery.getStart();
        int size = searchQuery.getSize();
        int sizeToPull = existAggregations ? 0 : size;
        int startToPull = existAggregations ? 0 : start;
        result.addProperty(FROM, (Number)startToPull);
        if (sizeToPull > -1) {
            result.addProperty(SIZE, (Number)sizeToPull);
        }
        if (query != null) {
            queryObject = query.getAsJsonObject(QUERY);
            result.add(QUERY, (JsonElement)queryObject);
        }
        if (existAggregations) {
            JsonObject aggregationObject = aggregations.get(0);
            JsonObject aggregationsSubObject = aggregationObject.getAsJsonObject(AGGREGATIONS);
            result.add(AGGREGATIONS, (JsonElement)aggregationsSubObject);
        }
        if (query == null && !existAggregations) {
            queryObject = new JsonObject();
            queryObject.add("match_all", (JsonElement)new JsonObject());
            result.add(QUERY, (JsonElement)queryObject);
        }
        if (!existAggregations) {
            JsonArray fieldsArray = new JsonArray();
            for (String field : fields) {
                fieldsArray.add((JsonElement)new JsonPrimitive(field));
            }
            result.add(FIELDS, (JsonElement)fieldsArray);
        }
        return result;
    }
}

