/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Query {
    private Type type;
    private String field;
    private Map<String, Object> params;

    public Query(Type type) {
        this.type = type;
        this.params = new HashMap<String, Object>();
    }

    public Query(String field, Type type) {
        this.type = type;
        this.field = field;
        this.params = new HashMap<String, Object>();
    }

    public Type getType() {
        return this.type;
    }

    public String getField() {
        return this.field;
    }

    public Query setParam(String key, Object value) {
        this.params.put(key, value);
        return this;
    }

    public Object getParam(String key) {
        if (this.params.isEmpty()) {
            return null;
        }
        return this.params.get(key);
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int level) {
        StringBuilder result = new StringBuilder();
        result.append(this.indent(++level)).append("|").append(this.getType().name()).append("\n");
        if (!this.params.isEmpty()) {
            for (Map.Entry<String, Object> paramEntry : this.params.entrySet()) {
                String key = paramEntry.getKey();
                Object value = paramEntry.getValue();
                if (value instanceof Query) {
                    result.append(this.indent(level)).append("|").append(key).append(":\n");
                    result.append(((Query)value).toString(level));
                    continue;
                }
                if (value instanceof List) {
                    result.append(this.indent(level)).append("|").append(key).append(":\n");
                    result.append(this.collectionToString((List)value, level));
                    continue;
                }
                result.append(this.indent(level)).append("|").append(key).append(" -> ").append(value).append("\n");
            }
        }
        return result.toString();
    }

    protected String indent(int level) {
        StringBuilder result = new StringBuilder();
        for (int x = 0; x < level; ++x) {
            result.append("--");
        }
        return result.toString();
    }

    protected String collectionToString(Collection<Query> queries, int level) {
        StringBuilder result = new StringBuilder();
        for (Query query : queries) {
            result.append(query.toString(level));
        }
        return result.toString();
    }

    public static enum Type {
        QUERY(null),
        BOOL(QUERY),
        MATCH(QUERY),
        MATCH_ALL(QUERY),
        WILDCARD(QUERY),
        QUERY_STRING(QUERY),
        FILTERED(QUERY),
        FILTER(null),
        AND(FILTER),
        OR(FILTER),
        NOT(FILTER),
        EXISTS(FILTER),
        TERM(FILTER),
        RANGE(FILTER);

        private Type type;

        private Type(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }

    public static enum Parameter {
        MUST,
        MUST_NOT,
        SHOULD,
        VALUE,
        QUERY,
        FILTER,
        FILTERS,
        GT,
        GTE,
        LT,
        LTE,
        DEFAULT_FIELD,
        DEFAULT_OPERATOR,
        LOWERCASE_EXPANDED_TERMS;

    }
}

