/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.util;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

@ApplicationScoped
public class ElasticSearchJSONParser {
    private static final String KEYWORD_MAPPINGS = "mappings";
    private static final String KEYWORD_PROPERTIES = "properties";
    private static final String KEYWORD_INDEX = "index";
    private static final String KEYWORD_TYPE = "type";

    public FieldMappingResponse[] parseFieldMappings(String json) throws ParseException {
        if (json == null) {
            return null;
        }
        JSONParser parser = new JSONParser();
        JSONObject mappings = (JSONObject)parser.parse(json);
        if (mappings == null || mappings.size() == 0) {
            return null;
        }
        LinkedList<FieldMappingResponse> result = new LinkedList<FieldMappingResponse>();
        Set mappingEntries = mappings.entrySet();
        if (mappingEntries.size() == 0) {
            return null;
        }
        for (Map.Entry mappingEntry : mappingEntries) {
            JSONObject typeMappingObj = (JSONObject)mappingEntry.getValue();
            JSONObject propertiesObj = (JSONObject)typeMappingObj.get((Object)KEYWORD_PROPERTIES);
            Set propertiesEntries = propertiesObj.entrySet();
            if (propertiesEntries.size() == 0) {
                return null;
            }
            for (Map.Entry propertyEntry : propertiesEntries) {
                String fieldName = (String)propertyEntry.getKey();
                JSONObject fieldMappings = (JSONObject)propertyEntry.getValue();
                FieldMappingResponse fieldMapping = this.parseField(fieldName, fieldMappings);
                result.add(fieldMapping);
            }
        }
        return result.toArray(new FieldMappingResponse[result.size()]);
    }

    public FieldMappingResponse parseField(String fieldName, JSONObject fieldMappings) {
        if (fieldName == null || fieldName.trim().length() == 0 || fieldMappings == null) {
            return null;
        }
        Set propertiesEntries = fieldMappings.entrySet();
        if (propertiesEntries.size() == 0) {
            return null;
        }
        FieldMappingResponse.IndexType index = null;
        FieldMappingResponse.FieldType type = null;
        for (Map.Entry propertyEntry : propertiesEntries) {
            String propertyName = (String)propertyEntry.getKey();
            if (KEYWORD_INDEX.equalsIgnoreCase(propertyName)) {
                index = FieldMappingResponse.IndexType.valueOf(((String)propertyEntry.getValue()).toUpperCase());
                continue;
            }
            if (!KEYWORD_TYPE.equalsIgnoreCase(propertyName)) continue;
            type = FieldMappingResponse.FieldType.valueOf(((String)propertyEntry.getValue()).toUpperCase());
        }
        return new FieldMappingResponse(fieldName, type, index);
    }
}

