/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch;

import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchDataSetTestBase;
import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.DataSetFormatter;
import org.dashbuilder.dataset.date.Month;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.junit.Before;
import org.junit.Test;

public class ElasticSearchEmptyIntervalsTest
extends ElasticSearchDataSetTestBase {
    protected static final String EL_EXAMPLE_EMPTYINTERVALS_DEF = "org/dashbuilder/dataprovider/backend/elasticsearch/emptyIntervals.dset";
    protected static final String EL_DATASET_EMPTYINTERVALS_UUID = "emptyIntervals";

    @Before
    public void registerDataSet() throws Exception {
        super.setUp();
        this._registerDataSet(EL_EXAMPLE_EMPTYINTERVALS_DEF);
    }

    @Test
    public void testNonEmptyIntervals() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_EMPTYINTERVALS_UUID)).group("DATE")).fixed(DateIntervalType.MONTH, false)).firstMonth(Month.JANUARY)).column("DATE", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("NUMBER", AggregateFunctionType.SUM, "total")).buildLookup());
        this.printDataSet(result);
        Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"1", "1.00", "1.00"}, {"2", "1.00", "1.00"}, {"3", "2.00", "2.00"}, {"4", "1.00", "1.00"}, {"5", "1.00", "1.00"}, {"6", "1.00", "1.00"}, {"7", "1.00", "1.00"}, {"8", "1.00", "1.00"}, {"10", "1.00", "1.00"}, {"11", "1.00", "1.00"}}, (int)0);
    }

    @Test
    public void testEmptyIntervals() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_EMPTYINTERVALS_UUID)).group("DATE")).fixed(DateIntervalType.MONTH, true)).firstMonth(Month.JANUARY)).column("DATE", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("NUMBER", AggregateFunctionType.SUM, "total")).buildLookup());
        this.printDataSet(result);
        Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"1", "1.00", "1.00"}, {"2", "1.00", "1.00"}, {"3", "2.00", "2.00"}, {"4", "1.00", "1.00"}, {"5", "1.00", "1.00"}, {"6", "1.00", "1.00"}, {"7", "1.00", "1.00"}, {"8", "1.00", "1.00"}, {"9", "0.00", "0.00"}, {"10", "1.00", "1.00"}, {"11", "1.00", "1.00"}, {"12", "0.00", "0.00"}}, (int)0);
    }

    @Test
    public void testEmptyIntervalsUsingFirstMonth() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetFactory.newDataSetLookupBuilder().dataset(EL_DATASET_EMPTYINTERVALS_UUID)).group("DATE")).fixed(DateIntervalType.MONTH, true)).firstMonth(Month.MARCH)).column("DATE", "Period")).column(AggregateFunctionType.COUNT, "Occurrences")).column("NUMBER", AggregateFunctionType.SUM, "total")).buildLookup());
        this.printDataSet(result);
        Assertions.assertDataSetValues((DataSet)result, (DataSetFormatter)this.dataSetFormatter, (String[][])new String[][]{{"3", "2.00", "2.00"}, {"4", "1.00", "1.00"}, {"5", "1.00", "1.00"}, {"6", "1.00", "1.00"}, {"7", "1.00", "1.00"}, {"8", "1.00", "1.00"}, {"9", "0.00", "0.00"}, {"10", "1.00", "1.00"}, {"11", "1.00", "1.00"}, {"12", "0.00", "0.00"}, {"1", "1.00", "1.00"}, {"2", "1.00", "1.00"}}, (int)0);
    }
}

