/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AggregationSerializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AggregationsDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.HitDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.QuerySerializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.SearchResponseDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ElasticSearchJestClientTest {
    @Mock
    protected DataSetMetadata metadata;
    @Mock
    protected ElasticSearchDataSetDef definition;
    protected ElasticSearchJestClient client;

    @Before
    public void setUp() throws Exception {
        ElasticSearchValueTypeMapper typeMapper = new ElasticSearchValueTypeMapper();
        ElasticSearchUtils utils = new ElasticSearchUtils(typeMapper);
        ElasticSearchClientFactory clientFactory = new ElasticSearchClientFactory(typeMapper, utils);
        this.client = new ElasticSearchJestClient(clientFactory, typeMapper, utils);
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.metadata.getNumberOfColumns()).thenReturn((Object)6);
        Mockito.when((Object)this.metadata.getColumnId(0)).thenReturn((Object)"ID");
        Mockito.when((Object)this.metadata.getColumnType(0)).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnType("ID")).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnId(1)).thenReturn((Object)"CITY");
        Mockito.when((Object)this.metadata.getColumnType(1)).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnType("CITY")).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnId(2)).thenReturn((Object)"DEPARTMENT");
        Mockito.when((Object)this.metadata.getColumnType(2)).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnType("DEPARTMENT")).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnId(3)).thenReturn((Object)"EMPLOYEE");
        Mockito.when((Object)this.metadata.getColumnType(3)).thenReturn((Object)ColumnType.TEXT);
        Mockito.when((Object)this.metadata.getColumnType("EMPLOYEE")).thenReturn((Object)ColumnType.TEXT);
        Mockito.when((Object)this.metadata.getColumnId(4)).thenReturn((Object)"DATE");
        Mockito.when((Object)this.metadata.getColumnType(4)).thenReturn((Object)ColumnType.DATE);
        Mockito.when((Object)this.metadata.getColumnType("DATE")).thenReturn((Object)ColumnType.DATE);
        Mockito.when((Object)this.metadata.getColumnId(5)).thenReturn((Object)"AMOUNT");
        Mockito.when((Object)this.metadata.getColumnType(5)).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getColumnType("AMOUNT")).thenReturn((Object)ColumnType.NUMBER);
        Mockito.when((Object)this.metadata.getDefinition()).thenReturn((Object)this.definition);
        Mockito.when((Object)this.definition.getServerURL()).thenReturn((Object)"http://localhost:9200/");
        Mockito.when((Object)this.definition.getClusterName()).thenReturn((Object)"elasticsearch");
        Mockito.when((Object)this.definition.getIndex()).thenReturn((Object)"expensereports");
        Mockito.when((Object)this.definition.getType()).thenReturn((Object)"expense");
        Mockito.when((Object)this.definition.getPattern("ID")).thenReturn((Object)"integer");
        Mockito.when((Object)this.definition.getPattern("DATE")).thenReturn((Object)"MM-dd-YYYY");
    }

    @Test
    public void testQuerySerializer() {
        GsonBuilder builder = new GsonBuilder();
        QuerySerializer querySerializer = new QuerySerializer(this.client, this.metadata, new ArrayList());
        builder.registerTypeAdapter(Query.class, (Object)querySerializer);
        Gson gson = builder.create();
        Query query = new Query(Query.Type.MATCH_ALL);
        String serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"query\":{\"match_all\":{}}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.MATCH);
        query.setParam(Query.Parameter.VALUE.name(), (Object)"Sales");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"query\":{\"match\":{\"DEPARTMENT\":\"Sales\"}}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.WILDCARD);
        query.setParam(Query.Parameter.VALUE.name(), (Object)"Sal%");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"query\":{\"wildcard\":{\"DEPARTMENT\":\"Sal%\"}}}", (Object)serializedQuery);
        query = new Query("EMPLOYEE", Query.Type.QUERY_STRING);
        query.setParam(Query.Parameter.DEFAULT_FIELD.name(), (Object)"EMPLOYEE");
        query.setParam(Query.Parameter.DEFAULT_OPERATOR.name(), (Object)"AND");
        query.setParam(Query.Parameter.QUERY.name(), (Object)"Tony%");
        query.setParam(Query.Parameter.LOWERCASE_EXPANDED_TERMS.name(), (Object)"false");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"query\":{\"query_string\":{\"default_field\":\"EMPLOYEE\",\"default_operator\":\"AND\",\"query\":\"Tony%\",\"lowercase_expanded_terms\":\"false\"}}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.FILTERED);
        Query subQuery = new Query(Query.Type.MATCH_ALL);
        Query subFilter = new Query("AMOUNT", Query.Type.TERM);
        subFilter.setParam(Query.Parameter.VALUE.name(), (Object)"Sales");
        query.setParam(Query.Parameter.QUERY.name(), (Object)subQuery);
        query.setParam(Query.Parameter.FILTER.name(), (Object)subFilter);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"query\":{\"filtered\":{\"query\":{\"match_all\":{}},\"filter\":{\"term\":{\"AMOUNT\":\"Sales\"}}}}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.BOOL);
        query.setParam(Query.Parameter.MUST.name(), (Object)new Query(Query.Type.MATCH_ALL));
        query.setParam(Query.Parameter.MUST_NOT.name(), (Object)new Query(Query.Type.MATCH_ALL));
        query.setParam(Query.Parameter.SHOULD.name(), (Object)new Query(Query.Type.MATCH_ALL));
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"query\":{\"bool\":{\"must\":{\"match_all\":{}},\"must_not\":{\"match_all\":{}},\"should\":{\"match_all\":{}},\"minimum_should_match\":1}}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.TERM);
        query.setParam(Query.Parameter.VALUE.name(), (Object)"Sales");
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"filter\":{\"term\":{\"DEPARTMENT\":\"Sales\"}}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.AND);
        LinkedList<Query> filters = new LinkedList<Query>();
        filters.add(new Query("DEPARTMENT", Query.Type.TERM).setParam(Query.Parameter.VALUE.name(), (Object)"Sales"));
        filters.add(new Query("AMOUNT", Query.Type.RANGE).setParam(Query.Parameter.GT.name(), (Object)100));
        query.setParam(Query.Parameter.FILTERS.name(), filters);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"filter\":{\"and\":[{\"term\":{\"DEPARTMENT\":\"Sales\"}},{\"range\":{\"AMOUNT\":{\"gt\":100}}}]}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.OR);
        filters = new LinkedList();
        filters.add(new Query("DEPARTMENT", Query.Type.TERM).setParam(Query.Parameter.VALUE.name(), (Object)"Sales"));
        filters.add(new Query("AMOUNT", Query.Type.RANGE).setParam(Query.Parameter.GT.name(), (Object)100));
        query.setParam(Query.Parameter.FILTERS.name(), filters);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"filter\":{\"or\":[{\"term\":{\"DEPARTMENT\":\"Sales\"}},{\"range\":{\"AMOUNT\":{\"gt\":100}}}]}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.NOT);
        query.setParam(Query.Parameter.FILTER.name(), (Object)new Query("CITY", Query.Type.TERM).setParam(Query.Parameter.VALUE.name(), (Object)"London"));
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"filter\":{\"not\":{\"term\":{\"CITY\":\"London\"}}}}", (Object)serializedQuery);
        query = new Query("DEPARTMENT", Query.Type.EXISTS);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"filter\":{\"exists\":{\"field\":\"DEPARTMENT\"}}}", (Object)serializedQuery);
        query = new Query("AMOUNT", Query.Type.RANGE);
        query.setParam(Query.Parameter.LT.name(), (Object)100);
        query.setParam(Query.Parameter.LTE.name(), (Object)200);
        query.setParam(Query.Parameter.GT.name(), (Object)300);
        query.setParam(Query.Parameter.GTE.name(), (Object)400);
        serializedQuery = gson.toJson((Object)query, Query.class);
        Assert.assertEquals((Object)"{\"filter\":{\"range\":{\"AMOUNT\":{\"lt\":100,\"lte\":200,\"gt\":300,\"gte\":400}}}}", (Object)serializedQuery);
    }

    @Test
    public void testSearchResponseDeserialization() throws Exception {
        String response = "{\"took\":4,\"timed_out\":false,\"_shards\":{\"total\":5,\"successful\":5,\"failed\":0},\"hits\":{\"total\":8,\"max_score\":2.609438,\"hits\":[{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"12\",\"_score\":2.609438,\"_source\":{\"ID\":12, \"CITY\": \"Madrid\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Nita Marling\" ,\"DATE\": \"03-02-2012\" , \"AMOUNT\":344.9}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"20\",\"_score\":2.609438,\"_source\":{\"ID\":20, \"CITY\": \"Brno\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Neva Hunger\" ,\"DATE\": \"06-11-2011\" , \"AMOUNT\":995.3}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"21\",\"_score\":2.609438,\"_source\":{\"ID\":21, \"CITY\": \"Brno\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Neva Hunger\" ,\"DATE\": \"06-11-2011\" , \"AMOUNT\":234.3}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"10\",\"_score\":2.2039728,\"_source\":{\"ID\":10, \"CITY\": \"Madrid\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Nita Marling\" ,\"DATE\": \"03-11-2012\" , \"AMOUNT\":100}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"27\",\"_score\":2.2039728,\"_source\":{\"ID\":27, \"CITY\": \"Westford\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Jerri Preble\" ,\"DATE\": \"12-23-2010\" , \"AMOUNT\":899.03}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"9\",\"_score\":1.9162908,\"_source\":{\"ID\":9, \"CITY\": \"Madrid\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Nita Marling\" ,\"DATE\": \"05-11-2012\" , \"AMOUNT\":75.75}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"11\",\"_score\":1.9162908,\"_source\":{\"ID\":11, \"CITY\": \"Madrid\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Nita Marling\" ,\"DATE\": \"03-16-2012\" , \"AMOUNT\":220.8}},{\"_index\":\"expensereports\",\"_type\":\"expense\",\"_id\":\"28\",\"_score\":1.9162908,\"_source\":{\"ID\":28, \"CITY\": \"Westford\", \"DEPARTMENT\": \"Sales\", \"EMPLOYEE\": \"Jerri Preble\" ,\"DATE\": \"11-30-2010\" , \"AMOUNT\":343.45}}]}}";
        DataColumnImpl col0 = new DataColumnImpl("ID", ColumnType.NUMBER);
        DataColumnImpl col1 = new DataColumnImpl("CITY", ColumnType.LABEL);
        DataColumnImpl col2 = new DataColumnImpl("DEPARTMENT", ColumnType.LABEL);
        DataColumnImpl col3 = new DataColumnImpl("EMPLOYEE", ColumnType.TEXT);
        DataColumnImpl col4 = new DataColumnImpl("DATE", ColumnType.DATE);
        DataColumnImpl col5 = new DataColumnImpl("AMOUNT", ColumnType.NUMBER);
        LinkedList<DataColumnImpl> columns = new LinkedList<DataColumnImpl>();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        columns.add(col3);
        columns.add(col4);
        columns.add(col5);
        GsonBuilder builder = new GsonBuilder();
        SearchResponseDeserializer searchResponseDeserializer = new SearchResponseDeserializer(this.client, this.metadata, columns);
        HitDeserializer hitDeserializer = new HitDeserializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(SearchResponse.class, (Object)searchResponseDeserializer);
        builder.registerTypeAdapter(SearchHitResponse.class, (Object)hitDeserializer);
        Gson gson = builder.create();
        SearchResponse result = (SearchResponse)gson.fromJson(response, SearchResponse.class);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)4L, (long)result.getTookInMillis());
        Assert.assertEquals((double)result.getMaxScore(), (double)2.609437942504883, (double)0.1);
        Assert.assertEquals((long)200L, (long)result.getResponseStatus());
        Assert.assertEquals((long)0L, (long)result.getShardFailures());
        Assert.assertEquals((long)5L, (long)result.getTotalShards());
        Assert.assertEquals((long)5L, (long)result.getSuccessfulShards());
        Assert.assertEquals((long)8L, (long)result.getTotalHits());
        Assert.assertEquals((long)8L, (long)result.getHits().length);
        SearchHitResponse hit0 = result.getHits()[0];
        Assert.assertNotNull((Object)hit0);
        Assert.assertEquals((Object)"expensereports", (Object)hit0.getIndex());
        Assert.assertEquals((Object)"expense", (Object)hit0.getType());
        Assert.assertEquals((Object)"12", (Object)hit0.getId());
        Assert.assertEquals((double)hit0.getScore(), (double)2.609437942504883, (double)0.1);
        LinkedHashMap hit0Fields = hit0.getFields();
        Assert.assertNotNull((Object)hit0Fields);
        Assert.assertEquals((long)hit0Fields.size(), (long)6L);
        Assert.assertEquals((Object)"12.0", (Object)hit0Fields.get("ID").toString());
        Assert.assertEquals((Object)"Madrid", (Object)hit0Fields.get("CITY").toString());
        Assert.assertEquals((Object)"Sales", (Object)hit0Fields.get("DEPARTMENT").toString());
        Assert.assertEquals((Object)"Nita Marling", (Object)hit0Fields.get("EMPLOYEE").toString());
        Date date = new SimpleDateFormat("yyyy-MM-dd").parse("2012-03-02");
        Assert.assertEquals((Object)date, hit0Fields.get("DATE"));
        Assert.assertEquals((Object)"344.9", (Object)hit0Fields.get("AMOUNT").toString());
        SearchHitResponse hit7 = result.getHits()[7];
        Assert.assertNotNull((Object)hit7);
        Assert.assertEquals((Object)"expensereports", (Object)hit7.getIndex());
        Assert.assertEquals((Object)"expense", (Object)hit7.getType());
        Assert.assertEquals((Object)"28", (Object)hit7.getId());
        Assert.assertEquals((double)hit7.getScore(), (double)1.9162907600402832, (double)0.1);
        LinkedHashMap hit7Fields = hit7.getFields();
        Assert.assertNotNull((Object)hit7Fields);
        Assert.assertEquals((long)6L, (long)hit7Fields.size());
        Assert.assertEquals((Object)"28.0", (Object)hit7Fields.get("ID").toString());
        Assert.assertEquals((Object)"Westford", (Object)hit7Fields.get("CITY").toString());
        Assert.assertEquals((Object)"Sales", (Object)hit7Fields.get("DEPARTMENT").toString());
        Assert.assertEquals((Object)"Jerri Preble", (Object)hit7Fields.get("EMPLOYEE").toString());
        date = new SimpleDateFormat("yyyy-MM-dd").parse("2010-11-30");
        Assert.assertEquals((Object)date, hit7Fields.get("DATE"));
        Assert.assertEquals((Object)"343.45", (Object)hit7Fields.get("AMOUNT").toString());
    }

    @Test
    public void testAggregationSerializer() {
        GsonBuilder builder = new GsonBuilder();
        DataColumnImpl col0 = new DataColumnImpl("department-count", ColumnType.NUMBER);
        DataColumnImpl col1 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        DataColumnImpl col2 = new DataColumnImpl("amount-max", ColumnType.NUMBER);
        DataColumnImpl col3 = new DataColumnImpl("amount-avg", ColumnType.NUMBER);
        DataColumnImpl col4 = new DataColumnImpl("amount-sum", ColumnType.NUMBER);
        DataColumnImpl col5 = new DataColumnImpl("amount-distinct", ColumnType.NUMBER);
        LinkedList<DataColumnImpl> columns = new LinkedList<DataColumnImpl>();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        columns.add(col3);
        columns.add(col4);
        columns.add(col5);
        AggregationSerializer aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        Gson gson = builder.create();
        DataSetGroup aggregation = new DataSetGroup();
        aggregation.setDataSetUUID("testUUID");
        aggregation.setColumnGroup(null);
        aggregation.setJoin(false);
        GroupFunction countFunction = new GroupFunction("DEPARTMENT", "department-count", AggregateFunctionType.COUNT);
        GroupFunction minFunction = new GroupFunction("AMOUNT", "amount-min", AggregateFunctionType.MIN);
        GroupFunction maxFunction = new GroupFunction("AMOUNT", "amount-max", AggregateFunctionType.MAX);
        GroupFunction avgFunction = new GroupFunction("AMOUNT", "amount-avg", AggregateFunctionType.AVERAGE);
        GroupFunction sumFunction = new GroupFunction("AMOUNT", "amount-sum", AggregateFunctionType.SUM);
        GroupFunction distinctFunction = new GroupFunction("AMOUNT", "amount-distinct", AggregateFunctionType.DISTINCT);
        aggregation.addGroupFunction(new GroupFunction[]{countFunction, minFunction, maxFunction, avgFunction, sumFunction, distinctFunction});
        String aggregationResult = gson.toJson((Object)aggregation, DataSetGroup.class);
        Assert.assertEquals((Object)"{\"aggregations\":{\"department-count\":{\"value_count\":{\"field\":\"DEPARTMENT\"}},\"amount-min\":{\"min\":{\"field\":\"AMOUNT\"}},\"amount-max\":{\"max\":{\"field\":\"AMOUNT\"}},\"amount-avg\":{\"avg\":{\"field\":\"AMOUNT\"}},\"amount-sum\":{\"sum\":{\"field\":\"AMOUNT\"}},\"amount-distinct\":{\"cardinality\":{\"field\":\"AMOUNT\"}}}}", (Object)aggregationResult);
        builder = new GsonBuilder();
        col0 = new DataColumnImpl("departmentGrouped", ColumnType.NUMBER);
        col1 = new DataColumnImpl("amount-count", ColumnType.NUMBER);
        col2 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        columns = new LinkedList();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        gson = builder.create();
        DataSetGroup groupByAggregation = new DataSetGroup();
        groupByAggregation.setDataSetUUID("testUUID");
        groupByAggregation.setJoin(false);
        groupByAggregation.setColumnGroup(new ColumnGroup("DEPARTMENT", "departmentGrouped", GroupStrategy.DYNAMIC));
        GroupFunction groupByCountFunction = new GroupFunction("AMOUNT", "amount-count", AggregateFunctionType.COUNT);
        GroupFunction groupByMinFunction = new GroupFunction("AMOUNT", "amount-min", AggregateFunctionType.MIN);
        groupByAggregation.addGroupFunction(new GroupFunction[]{groupByCountFunction, groupByMinFunction});
        aggregationResult = gson.toJson((Object)groupByAggregation, DataSetGroup.class);
        Assert.assertEquals((Object)"{\"aggregations\":{\"departmentGrouped\":{\"terms\":{\"field\":\"DEPARTMENT\",\"order\":{\"_term\":\"asc\"},\"min_doc_count\":1,\"size\":0},\"aggregations\":{\"amount-count\":{\"value_count\":{\"field\":\"AMOUNT\"}},\"amount-min\":{\"min\":{\"field\":\"AMOUNT\"}}}}}}", (Object)aggregationResult);
        builder = new GsonBuilder();
        col0 = new DataColumnImpl("AMOUNT", ColumnType.NUMBER);
        col1 = new DataColumnImpl("amount-max", ColumnType.NUMBER);
        col2 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        columns = new LinkedList();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        gson = builder.create();
        DataSetGroup histogramAggreagation = new DataSetGroup();
        histogramAggreagation.setDataSetUUID("testUUID");
        histogramAggreagation.setColumnGroup(new ColumnGroup("AMOUNT", "AMOUNT", GroupStrategy.DYNAMIC, 99, "20"));
        histogramAggreagation.setJoin(false);
        groupByCountFunction = new GroupFunction("AMOUNT", "amount-max", AggregateFunctionType.MAX);
        groupByMinFunction = new GroupFunction("AMOUNT", "amount-min", AggregateFunctionType.MIN);
        histogramAggreagation.addGroupFunction(new GroupFunction[]{groupByCountFunction, groupByMinFunction});
        aggregationResult = gson.toJson((Object)histogramAggreagation, DataSetGroup.class);
        Assert.assertEquals((Object)"{\"aggregations\":{\"AMOUNT\":{\"histogram\":{\"field\":\"AMOUNT\",\"interval\":20,\"order\":{\"_key\":\"asc\"},\"min_doc_count\":1},\"aggregations\":{\"amount-max\":{\"max\":{\"field\":\"AMOUNT\"}},\"amount-min\":{\"min\":{\"field\":\"AMOUNT\"}}}}}}", (Object)aggregationResult);
        builder = new GsonBuilder();
        col0 = new DataColumnImpl("AMOUNT", ColumnType.NUMBER);
        col1 = new DataColumnImpl("amount-max", ColumnType.NUMBER);
        col2 = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        columns = new LinkedList();
        columns.add(col0);
        columns.add(col1);
        columns.add(col2);
        aggregationSerializer = new AggregationSerializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        gson = builder.create();
        histogramAggreagation = new DataSetGroup();
        histogramAggreagation.setDataSetUUID("testUUID");
        ColumnGroup cg = new ColumnGroup("AMOUNT", "AMOUNT", GroupStrategy.DYNAMIC, 99, "20");
        cg.setEmptyIntervalsAllowed(true);
        histogramAggreagation.setColumnGroup(cg);
        histogramAggreagation.setJoin(false);
        groupByCountFunction = new GroupFunction("AMOUNT", "amount-max", AggregateFunctionType.MAX);
        groupByMinFunction = new GroupFunction("AMOUNT", "amount-min", AggregateFunctionType.MIN);
        histogramAggreagation.addGroupFunction(new GroupFunction[]{groupByCountFunction, groupByMinFunction});
        aggregationResult = gson.toJson((Object)histogramAggreagation, DataSetGroup.class);
        Assert.assertEquals((Object)"{\"aggregations\":{\"AMOUNT\":{\"histogram\":{\"field\":\"AMOUNT\",\"interval\":20,\"order\":{\"_key\":\"asc\"},\"min_doc_count\":0},\"aggregations\":{\"amount-max\":{\"max\":{\"field\":\"AMOUNT\"}},\"amount-min\":{\"min\":{\"field\":\"AMOUNT\"}}}}}}", (Object)aggregationResult);
    }

    @Test
    public void testAggregationDeserializer() {
        String aggregations1 = "{ \"departmentGrouped\": {\n        \"doc_count_error_upper_bound\": 0,\n        \"sum_other_doc_count\": 0,\n        \"buckets\": [\n            {\n                \"key\": \"Engineering\",\n                \"doc_count\": 19,\n                \"amount-count\": {\n                    \"value\": 19\n                },\n                \"amount-min\": {\n                    \"value\": 120.3499984741211\n                }\n            },\n            {\n                \"key\": \"Management\",\n                \"doc_count\": 11,\n                \"amount-count\": {\n                    \"value\": 11\n                },\n                \"amount-min\": {\n                    \"value\": 43.029998779296875\n                }\n            },\n            {\n                \"key\": \"Sales\",\n                \"doc_count\": 8,\n                \"amount-count\": {\n                    \"value\": 8\n                },\n                \"amount-min\": {\n                    \"value\": 75.75\n                }\n            },\n            {\n                \"key\": \"Services\",\n                \"doc_count\": 5,\n                \"amount-count\": {\n                    \"value\": 5\n                },\n                \"amount-min\": {\n                    \"value\": 152.25\n                }\n            },\n            {\n                \"key\": \"Support\",\n                \"doc_count\": 7,\n                \"amount-count\": {\n                    \"value\": 7\n                },\n                \"amount-min\": {\n                    \"value\": 300.010009765625\n                }\n            }\n        ]\n    }\n}";
        DataColumnImpl deptColumn = new DataColumnImpl("departmentGrouped", ColumnType.LABEL);
        DataColumnImpl amounutCountColumn = new DataColumnImpl("amount-count", ColumnType.NUMBER);
        DataColumnImpl amounutMinColumn = new DataColumnImpl("amount-min", ColumnType.NUMBER);
        LinkedList<DataColumnImpl> columns = new LinkedList<DataColumnImpl>();
        columns.add(deptColumn);
        columns.add(amounutCountColumn);
        columns.add(amounutMinColumn);
        GsonBuilder builder = new GsonBuilder();
        AggregationsDeserializer aggregationsDeserializer = new AggregationsDeserializer(this.client, this.metadata, columns);
        builder.registerTypeAdapter(SearchHitResponse[].class, (Object)aggregationsDeserializer);
        Gson gson = builder.create();
        SearchHitResponse[] hits = (SearchHitResponse[])gson.fromJson(aggregations1, SearchHitResponse[].class);
        Assert.assertTrue((hits != null ? 1 : 0) != 0);
        Assert.assertTrue((hits.length == 5 ? 1 : 0) != 0);
        SearchHitResponse hit0 = hits[0];
        Assert.assertTrue((hit0 != null ? 1 : 0) != 0);
        LinkedHashMap hit0Fields = hit0.getFields();
        Assert.assertTrue((hit0Fields != null ? 1 : 0) != 0);
        Assert.assertTrue((hit0Fields.size() == 3 ? 1 : 0) != 0);
        String hit0AmountCount = hit0Fields.get("amount-count").toString();
        String hit0Dept = hit0Fields.get("departmentGrouped").toString();
        String hit0AmountMin = hit0Fields.get("amount-min").toString();
        Assert.assertEquals((Object)"19.0", (Object)hit0AmountCount);
        Assert.assertEquals((Object)"Engineering", (Object)hit0Dept);
        Assert.assertEquals((Object)"120.3499984741211", (Object)hit0AmountMin);
        SearchHitResponse hit1 = hits[1];
        Assert.assertTrue((hit1 != null ? 1 : 0) != 0);
        LinkedHashMap hit1Fields = hit1.getFields();
        Assert.assertTrue((hit1Fields != null ? 1 : 0) != 0);
        Assert.assertTrue((hit1Fields.size() == 3 ? 1 : 0) != 0);
        String hit1AmountCount = hit1Fields.get("amount-count").toString();
        String hit1Dept = hit1Fields.get("departmentGrouped").toString();
        String hit1AmountMin = hit1Fields.get("amount-min").toString();
        Assert.assertEquals((Object)"11.0", (Object)hit1AmountCount);
        Assert.assertEquals((Object)"Management", (Object)hit1Dept);
        Assert.assertEquals((Object)"43.029998779296875", (Object)hit1AmountMin);
        SearchHitResponse hit4 = hits[4];
        Assert.assertTrue((hit4 != null ? 1 : 0) != 0);
        LinkedHashMap hit4Fields = hit4.getFields();
        Assert.assertTrue((hit4Fields != null ? 1 : 0) != 0);
        Assert.assertTrue((hit4Fields.size() == 3 ? 1 : 0) != 0);
        String hit4AmountCount = hit4Fields.get("amount-count").toString();
        String hit4Dept = hit4Fields.get("departmentGrouped").toString();
        String hit4AmountMin = hit4Fields.get("amount-min").toString();
        Assert.assertEquals((Object)"7.0", (Object)hit4AmountCount);
        Assert.assertEquals((Object)"Support", (Object)hit4Dept);
        Assert.assertEquals((Object)"300.010009765625", (Object)hit4AmountMin);
    }
}

