/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchQueryBuilder;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.date.TimeFrame;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.LogicalExprFilter;
import org.dashbuilder.dataset.filter.LogicalExprType;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.Interval;

public class ElasticSearchQueryBuilderImpl
implements ElasticSearchQueryBuilder<ElasticSearchQueryBuilderImpl> {
    protected ElasticSearchValueTypeMapper valueTypeMapper;
    protected ElasticSearchUtils utils;
    private DataSetMetadata metadata;
    private List<DataSetGroup> groups = new LinkedList<DataSetGroup>();
    private List<DataSetFilter> filters = new LinkedList<DataSetFilter>();

    public ElasticSearchQueryBuilderImpl(ElasticSearchValueTypeMapper valueTypeMapper, ElasticSearchUtils utils) {
        this.valueTypeMapper = valueTypeMapper;
        this.utils = utils;
    }

    @Override
    public ElasticSearchQueryBuilderImpl metadata(DataSetMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public ElasticSearchQueryBuilderImpl groupInterval(List<DataSetGroup> groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public ElasticSearchQueryBuilderImpl filter(List<DataSetFilter> filters) {
        if (filters != null) {
            this.filters.addAll(filters);
        }
        return this;
    }

    @Override
    public Query build() {
        Query result;
        if (this.filters == null || this.filters.isEmpty()) {
            return null;
        }
        LinkedList<Query> queries = new LinkedList<Query>();
        for (DataSetFilter filter : this.filters) {
            Query subQuery = this.build(filter.getColumnFilterList(), Operator.AND);
            if (subQuery == null) continue;
            queries.add(subQuery);
        }
        if (this.groups != null) {
            for (DataSetGroup group : this.groups) {
                List<Query> subQueries;
                if (!group.isSelect() || (subQueries = this.buildGroupIntervalQuery(group)) == null || subQueries.isEmpty()) continue;
                for (Query subQuery : subQueries) {
                    queries.add(subQuery);
                }
            }
        }
        if ((result = this.joinQueriesAndFilters(queries, Operator.AND)) != null && this.isFilter(result)) {
            Query filtered = new Query(Query.Type.FILTERED);
            Query matchAll = new Query(Query.Type.MATCH_ALL);
            filtered.setParam(Query.Parameter.QUERY.name(), matchAll);
            filtered.setParam(Query.Parameter.FILTER.name(), result);
            return filtered;
        }
        return result;
    }

    private List<Query> buildGroupIntervalQuery(DataSetGroup group) {
        if (group == null || !group.isSelect()) {
            return null;
        }
        LinkedList<Query> result = new LinkedList<Query>();
        String sourceId = group.getColumnGroup().getSourceId();
        ColumnType columnType = this.metadata.getColumnType(sourceId);
        ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)this.metadata.getDefinition();
        List intervals = group.getSelectedIntervalList();
        for (Interval interval : intervals) {
            Query _result = null;
            boolean isLabelCol = ColumnType.LABEL.equals((Object)columnType);
            boolean isNumericCol = ColumnType.NUMBER.equals((Object)columnType);
            boolean isDateCol = ColumnType.DATE.equals((Object)columnType);
            boolean isTextCol = ColumnType.TEXT.equals((Object)columnType);
            if (isTextCol) {
                throw new IllegalArgumentException("Not supported type [" + columnType.name() + "] for column with id [" + sourceId + "] using grouping.");
            }
            if (isLabelCol) {
                String filterValue = this.valueTypeMapper.formatLabel(def, sourceId, interval.getName());
                _result = new Query(sourceId, Query.Type.TERM);
                _result.setParam(Query.Parameter.VALUE.name(), filterValue);
            } else if (isNumericCol || isDateCol) {
                Object maxValue = interval.getMaxValue();
                Object minValue = interval.getMinValue();
                String value0 = isNumericCol ? this.valueTypeMapper.formatNumeric(def, sourceId, (Number)minValue) : this.valueTypeMapper.formatDate(def, sourceId, (java.util.Date)minValue);
                String value1 = isNumericCol ? this.valueTypeMapper.formatNumeric(def, sourceId, (Number)maxValue) : this.valueTypeMapper.formatDate(def, sourceId, (java.util.Date)maxValue);
                _result = new Query(sourceId, Query.Type.RANGE);
                _result.setParam(Query.Parameter.GT.name(), value0);
                _result.setParam(Query.Parameter.LT.name(), value1);
            }
            result.add(_result);
        }
        return result;
    }

    private String formatValue(ElasticSearchDataSetDef definition, String columnId, Object value) {
        ColumnType columnType = this.metadata.getColumnType(columnId);
        boolean isLabelCol = ColumnType.LABEL.equals((Object)columnType);
        boolean isNumericCol = ColumnType.NUMBER.equals((Object)columnType);
        boolean isDateCol = ColumnType.DATE.equals((Object)columnType);
        boolean isTextCol = ColumnType.TEXT.equals((Object)columnType);
        if (isTextCol) {
            return this.valueTypeMapper.formatText(definition, columnId, value != null ? value.toString() : null);
        }
        if (isLabelCol) {
            return this.valueTypeMapper.formatLabel(definition, columnId, value != null ? value.toString() : null);
        }
        if (isDateCol) {
            return this.valueTypeMapper.formatDate(definition, columnId, (java.util.Date)value);
        }
        if (isNumericCol) {
            return this.valueTypeMapper.formatNumeric(definition, columnId, (Number)value);
        }
        throw new IllegalArgumentException("Not supported type [" + columnType.name() + "] for column id [" + columnId + "].");
    }

    private Query joinQueriesAndFilters(List<Query> queries, Operator operator) {
        if (queries == null || queries.isEmpty()) {
            return null;
        }
        Query result = null;
        List<Query> subQueries = this.getQueries(queries);
        List<Query> subFilters = this.getFilters(queries);
        boolean existFilters = !subFilters.isEmpty();
        boolean existQueries = !subQueries.isEmpty();
        boolean onlyOneQuery = queries.size() == 1;
        String boolType = this.getBooleanQueryType(operator);
        Query.Type filterOperator = this.getType(operator);
        if (!existFilters) {
            if (onlyOneQuery && !operator.equals((Object)Operator.NOT)) {
                return queries.get(0);
            }
            result = new Query(Query.Type.BOOL);
            result.setParam(boolType, queries);
        } else if (!existQueries) {
            if (onlyOneQuery && !operator.equals((Object)Operator.NOT)) {
                return queries.get(0);
            }
            if (onlyOneQuery) {
                result = new Query(Query.Type.NOT);
                result.setParam(Query.Parameter.FILTER.name(), queries.get(0));
            } else {
                result = new Query(filterOperator);
                result.setParam(Query.Parameter.FILTERS.name(), queries);
            }
        } else {
            Query filter = null;
            if (subFilters.size() == 1) {
                filter = subFilters.get(0);
            } else {
                filter = new Query(filterOperator);
                filter.setParam(Query.Parameter.FILTERS.name(), subFilters);
            }
            Query booleanQuery = null;
            if (subQueries.size() == 1) {
                booleanQuery = subQueries.get(0);
            } else {
                booleanQuery = new Query(Query.Type.BOOL);
                booleanQuery.setParam(boolType, subQueries);
            }
            boolean isAndOp = operator.equals((Object)Operator.AND);
            if (isAndOp) {
                result = new Query(Query.Type.FILTERED);
                result.setParam(Query.Parameter.QUERY.name(), booleanQuery);
                result.setParam(Query.Parameter.FILTER.name(), filter);
            } else {
                result = new Query(Query.Type.BOOL);
                Query filtered = new Query(Query.Type.FILTERED);
                filtered.setParam(Query.Parameter.FILTER.name(), filter);
                result.setParam(boolType, Arrays.asList(booleanQuery, filtered));
            }
        }
        return result;
    }

    protected String getBooleanQueryType(Operator operator) {
        String boolType = null;
        switch (operator) {
            case AND: {
                boolType = Query.Parameter.MUST.name();
                break;
            }
            case OR: {
                boolType = Query.Parameter.SHOULD.name();
                break;
            }
            case NOT: {
                boolType = Query.Parameter.MUST_NOT.name();
            }
        }
        return boolType;
    }

    protected Query.Type getType(Operator operator) {
        Query.Type boolType = null;
        switch (operator) {
            case AND: {
                boolType = Query.Type.AND;
                break;
            }
            case OR: {
                boolType = Query.Type.OR;
                break;
            }
            case NOT: {
                boolType = Query.Type.NOT;
            }
        }
        return boolType;
    }

    private boolean isQuery(Query query) {
        return query != null && query.getType().getType().equals((Object)Query.Type.QUERY);
    }

    private boolean isFilter(Query query) {
        return query != null && query.getType().getType().equals((Object)Query.Type.FILTER);
    }

    private List<Query> getFilters(List<Query> queries) {
        if (queries == null || queries.isEmpty()) {
            return null;
        }
        LinkedList<Query> result = new LinkedList<Query>();
        for (Query query : queries) {
            if (!this.isFilter(query)) continue;
            result.add(query);
        }
        return result;
    }

    private List<Query> getQueries(List<Query> queries) {
        if (queries == null || queries.isEmpty()) {
            return null;
        }
        LinkedList<Query> result = new LinkedList<Query>();
        for (Query query : queries) {
            if (!this.isQuery(query)) continue;
            result.add(query);
        }
        return result;
    }

    private Query build(List<ColumnFilter> filterList, Operator operator) {
        if (filterList == null) {
            return null;
        }
        LinkedList<Query> results = new LinkedList<Query>();
        for (ColumnFilter filter : filterList) {
            Query result = null;
            if (filter instanceof CoreFunctionFilter) {
                result = this.buildColumnCoreFunctionFilter((CoreFunctionFilter)filter, this.metadata);
            } else if (filter instanceof LogicalExprFilter) {
                LogicalExprFilter f = (LogicalExprFilter)filter;
                LogicalExprType type = f.getLogicalOperator();
                if (LogicalExprType.AND.equals((Object)type)) {
                    result = this.buildLogicalExpressionFilter(f, Operator.AND);
                } else if (LogicalExprType.OR.equals((Object)type)) {
                    result = this.buildLogicalExpressionFilter(f, Operator.OR);
                } else if (LogicalExprType.NOT.equals((Object)type)) {
                    result = this.buildLogicalExpressionFilter(f, Operator.NOT);
                }
            }
            if (result == null) continue;
            results.add(result);
        }
        return this.joinQueriesAndFilters(results, operator);
    }

    protected Query buildLogicalExpressionFilter(LogicalExprFilter filter, Operator operator) {
        if (filter == null) {
            return null;
        }
        List columnFilters = filter.getLogicalTerms();
        if (columnFilters != null && !columnFilters.isEmpty()) {
            return this.build(columnFilters, operator);
        }
        return null;
    }

    protected Query buildColumnCoreFunctionFilter(CoreFunctionFilter filter, DataSetMetadata metadata) {
        String columnId = filter.getColumnId();
        ColumnType columnType = metadata.getColumnType(columnId);
        ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)metadata.getDefinition();
        Query result = null;
        CoreFunctionType type = filter.getType();
        List params = filter.getParameters();
        if (CoreFunctionType.IS_NULL.equals((Object)type)) {
            result = new Query(Query.Type.NOT);
            Query existResult = new Query(columnId, Query.Type.EXISTS);
            result.setParam(Query.Parameter.FILTER.name(), existResult);
        } else if (CoreFunctionType.NOT_NULL.equals((Object)type)) {
            result = new Query(columnId, Query.Type.EXISTS);
        } else if (CoreFunctionType.EQUALS_TO.equals((Object)type) || CoreFunctionType.IN.equals((Object)type)) {
            result = ColumnType.LABEL.equals((Object)columnType) ? this.buildTermOrTermsFilter(def, columnId, params) : this.buildBooleanMatchQuery(def, columnId, params);
        } else if (CoreFunctionType.NOT_EQUALS_TO.equals((Object)type) || CoreFunctionType.NOT_IN.equals((Object)type)) {
            if (ColumnType.LABEL.equals((Object)columnType)) {
                Query resultMatch = this.buildTermOrTermsFilter(def, columnId, params);
                result = new Query(columnId, Query.Type.NOT);
                result.setParam(Query.Parameter.FILTER.name(), resultMatch);
            } else {
                Query resultMatch = this.buildBooleanMatchQuery(def, columnId, params);
                result = new Query(columnId, Query.Type.BOOL);
                result.setParam(Query.Parameter.MUST_NOT.name(), this.asList(resultMatch));
            }
        } else if (CoreFunctionType.LIKE_TO.equals((Object)type)) {
            String value = this.formatValue(def, columnId, params.get(0));
            if (value != null) {
                if (ColumnType.NUMBER.equals((Object)columnType) || ColumnType.DATE.equals((Object)columnType)) {
                    throw new RuntimeException("The operator LIKE can be applied only for LABEL or TEXT column types. The column [" + columnId + "] is type [" + columnType.name() + "}.");
                }
                String indexType = def.getPattern(columnId);
                if (indexType == null || indexType.trim().length() == 0) {
                    indexType = FieldMappingResponse.IndexType.ANALYZED.name();
                }
                boolean caseSensitive = params.size() < 2 || Boolean.parseBoolean(params.get(1).toString());
                boolean isFieldAnalyzed = FieldMappingResponse.IndexType.ANALYZED.name().equalsIgnoreCase(indexType);
                if (!isFieldAnalyzed && !caseSensitive) {
                    throw new RuntimeException("Case unsensitive is not supported for not_analyzed string fields. Field: [" + columnId + "].");
                }
                String pattern = this.utils.transformPattern(value.toString());
                boolean isLowerCaseExpandedTerms = isFieldAnalyzed && !caseSensitive;
                result = new Query(columnId, Query.Type.QUERY_STRING);
                result.setParam(Query.Parameter.DEFAULT_FIELD.name(), columnId);
                result.setParam(Query.Parameter.DEFAULT_OPERATOR.name(), "AND");
                result.setParam(Query.Parameter.QUERY.name(), pattern);
                result.setParam(Query.Parameter.LOWERCASE_EXPANDED_TERMS.name(), isLowerCaseExpandedTerms);
            }
        } else if (CoreFunctionType.LOWER_THAN.equals((Object)type)) {
            String value = this.formatValue(def, columnId, params.get(0));
            result = new Query(columnId, Query.Type.RANGE);
            result.setParam(Query.Parameter.LT.name(), value);
        } else if (CoreFunctionType.LOWER_OR_EQUALS_TO.equals((Object)type)) {
            String value = this.formatValue(def, columnId, params.get(0));
            result = new Query(columnId, Query.Type.RANGE);
            result.setParam(Query.Parameter.LTE.name(), value);
        } else if (CoreFunctionType.GREATER_THAN.equals((Object)type)) {
            String value = this.formatValue(def, columnId, params.get(0));
            result = new Query(columnId, Query.Type.RANGE);
            result.setParam(Query.Parameter.GT.name(), value);
        } else if (CoreFunctionType.GREATER_OR_EQUALS_TO.equals((Object)type)) {
            String value = this.formatValue(def, columnId, params.get(0));
            result = new Query(columnId, Query.Type.RANGE);
            result.setParam(Query.Parameter.GTE.name(), value);
        } else if (CoreFunctionType.BETWEEN.equals((Object)type)) {
            String value0 = this.formatValue(def, columnId, params.get(0));
            String value1 = this.formatValue(def, columnId, params.get(1));
            result = new Query(columnId, Query.Type.RANGE);
            result.setParam(Query.Parameter.GTE.name(), value0);
            result.setParam(Query.Parameter.LTE.name(), value1);
        } else if (CoreFunctionType.TIME_FRAME.equals((Object)type)) {
            TimeFrame timeFrame = TimeFrame.parse((String)params.get(0).toString());
            if (timeFrame != null) {
                Date past = new Date(timeFrame.getFrom().getTimeInstant().getTime());
                Date future = new Date(timeFrame.getTo().getTimeInstant().getTime());
                result = new Query(columnId, Query.Type.RANGE);
                result.setParam(Query.Parameter.GTE.name(), past);
                result.setParam(Query.Parameter.LTE.name(), future);
            }
        } else {
            throw new IllegalArgumentException("Core function type not supported: " + type);
        }
        return result;
    }

    protected Query buildBooleanMatchQuery(ElasticSearchDataSetDef def, String columnId, List params) {
        Query result = new Query(columnId, Query.Type.MATCH);
        StringBuilder terms = new StringBuilder();
        String _pre = params.size() == 1 ? "" : " ";
        for (Object param : params) {
            String paramStr = this.formatValue(def, columnId, param);
            terms.append(_pre).append(paramStr);
        }
        if (params.size() > 1) {
            result.setParam(Query.Parameter.OPERATOR.name(), "or");
        }
        result.setParam(Query.Parameter.VALUE.name(), terms.toString());
        return result;
    }

    protected Query buildTermOrTermsFilter(ElasticSearchDataSetDef def, String columnId, List params) {
        Query result;
        Object value;
        if (params.size() == 1) {
            value = this.formatValue(def, columnId, params.get(0));
            result = new Query(columnId, Query.Type.TERM);
        } else {
            result = new Query(columnId, Query.Type.TERMS);
            ArrayList<String> terms = new ArrayList<String>(params.size());
            for (Object param : params) {
                String paramStr = this.formatValue(def, columnId, param);
                terms.add(paramStr);
            }
            value = terms;
        }
        result.setParam(Query.Parameter.VALUE.name(), value);
        return result;
    }

    protected List<Query> asList(Query ... queries) {
        if (queries == null) {
            return null;
        }
        LinkedList<Query> result = new LinkedList<Query>();
        Collections.addAll(result, queries);
        return result;
    }

    private static enum Operator {
        AND,
        OR,
        NOT;

    }
}

