/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import io.searchbox.core.Count;
import io.searchbox.core.CountResult;
import io.searchbox.core.Search;
import io.searchbox.core.search.sort.Sort;
import io.searchbox.indices.mapping.GetMapping;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchClientFactory;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.ElasticSearchClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.exception.ElasticSearchClientGenericException;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AggregationSerializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AggregationsDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.FieldMapping;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.HitDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.QuerySerializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.SearchQuerySerializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.SearchResponseDeserializer;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.CountResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.FieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.IndexMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.MappingsResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.MultiFieldMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.Query;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.TypeMappingResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.util.ElasticSearchUtils;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;

public class ElasticSearchJestClient
implements ElasticSearchClient<ElasticSearchJestClient> {
    protected String serverURL;
    protected String clusterName;
    protected String[] index;
    protected String[] type;
    protected ElasticSearchClientFactory clientFactory;
    protected ElasticSearchValueTypeMapper typeMapper;
    protected ElasticSearchUtils utils;
    private JestClient client;
    private ElasticSearchJestClient anotherClient;
    protected int timeout = 30000;

    public ElasticSearchJestClient(ElasticSearchClientFactory clientFactory, ElasticSearchValueTypeMapper typeMapper, ElasticSearchUtils utils) {
        this.clientFactory = clientFactory;
        this.typeMapper = typeMapper;
        this.utils = utils;
    }

    @Override
    public ElasticSearchJestClient serverURL(String serverURL) {
        this.serverURL = serverURL;
        if (this.clusterName != null) {
            this.buildClient();
        }
        return this;
    }

    @Override
    public ElasticSearchJestClient index(String ... indexes) {
        this.index = indexes;
        if (this.serverURL != null && this.clusterName != null) {
            this.buildClient();
        }
        return this;
    }

    @Override
    public ElasticSearchJestClient type(String ... types) {
        this.type = types;
        if (this.serverURL != null && this.clusterName != null) {
            if (this.index == null) {
                throw new IllegalArgumentException("You cannot call elasticsearchRESTEasyClient#type before calling elasticsearchRESTEasyClient#index.");
            }
            this.buildClient();
        }
        return this;
    }

    @Override
    public ElasticSearchJestClient clusterName(String clusterName) {
        this.clusterName = clusterName;
        if (this.serverURL != null) {
            this.buildClient();
        }
        return this;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public MappingsResponse getMappings(String ... index) throws ElasticSearchClientGenericException {
        if (this.client == null) {
            throw new IllegalArgumentException("elasticsearchRESTEasyClient instance is not build.");
        }
        try {
            IndexMappingResponse[] result = new IndexMappingResponse[index.length];
            int x = 0;
            for (String _index : index) {
                IndexMappingResponse indexMappings = this.getMappings(_index, (String)null);
                result[x++] = indexMappings;
            }
            return new MappingsResponse(200, result);
        }
        catch (Exception e) {
            throw new ElasticSearchClientGenericException("Cannot obtain mappings.", e);
        }
    }

    protected IndexMappingResponse getMappings(String index, String type) throws Exception {
        GetMapping.Builder builder = (GetMapping.Builder)new GetMapping.Builder().addIndex(index);
        if (type != null) {
            builder = (GetMapping.Builder)builder.addType(type);
        }
        GetMapping getMapping = builder.build();
        JestResult result = this.client.execute((Action)getMapping);
        Set mappings = result.getJsonObject().get(index).getAsJsonObject().get("mappings").getAsJsonObject().entrySet();
        TypeMappingResponse[] types = new TypeMappingResponse[mappings.size()];
        int x = 0;
        for (Map.Entry entry : mappings) {
            String typeName = (String)entry.getKey();
            JsonElement typeMappings = (JsonElement)entry.getValue();
            JsonElement properties = typeMappings.getAsJsonObject().get("properties");
            Set propertyMappings = properties.getAsJsonObject().entrySet();
            FieldMappingResponse[] fields = new FieldMappingResponse[propertyMappings.size()];
            int y = 0;
            for (Map.Entry propertyMapping : propertyMappings) {
                Set multiFields;
                String field = (String)propertyMapping.getKey();
                JsonElement element = (JsonElement)propertyMapping.getValue();
                FieldMapping fieldMappings = (FieldMapping)new Gson().fromJson(element, FieldMapping.class);
                FieldMappingResponse.FieldType fieldType = null;
                if (fieldMappings.getType() != null) {
                    fieldType = FieldMappingResponse.FieldType.valueOf(fieldMappings.getType().toUpperCase());
                }
                FieldMappingResponse.IndexType indexType = null;
                if (fieldMappings.getIndex() != null) {
                    indexType = FieldMappingResponse.IndexType.valueOf(fieldMappings.getIndex().toUpperCase());
                }
                String format = fieldMappings.getFormat();
                ArrayList<MultiFieldMappingResponse> multiFieldsResult = null;
                JsonElement multiFieldsElemement = element.getAsJsonObject().get("fields");
                if (multiFieldsElemement != null && (multiFields = multiFieldsElemement.getAsJsonObject().entrySet()) != null && !multiFields.isEmpty()) {
                    multiFieldsResult = new ArrayList<MultiFieldMappingResponse>(multiFields.size());
                    for (Map.Entry multiFieldEntry : multiFields) {
                        String multiFieldId = (String)multiFieldEntry.getKey();
                        JsonElement multiFieldElement = (JsonElement)multiFieldEntry.getValue();
                        if (multiFieldElement == null) continue;
                        JsonElement _dtElement = multiFieldElement.getAsJsonObject().get("type");
                        String _dt = _dtElement != null ? _dtElement.getAsString() : null;
                        JsonElement _itElement = multiFieldElement.getAsJsonObject().get("index");
                        String _it = _itElement != null ? _itElement.getAsString() : null;
                        FieldMappingResponse.FieldType multiFieldDataType = _dt != null ? FieldMappingResponse.FieldType.valueOf(_dt.toUpperCase()) : fieldType;
                        FieldMappingResponse.IndexType multiFieldIndexType = _it != null ? FieldMappingResponse.IndexType.valueOf(_it.toUpperCase()) : indexType;
                        MultiFieldMappingResponse multiFieldMappingResponse = new MultiFieldMappingResponse(multiFieldId, multiFieldDataType, multiFieldIndexType);
                        multiFieldsResult.add(multiFieldMappingResponse);
                    }
                }
                MultiFieldMappingResponse[] multiFieldsArray = multiFieldsResult == null ? null : multiFieldsResult.toArray(new MultiFieldMappingResponse[multiFieldsResult.size()]);
                FieldMappingResponse fieldMappingResponse = new FieldMappingResponse(field, fieldType, indexType, format, multiFieldsArray);
                fields[y++] = fieldMappingResponse;
            }
            TypeMappingResponse typeMappingResponse = new TypeMappingResponse(typeName, fields);
            types[x++] = typeMappingResponse;
        }
        return new IndexMappingResponse(index, types);
    }

    @Override
    public CountResponse count(String[] index, String ... type) throws ElasticSearchClientGenericException {
        if (this.client == null) {
            throw new IllegalArgumentException("elasticsearchRESTEasyClient instance is not build.");
        }
        Count.Builder countBuilder = (Count.Builder)new Count.Builder().addIndex(Arrays.asList(index));
        if (type != null) {
            countBuilder = (Count.Builder)countBuilder.addType(Arrays.asList(type));
        }
        Count count = countBuilder.build();
        try {
            CountResult result = (CountResult)this.client.execute((Action)count);
            double hitCount = result.getCount();
            int totalShards = result.getJsonObject().get("_shards").getAsJsonObject().get("total").getAsInt();
            return new CountResponse((long)hitCount, totalShards);
        }
        catch (Exception e) {
            throw new ElasticSearchClientGenericException("Cannot count.", e);
        }
    }

    @Override
    public SearchResponse search(DataSetDef definition, DataSetMetadata metadata, SearchRequest request) throws ElasticSearchClientGenericException {
        if (this.client == null) {
            throw new NullPointerException("No client");
        }
        ElasticSearchDataSetDef elasticSearchDataSetDef = (ElasticSearchDataSetDef)definition;
        int start = request.getStart();
        int size = request.getSize();
        List<DataSetGroup> aggregations = request.getAggregations();
        List<DataSetSort> sorting = request.getSorting();
        Query query = request.getQuery();
        List<DataColumn> columns = Collections.unmodifiableList(request.getColumns());
        GsonBuilder builder = new GsonBuilder();
        AggregationSerializer aggregationSerializer = new AggregationSerializer(this, metadata, columns, request);
        QuerySerializer querySerializer = new QuerySerializer(this, metadata, columns);
        SearchQuerySerializer searchQuerySerializer = new SearchQuerySerializer(this, metadata, columns);
        SearchResponseDeserializer searchResponseDeserializer = new SearchResponseDeserializer(this, metadata, columns);
        HitDeserializer hitDeserializer = new HitDeserializer(this, metadata, columns);
        AggregationsDeserializer aggreationsDeserializer = new AggregationsDeserializer(this, metadata, columns);
        builder.registerTypeAdapter(DataSetGroup.class, (Object)aggregationSerializer);
        builder.registerTypeAdapter(Query.class, (Object)querySerializer);
        builder.registerTypeAdapter(SearchQuery.class, (Object)searchQuerySerializer);
        builder.registerTypeAdapter(SearchResponse.class, (Object)searchResponseDeserializer);
        builder.registerTypeAdapter(SearchHitResponse.class, (Object)hitDeserializer);
        builder.registerTypeAdapter(SearchHitResponse[].class, (Object)aggreationsDeserializer);
        Gson gson = builder.create();
        JsonElement gsonQueryElement = gson.toJsonTree((Object)query);
        JsonObject gsonQuery = null;
        if (gsonQueryElement instanceof JsonObject) {
            gsonQuery = (JsonObject)gsonQueryElement;
        }
        LinkedList<JsonObject> aggregationObjects = null;
        if (aggregations != null && !aggregations.isEmpty()) {
            aggregationObjects = new LinkedList<JsonObject>();
            for (DataSetGroup aggregation : aggregations) {
                JsonElement object = gson.toJsonTree((Object)aggregation, DataSetGroup.class);
                if (object == null || !object.isJsonObject()) continue;
                aggregationObjects.add((JsonObject)object);
            }
        }
        SearchQuery searchQuery = new SearchQuery(this.getColumnIds(columns), gsonQuery, aggregationObjects, start, size);
        String serializedSearchQuery = gson.toJson((Object)searchQuery, SearchQuery.class);
        Search.Builder searchRequestBuilder = (Search.Builder)new Search.Builder(serializedSearchQuery).addIndex(this.index[0]);
        if (this.type != null && this.type.length > 0) {
            searchRequestBuilder.addType(this.type[0]);
        }
        if (sorting != null && !sorting.isEmpty()) {
            for (DataSetSort sortOp : sorting) {
                List columnSorts = sortOp.getColumnSortList();
                if (columnSorts == null || columnSorts.isEmpty()) continue;
                for (ColumnSort columnSort : columnSorts) {
                    Sort sort = new Sort(columnSort.getColumnId(), columnSort.getOrder().asInt() == 1 ? Sort.Sorting.ASC : Sort.Sorting.DESC);
                    searchRequestBuilder.addSort(sort);
                }
            }
        }
        Search searchRequest = searchRequestBuilder.build();
        JestResult result = null;
        try {
            this.log("REQUEST");
            this.log("*******");
            this.log(serializedSearchQuery);
            result = this.client.execute((Action)searchRequest);
        }
        catch (Exception e) {
            throw new ElasticSearchClientGenericException("An error ocurred during search operation.", e);
        }
        JsonObject resultObject = result.getJsonObject();
        if (resultObject.get("error") != null) {
            String errorMessage = resultObject.get("error").getAsString();
            throw new ElasticSearchClientGenericException("An error ocurred during search operation. This is the internal error: \n" + errorMessage);
        }
        this.log("RESPONSE");
        this.log("********");
        this.log(resultObject.toString());
        return (SearchResponse)gson.fromJson((JsonElement)resultObject, SearchResponse.class);
    }

    public ElasticSearchJestClient getAnotherClient(ElasticSearchDataSetDef def) {
        if (this.anotherClient == null) {
            this.anotherClient = (ElasticSearchJestClient)this.clientFactory.newClient(def);
        }
        return this.anotherClient;
    }

    protected String[] getColumnIds(List<DataColumn> columns) {
        if (columns == null || columns.isEmpty()) {
            return null;
        }
        String[] result = new String[columns.size()];
        for (int x = 0; x < columns.size(); ++x) {
            DataColumn column = columns.get(x);
            result[x] = column.getId();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.anotherClient != null) {
            this.anotherClient.close();
        }
        if (this.client != null) {
            this.client.shutdownClient();
        }
    }

    public Object parseValue(DataSetMetadata metadata, DataColumn column, JsonElement valueElement) throws ParseException {
        if (column == null || valueElement == null || valueElement.isJsonNull()) {
            return null;
        }
        if (!valueElement.isJsonPrimitive()) {
            throw new RuntimeException("Not expected JsonElement type to parse from query response.");
        }
        ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)metadata.getDefinition();
        JsonPrimitive valuePrimitive = valueElement.getAsJsonPrimitive();
        ColumnType columnType = column.getColumnType();
        if (ColumnType.TEXT.equals((Object)columnType)) {
            return this.typeMapper.parseText(def, column.getId(), valueElement.getAsString());
        }
        if (ColumnType.LABEL.equals((Object)columnType)) {
            boolean isColumnGroup = column.getColumnGroup() != null && column.getColumnGroup().getStrategy().equals((Object)GroupStrategy.FIXED);
            return this.typeMapper.parseLabel(def, column.getId(), valueElement.getAsString(), isColumnGroup);
        }
        if (ColumnType.NUMBER.equals((Object)columnType)) {
            return this.typeMapper.parseNumeric(def, column.getId(), valueElement.getAsString());
        }
        if (ColumnType.DATE.equals((Object)columnType)) {
            if (valuePrimitive.isString()) {
                return this.typeMapper.parseDate(def, column.getId(), valuePrimitive.getAsString());
            }
            if (valuePrimitive.isNumber()) {
                return this.typeMapper.parseDate(def, column.getId(), valuePrimitive.getAsLong());
            }
        }
        throw new UnsupportedOperationException("Cannot parse value for column with id [" + column.getId() + "] (Data Set UUID [" + def.getUUID() + "]). Value core type not supported. Expecting string or number or date core field types.");
    }

    public String formatValue(String columnId, DataSetMetadata metadata, Object value) {
        if (value == null) {
            return null;
        }
        ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)metadata.getDefinition();
        ColumnType columnType = metadata.getColumnType(columnId);
        if (ColumnType.TEXT.equals((Object)columnType)) {
            return this.typeMapper.formatText(def, columnId, value != null ? value.toString() : null);
        }
        if (ColumnType.LABEL.equals((Object)columnType)) {
            return this.typeMapper.formatLabel(def, columnId, value != null ? value.toString() : null);
        }
        if (ColumnType.DATE.equals((Object)columnType)) {
            return this.typeMapper.formatDate(def, columnId, (Date)value);
        }
        if (ColumnType.NUMBER.equals((Object)columnType)) {
            return this.typeMapper.formatNumeric(def, columnId, (Number)value);
        }
        throw new UnsupportedOperationException("Cannot format value for column with id [" + columnId + "] (Data Set UUID [" + def.getUUID() + "]). Value core type not supported. Expecting string or number or date core field types.");
    }

    public static String getInterval(DateIntervalType dateIntervalType) {
        String intervalExpression = null;
        switch (dateIntervalType) {
            case MILLISECOND: {
                intervalExpression = "0.001s";
                break;
            }
            case HUNDRETH: {
                intervalExpression = "0.01s";
                break;
            }
            case TENTH: {
                intervalExpression = "0.1s";
                break;
            }
            case SECOND: {
                intervalExpression = "1s";
                break;
            }
            case MINUTE: {
                intervalExpression = "1m";
                break;
            }
            case HOUR: {
                intervalExpression = "1h";
                break;
            }
            case DAY: {
                intervalExpression = "1d";
                break;
            }
            case DAY_OF_WEEK: {
                intervalExpression = "1d";
                break;
            }
            case WEEK: {
                intervalExpression = "1w";
                break;
            }
            case MONTH: {
                intervalExpression = "1M";
                break;
            }
            case QUARTER: {
                intervalExpression = "1q";
                break;
            }
            case YEAR: {
                intervalExpression = "1y";
                break;
            }
            case DECADE: {
                intervalExpression = "10y";
                break;
            }
            case CENTURY: {
                intervalExpression = "100y";
                break;
            }
            case MILLENIUM: {
                intervalExpression = "1000y";
                break;
            }
            default: {
                throw new RuntimeException("No interval mapping for date interval type [" + dateIntervalType.name() + "].");
            }
        }
        return intervalExpression;
    }

    protected JestClient buildClient() throws IllegalArgumentException {
        this.client = ElasticSearchJestClient.buildNewClient(this.serverURL, this.clusterName, this.timeout);
        return this.client;
    }

    public static JestClient buildNewClient(String serverURL, String clusterName, int timeout) throws IllegalArgumentException {
        if (serverURL == null || serverURL.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter serverURL is missing.");
        }
        if (clusterName == null || clusterName.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter clusterName is missing.");
        }
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(serverURL).multiThreaded(true)).connTimeout(timeout)).build());
        return factory.getObject();
    }

    public ElasticSearchClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public ElasticSearchValueTypeMapper getValueTypeMapper() {
        return this.typeMapper;
    }

    public ElasticSearchUtils getUtils() {
        return this.utils;
    }

    private void log(String message) {
    }

    public static class SearchQuery {
        String[] fields;
        JsonObject query;
        List<JsonObject> aggregations;
        int start;
        int size;

        public SearchQuery(String[] fields, JsonObject query, List<JsonObject> aggregations, int start, int size) {
            this.fields = fields;
            this.query = query;
            this.aggregations = aggregations;
            this.start = start;
            this.size = size;
        }

        public String[] getFields() {
            return this.fields;
        }

        public JsonObject getQuery() {
            return this.query;
        }

        public List<JsonObject> getAggregations() {
            return this.aggregations;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.size;
        }
    }
}

