/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson;

import com.google.gson.JsonElement;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchRequest;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;

public abstract class AbstractAdapter<T extends AbstractAdapter> {
    protected DataSetMetadata metadata;
    protected List<DataColumn> columns;
    protected ElasticSearchJestClient client;
    protected SearchRequest request;

    public AbstractAdapter(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns) {
        this(client, metadata, columns, null);
    }

    public AbstractAdapter(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns, SearchRequest request) {
        this.metadata = metadata;
        this.columns = columns;
        this.request = request;
        this.client = client;
    }

    protected ElasticSearchDataSetDef getDefinition() {
        return (ElasticSearchDataSetDef)this.metadata.getDefinition();
    }

    protected LinkedHashMap<String, Object> orderAndParseFields(DataSetMetadata metadata, Map<String, JsonElement> fields, List<DataColumn> columns) throws ParseException {
        if (fields == null) {
            return null;
        }
        if (columns == null) {
            return new LinkedHashMap<String, JsonElement>(fields);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (DataColumn column : columns) {
            String columnId = column.getId();
            if (!fields.containsKey(columnId)) continue;
            JsonElement valueElement = fields.get(columnId);
            Object value = this.client.parseValue(metadata, column, valueElement);
            result.put(columnId, value);
        }
        return result;
    }

    protected DataColumn getColumn(String columnId) {
        if (this.columns != null && columnId != null && !this.columns.isEmpty()) {
            for (DataColumn column : this.columns) {
                if (!columnId.equals(column.getId())) continue;
                return column;
            }
        }
        return null;
    }
}

