/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AbstractAdapter;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;

public class HitDeserializer
extends AbstractAdapter<HitDeserializer>
implements JsonDeserializer<SearchHitResponse> {
    public HitDeserializer(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns) {
        super(client, metadata, columns);
    }

    public SearchHitResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        SearchHitResponse result = null;
        if (typeOfT.equals(SearchHitResponse.class)) {
            String fieldName;
            Set _fields;
            JsonObject hitObject = (JsonObject)json;
            float score = 0.0f;
            JsonElement scoreElement = hitObject.get("_score");
            if (scoreElement != null && scoreElement.isJsonPrimitive()) {
                score = scoreElement.getAsFloat();
            }
            String index = hitObject.get("_index").getAsString();
            String id = hitObject.get("_id").getAsString();
            String type = hitObject.get("_type").getAsString();
            long version = 0L;
            HashMap<String, JsonElement> fields = new HashMap<String, JsonElement>();
            JsonElement sourceObject = hitObject.get("_source");
            JsonElement fieldsObject = hitObject.get("fields");
            if (fieldsObject != null && fieldsObject.isJsonObject()) {
                _fields = ((JsonObject)fieldsObject).entrySet();
                for (Map.Entry field : _fields) {
                    fieldName = (String)field.getKey();
                    JsonElement fieldValueArray = (JsonElement)field.getValue();
                    if (fieldValueArray == null || !fieldValueArray.isJsonArray()) continue;
                    for (JsonElement element : (JsonArray)fieldValueArray) {
                        if (element == null || !element.isJsonPrimitive()) continue;
                        fields.put(fieldName, element);
                    }
                }
            }
            if (sourceObject != null && sourceObject.isJsonObject()) {
                _fields = ((JsonObject)sourceObject).entrySet();
                for (Map.Entry field : _fields) {
                    fieldName = (String)field.getKey();
                    fields.put(fieldName, (JsonElement)field.getValue());
                }
            }
            result = this.createHitResponse(score, index, id, type, version, fields);
        }
        return result;
    }

    private SearchHitResponse createHitResponse(float score, String index, String id, String type, long version, Map<String, JsonElement> fields) throws JsonParseException {
        try {
            return new SearchHitResponse(score, index, id, type, version, this.orderAndParseFields(this.metadata, fields, this.columns));
        }
        catch (ParseException e) {
            throw new JsonParseException((Throwable)e);
        }
    }
}

