/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.ElasticSearchJestClient;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl.jest.gson.AbstractAdapter;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.EmptySearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;

public class SearchResponseDeserializer
extends AbstractAdapter<SearchResponseDeserializer>
implements JsonDeserializer<SearchResponse> {
    public SearchResponseDeserializer(ElasticSearchJestClient client, DataSetMetadata metadata, List<DataColumn> columns) {
        super(client, metadata, columns);
    }

    public SearchResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject responseObject;
        SearchResponse result = null;
        if (typeOfT.equals(SearchResponse.class) && (responseObject = json.getAsJsonObject()) != null) {
            long tookInMillis = responseObject.get("took").getAsLong();
            int responseStatus = 200;
            JsonObject shardsObject = responseObject.getAsJsonObject("_shards");
            int totalShards = shardsObject.get("total").getAsInt();
            int successfulShards = shardsObject.get("successful").getAsInt();
            int shardFailures = shardsObject.get("failed").getAsInt();
            List<SearchHitResponse> hits = null;
            Object[] hitsParseResult = this.parseTotalAndScore(responseObject);
            long totalHits = (Long)hitsParseResult[0];
            float maxScore = ((Float)hitsParseResult[1]).floatValue();
            JsonElement aggregations = responseObject.get("aggregations");
            boolean existAggregations = aggregations != null && aggregations.isJsonObject();
            hits = !existAggregations ? this.parseHits(responseObject, context) : this.parseAggregations(responseObject, context);
            result = hits == null || hits.isEmpty() ? new EmptySearchResponse(tookInMillis, responseStatus, totalHits, maxScore, totalShards, successfulShards, shardFailures) : new SearchResponse(tookInMillis, responseStatus, totalHits, maxScore, totalShards, successfulShards, shardFailures, hits.toArray(new SearchHitResponse[hits.size()]));
        }
        return result;
    }

    protected List<SearchHitResponse> parseAggregations(JsonObject responseObject, JsonDeserializationContext context) {
        SearchHitResponse[] hits;
        JsonObject aggregationsObject = responseObject.getAsJsonObject("aggregations");
        if (aggregationsObject != null && (hits = (SearchHitResponse[])context.deserialize((JsonElement)aggregationsObject, SearchHitResponse[].class)) != null) {
            return Arrays.asList(hits);
        }
        return null;
    }

    protected List<SearchHitResponse> parseHits(JsonObject responseObject, JsonDeserializationContext context) {
        JsonArray hitsArray;
        LinkedList<SearchHitResponse> hits = null;
        JsonObject hitsObject = responseObject.getAsJsonObject("hits");
        if (hitsObject != null && (hitsArray = hitsObject.getAsJsonArray("hits")) != null && hitsArray.size() > 0) {
            hits = new LinkedList<SearchHitResponse>();
            for (int i = 0; i < hitsArray.size(); ++i) {
                JsonElement hitResponseElement = hitsArray.get(i);
                SearchHitResponse hit = (SearchHitResponse)context.deserialize(hitResponseElement, SearchHitResponse.class);
                hits.add(hit);
            }
        }
        return hits;
    }

    protected Object[] parseTotalAndScore(JsonObject responseObject) {
        long totalHits = 0L;
        float maxScore = 0.0f;
        JsonObject hitsObject = responseObject.getAsJsonObject("hits");
        if (hitsObject != null) {
            JsonElement scoreElement;
            JsonElement totalElement = hitsObject.get("total");
            if (totalElement.isJsonPrimitive()) {
                totalHits = totalElement.getAsLong();
            }
            if ((scoreElement = hitsObject.get("max_score")).isJsonPrimitive()) {
                maxScore = scoreElement.getAsFloat();
            }
        }
        return new Object[]{totalHits, Float.valueOf(maxScore)};
    }
}

